<?php

/**
* @package   s9e\TextFormatter
* @copyright Copyright (c) 2010-2023 The s9e authors
* @license   http://www.opensource.org/licenses/mit-license.php The MIT License
*/
class Renderer_d4cf61ed65d9f6a7c3e897bd5bf917ef8de9b36c extends \s9e\TextFormatter\Renderers\PHP
{
	protected $params=['AMAZON_ASSOCIATE_TAG'=>'','AMAZON_ASSOCIATE_TAG_CA'=>'','AMAZON_ASSOCIATE_TAG_DE'=>'','AMAZON_ASSOCIATE_TAG_ES'=>'','AMAZON_ASSOCIATE_TAG_FR'=>'','AMAZON_ASSOCIATE_TAG_IN'=>'','AMAZON_ASSOCIATE_TAG_IT'=>'','AMAZON_ASSOCIATE_TAG_JP'=>'','AMAZON_ASSOCIATE_TAG_UK'=>'','DISCUSSION_URL'=>'https://forum.sardos.net/public/d/','L_WROTE'=>'','MEDIAEMBED_THEME'=>'','PROFILE_URL'=>'https://forum.sardos.net/public/u/','TAG_URL'=>'https://forum.sardos.net/public/t/','TASKLISTS_EDITABLE'=>''];
	protected function renderNode(\DOMNode $node)
	{
		switch($node->nodeName){case'ABCNEWS':$this->out.='<span data-s9e-mediaembed="abcnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//abcnews.go.com/video/embed?id='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'ACAST':$this->out.='<iframe data-s9e-mediaembed="acast" allowfullscreen="" loading="lazy" scrolling="no" src="https://embed.acast.com/'.htmlspecialchars($node->getAttribute('show_id'),2).'/'.htmlspecialchars($node->getAttribute('episode_id'),2).'?seek='.htmlspecialchars($node->getAttribute('t'),2).'" style="border:0;height:188px;max-width:900px;width:100%"></iframe>';break;case'AMAZON':$this->out.='<span data-s9e-mediaembed="amazon" style="display:inline-block;width:100%;max-width:120px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:200%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="background:url(https://www.amazon.com/favicon.ico) center no-repeat;border:0;height:100%;left:0;position:absolute;width:100%" src="//ws-';if($node->getAttribute('tld')==='jp')$this->out.='fe';elseif($node->hasAttribute('tld')&&str_contains('desfrinituk',$node->getAttribute('tld')))$this->out.='eu';else$this->out.='na';$this->out.='.assoc-amazon.com/widgets/cm?l=as1&amp;f=ifr&amp;o=';switch($node->getAttribute('tld')){case'ca':$this->out.='15&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_CA'],2);break;case'de':$this->out.='3&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_DE'],2);break;case'es':$this->out.='30&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_ES'],2);break;case'fr':$this->out.='8&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_FR'],2);break;case'in':$this->out.='31&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_IN'],2);break;case'it':$this->out.='29&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_IT'],2);break;case'jp':$this->out.='9&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_JP'],2);break;case'uk':$this->out.='2&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG_UK'],2);break;default:$this->out.='1&amp;t='.htmlspecialchars($this->params['AMAZON_ASSOCIATE_TAG'],2);}$this->out.='&amp;asins='.htmlspecialchars($node->getAttribute('id'),2).'"></iframe></span></span>';break;case'ANCHOR':$this->out.='<iframe data-s9e-mediaembed="anchor" allowfullscreen="" loading="lazy" scrolling="no" src="//anchor.fm/x/embed/episodes/x-'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:102px;max-width:768px;width:100%"></iframe>';break;case'APPLEPODCASTS':$this->out.='<iframe data-s9e-mediaembed="applepodcasts" allow="autoplay *;encrypted-media *" allowfullscreen="" loading="lazy" scrolling="no"';$this->out.=' src="https://embed.podcasts.apple.com/'.htmlspecialchars($node->getAttribute('country'),2).'/podcast/episode/id'.htmlspecialchars($node->getAttribute('podcast_id'),2).'?theme='.htmlspecialchars($this->params['MEDIAEMBED_THEME'],2);if($node->hasAttribute('episode_id'))$this->out.='&amp;i='.htmlspecialchars($node->getAttribute('episode_id'),2).'" style="border:0;height:175px;max-width:900px;width:100%"';else$this->out.='" style="border:0;height:450px;max-width:900px;width:100%"';$this->out.='></iframe>';break;case'AUDIOBOOM':$this->out.='<iframe data-s9e-mediaembed="audioboom" allowfullscreen="" loading="lazy" scrolling="no" src="//audioboom.com/posts/'.htmlspecialchars($node->getAttribute('id'),2).'/embed/v3" style="border:0;height:150px;max-width:700px;width:100%"></iframe>';break;case'AUDIOMACK':$this->out.='<iframe data-s9e-mediaembed="audiomack" allowfullscreen="" loading="lazy" scrolling="no"';if($node->getAttribute('mode')==='album'){$this->out.=' src="https://www.audiomack.com/embed/album/';if($node->hasAttribute('id'))$this->out.=htmlspecialchars($node->getAttribute('id'),2);else$this->out.=htmlspecialchars($node->getAttribute('artist'),2).'/'.htmlspecialchars($node->getAttribute('title'),2);$this->out.='" style="border:0;height:400px;max-width:900px;width:100%"';}else{$this->out.=' src="https://www.audiomack.com/embed/song/';if($node->hasAttribute('id'))$this->out.=htmlspecialchars($node->getAttribute('id'),2);else$this->out.=htmlspecialchars($node->getAttribute('artist'),2).'/'.htmlspecialchars($node->getAttribute('title'),2);$this->out.='" style="border:0;height:252px;max-width:900px;width:100%"';}$this->out.='></iframe>';break;case'AUDIUS':$this->out.='<iframe data-s9e-mediaembed="audius" allowfullscreen="" loading="lazy" scrolling="no" src="https://audius.co/embed/';if($node->hasAttribute('track_id'))$this->out.='track/'.htmlspecialchars($node->getAttribute('track_id'),2).'?flavor=compact';elseif($node->hasAttribute('album_id'))$this->out.='album/'.htmlspecialchars($node->getAttribute('album_id'),2).'?flavor=card';else$this->out.='playlist/'.htmlspecialchars($node->getAttribute('playlist_id'),2).'?flavor=card';$this->out.='" style="border:0;height:';if($node->hasAttribute('track_id'))$this->out.='12';else$this->out.='48';$this->out.='0px;max-width:';if($node->hasAttribute('track_id'))$this->out.='9';else$this->out.='4';$this->out.='00px;width:100%"></iframe>';break;case'B':$this->out.='<b>';$this->at($node);$this->out.='</b>';break;case'BANDCAMP':$this->out.='<span data-s9e-mediaembed="bandcamp" style="display:inline-block;width:100%;max-width:400px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//bandcamp.com/EmbeddedPlayer/size=large/minimal=true/';if($node->hasAttribute('album_id')){$this->out.='album='.htmlspecialchars($node->getAttribute('album_id'),2);if($node->hasAttribute('track_num'))$this->out.='/t='.htmlspecialchars($node->getAttribute('track_num'),2);}else$this->out.='track='.htmlspecialchars($node->getAttribute('track_id'),2);if($this->params['MEDIAEMBED_THEME']==='dark')$this->out.='/bgcol=333333/linkcol=0f91ff';$this->out.='"></iframe></span></span>';break;case'BBCNEWS':$this->out.='<span data-s9e-mediaembed="bbcnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.bbc.com/news/av-embeds/';if(str_starts_with($node->getAttribute('playlist'),'/news/'))if(str_contains($node->getAttribute('playlist'),'-'))$this->out.=htmlspecialchars(substr(strstr(substr(strstr(strtr($node->getAttribute('playlist'),'A','#'),'news/'),5),'-'),1),2);else$this->out.=htmlspecialchars(substr(strstr(strtr($node->getAttribute('playlist'),'A','/'),'/news/'),6),2);elseif(str_contains($node->getAttribute('id'),'/'))$this->out.=htmlspecialchars(substr(strstr($node->getAttribute('id'),'/'),1),2);else$this->out.=htmlspecialchars($node->getAttribute('id'),2);$this->out.='"></iframe></span></span>';break;case'BITCHUTE':$this->out.='<span data-s9e-mediaembed="bitchute" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.bitchute.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'BLEACHERREPORT':$this->out.='<span data-s9e-mediaembed="bleacherreport" style="display:inline-block;width:100%;max-width:320px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//bleacherreport.com/video_embed?id='.htmlspecialchars($node->getAttribute('id'),2).'&amp;library=video-cms" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'BRIGHTCOVE':$this->out.='<span data-s9e-mediaembed="brightcove" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="https://';if($node->hasAttribute('bckey'))$this->out.='link.brightcove.com/services/player/bcpid'.htmlspecialchars($node->getAttribute('bcpid'),2).'?bckey='.htmlspecialchars($node->getAttribute('bckey'),2).'&amp;bctid='.htmlspecialchars($node->getAttribute('bctid'),2).'&amp;secureConnections=true&amp;secureHTMLConnections=true&amp;autoStart=false&amp;height=360&amp;width=640';else$this->out.='players.brightcove.net/'.htmlspecialchars($node->getAttribute('bcpid'),2).'/default_default/index.html?videoId='.htmlspecialchars($node->getAttribute('bctid'),2);$this->out.='"></iframe></span></span>';break;case'BUNNY':$this->out.='<span data-s9e-mediaembed="bunny" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://iframe.mediadelivery.net/embed/'.htmlspecialchars($node->getAttribute('video_library_id'),2).'/'.htmlspecialchars($node->getAttribute('video_id'),2).'?autoplay=false" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'C':$this->out.='<code>';$this->at($node);$this->out.='</code>';break;case'CASTOS':$this->out.='<iframe data-s9e-mediaembed="castos" allowfullscreen="" loading="lazy" scrolling="no" src="https://player.castos.com/player/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:150px;max-width:900px;width:100%"></iframe>';break;case'CBSNEWS':$this->out.='<span data-s9e-mediaembed="cbsnews" style="display:inline-block;width:100%;max-width:640px"><span';if(str_contains($node->getAttribute('id'),'-'))$this->out.=' style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.cbsnews.com/embed/videos/'.htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe>';elseif($node->hasAttribute('pid'))$this->out.=' style="display:block;overflow:hidden;position:relative;padding-bottom:62.1875%;padding-bottom:calc(56.25% + 38px)"><object data="//www.cbsnews.com/common/video/cbsnews_player.swf" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"><param name="flashvars" value="pType=embed&amp;si=254&amp;pid='.htmlspecialchars($node->getAttribute('pid'),2).'"></object>';else$this->out.=' style="display:block;overflow:hidden;position:relative;padding-bottom:62.5%;padding-bottom:calc(56.25% + 40px)"><object data="//i.i.cbsi.com/cnwk.1d/av/video/cbsnews/atlantis2/cbsnews_player_embed.swf" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"><param name="flashvars" value="si=254&amp;contentValue='.htmlspecialchars($node->getAttribute('id'),2).'"></object>';$this->out.='</span></span>';break;case'CENTER':$this->out.='<div style="text-align:center">';$this->at($node);$this->out.='</div>';break;case'CLYP':$this->out.='<iframe data-s9e-mediaembed="clyp" allowfullscreen="" loading="lazy" scrolling="no" src="https://clyp.it/'.htmlspecialchars($node->getAttribute('id'),2).'/widget" style="border:0;height:265px;max-width:900px;width:100%"></iframe>';break;case'CNBC':$this->out.='<span data-s9e-mediaembed="cnbc" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://player.cnbc.com/p/gZWlPC/cnbc_global?playertype=synd&amp;byGuid='.htmlspecialchars($node->getAttribute('id'),2).'&amp;size=640_360" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'CNN':$this->out.='<span data-s9e-mediaembed="cnn" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//fave.api.cnn.io/v1/fav/?video='.htmlspecialchars($node->getAttribute('id'),2).'&amp;customer=cnn&amp;edition=international&amp;env=prod" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'CNNMONEY':$this->out.='<span data-s9e-mediaembed="cnnmoney" style="display:inline-block;width:100%;max-width:560px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:64.285714%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//money.cnn.com/.element/ssi/video/7.0/players/embed.player.html?videoid=video/'.htmlspecialchars($node->getAttribute('id'),2).'&amp;width=560&amp;height=360" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'CODE':$this->out.='<pre><code';if($node->hasAttribute('lang'))$this->out.=' class="language-'.htmlspecialchars($node->getAttribute('lang'),2).'"';$this->out.='>';$this->at($node);$this->out.='</code><script async="" crossorigin="anonymous" data-hljs-style="github" integrity="sha384-E9ssooeJ4kPel3JD7st0BgS50OLWFEdg4ZOp8lYPy52ctQazOIV37TCvzV8l4cYG" src="https://cdn.jsdelivr.net/gh/s9e/hljs-loader@1.0.34/loader.min.js"></script><script>
                    if(window.hljsLoader && !document.currentScript.parentNode.hasAttribute(\'data-s9e-livepreview-onupdate\')) {
                        window.hljsLoader.highlightBlocks(document.currentScript.parentNode);
                    }
                </script></pre>';break;case'CODEPEN':$this->out.='<iframe data-s9e-mediaembed="codepen" allowfullscreen="" loading="lazy" scrolling="no" src="https://codepen.io/'.htmlspecialchars($node->getAttribute('user'),2).'/embed/'.htmlspecialchars($node->getAttribute('id'),2).'?height=400&amp;default-tab=html,result" style="border:0;height:400px;width:100%"></iframe>';break;case'COLOR':$this->out.='<span style="color:'.htmlspecialchars($node->getAttribute('color'),2).'">';$this->at($node);$this->out.='</span>';break;case'COMEDYCENTRAL':$this->out.='<span data-s9e-mediaembed="comedycentral" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//media.mtvnservices.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'COUB':$this->out.='<span data-s9e-mediaembed="coub" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//coub.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'DAILYMOTION':$this->out.='<span data-s9e-mediaembed="dailymotion" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.dailymotion.com/embed/video/'.htmlspecialchars($node->getAttribute('id'),2);if($node->hasAttribute('t'))$this->out.='?start='.htmlspecialchars($node->getAttribute('t'),2);$this->out.='"></iframe></span></span>';break;case'DEL':$this->out.='<del>';$this->at($node);$this->out.='</del>';break;case'DEMOCRACYNOW':$this->out.='<span data-s9e-mediaembed="democracynow" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.democracynow.org/embed/';if(str_contains($node->getAttribute('id'),'/headlines'))$this->out.='headlines/'.htmlspecialchars(strstr($node->getAttribute('id'),'/headlines',true),2);elseif(str_starts_with($node->getAttribute('id'),'2'))$this->out.='story/'.htmlspecialchars($node->getAttribute('id'),2);elseif(str_starts_with($node->getAttribute('id'),'shows/'))$this->out.='show/'.htmlspecialchars(substr(strstr($node->getAttribute('id'),'/'),1),2);else$this->out.=htmlspecialchars($node->getAttribute('id'),2);$this->out.='"></iframe></span></span>';break;case'DUMPERT':$this->out.='<span data-s9e-mediaembed="dumpert" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.dumpert.nl/embed/'.htmlspecialchars(strtr($node->getAttribute('id'),'/','_'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'E':switch($node->textContent){case':\'(':$this->out.='😢';break;case':(':$this->out.='🙁';break;case':)':$this->out.='🙂';break;case':D':$this->out.='😃';break;case':O':$this->out.='😮';break;case':P':$this->out.='😛';break;case':|':$this->out.='😐';break;case';)':$this->out.='😉';break;case'>:(':$this->out.='😡';break;default:$this->out.=htmlspecialchars($node->textContent,0);}break;case'EIGHTTRACKS':$this->out.='<span data-s9e-mediaembed="eighttracks" style="display:inline-block;width:100%;max-width:400px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//8tracks.com/mixes/'.htmlspecialchars($node->getAttribute('id'),2).'/player_v3_universal" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'EM':$this->out.='<em>';$this->at($node);$this->out.='</em>';break;case'EMAIL':$this->out.='<a href="mailto:'.htmlspecialchars($node->getAttribute('email'),2).'">';$this->at($node);$this->out.='</a>';break;case'ESC':$this->at($node);break;case'ESPN':$this->out.='<span data-s9e-mediaembed="espn" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.espn.com/core/video/iframe?id='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'FACEBOOK':$this->out.='<iframe data-s9e-mediaembed="facebook" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" style="border:0;height:360px;max-width:640px;width:100%" src="https://s9e.github.io/iframe/2/facebook.min.html#';if($node->hasAttribute('user')){$this->out.=htmlspecialchars($node->getAttribute('user'),2).'/';if($node->getAttribute('type')==='r'||$node->getAttribute('type')==='v')$this->out.='video';else$this->out.='post';$this->out.='s/';if($node->hasAttribute('id'))$this->out.=htmlspecialchars($node->getAttribute('id'),2);else$this->out.='pfbid'.htmlspecialchars($node->getAttribute('pfbid'),2);}elseif($node->hasAttribute('id'))$this->out.=htmlspecialchars($node->getAttribute('type').$node->getAttribute('id'),2);else$this->out.='pfbid'.htmlspecialchars($node->getAttribute('pfbid'),2);$this->out.='"></iframe>';break;case'FALSTAD':$this->out.='<iframe data-s9e-mediaembed="falstad" allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:500px;max-height:90vh;width:100%" src="https://www.falstad.com/circuit/circuitjs.html?running=false&amp;c';if($node->hasAttribute('cct'))$this->out.='ct='.htmlspecialchars($node->getAttribute('cct'),2);else$this->out.='tz='.htmlspecialchars($node->getAttribute('ctz'),2);$this->out.='"></iframe>';break;case'FLICKR':$this->out.='<span data-s9e-mediaembed="flickr" style="display:inline-block;width:100%;max-width:500px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.flickr.com/photos/_/'.htmlspecialchars($node->getAttribute('id'),2).'/player/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'FOXNEWS':$this->out.='<span data-s9e-mediaembed="foxnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//video.foxnews.com/v/video-embed.html?video_id='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'FP':$this->out.=htmlspecialchars($node->getAttribute('char'),0);break;case'FUNNYORDIE':$this->out.='<span data-s9e-mediaembed="funnyordie" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.funnyordie.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GAMESPOT':$this->out.='<span data-s9e-mediaembed="gamespot" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.gamespot.com/videos/embed/'.htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GETTY':$this->out.='<span data-s9e-mediaembed="getty" style="display:inline-block;width:100%;max-width:'.htmlspecialchars($node->getAttribute('width'),2).'px"><span style="display:block;overflow:hidden;position:relative;';if($node->getAttribute('width')>0)$this->out.='padding-bottom:'.htmlspecialchars(100*$node->getAttribute('height')/$node->getAttribute('width'),2).'%';$this->out.='"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//embed.gettyimages.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'?et='.htmlspecialchars($node->getAttribute('et'),2).'&amp;tld=com&amp;sig='.htmlspecialchars($node->getAttribute('sig'),2).'&amp;caption=false&amp;ver=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GIFS':$this->out.='<span data-s9e-mediaembed="gifs" style="display:inline-block;width:100%;max-width:'.htmlspecialchars($node->getAttribute('width'),2).'px"><span style="display:block;overflow:hidden;position:relative;';if($node->getAttribute('width')>0)$this->out.='padding-bottom:'.htmlspecialchars(100*$node->getAttribute('height')/$node->getAttribute('width'),2).'%';$this->out.='"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//gifs.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GIPHY':$this->out.='<span data-s9e-mediaembed="giphy" style="display:inline-block;width:100%;max-width:'.htmlspecialchars($node->getAttribute('width'),2).'px"><span style="display:block;overflow:hidden;position:relative;';if($node->getAttribute('width')>0)$this->out.='padding-bottom:'.htmlspecialchars(100*$node->getAttribute('height')/$node->getAttribute('width'),2).'%';$this->out.='"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//giphy.com/embed/'.htmlspecialchars($node->getAttribute('id'),2);if($node->getAttribute('type')==='video')$this->out.='/video';$this->out.='"></iframe></span></span>';break;case'GIST':$this->out.='<iframe data-s9e-mediaembed="gist" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="" src="https://s9e.github.io/iframe/2/gist.min.html#'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:180px;width:100%"></iframe>';break;case'GITHUBCOMMIT':$this->out.='<a class="Github-embed github-commit-link" href="https://github.com/'.htmlspecialchars($node->getAttribute('repo'),2).'/commit/'.htmlspecialchars($node->getAttribute('commit').$node->getAttribute('comment').$node->getAttribute('diff'),2).'" target="_blank" rel="ugc noopener noreferrer"><i class="fab fa-github" aria-hidden="true"></i>'.htmlspecialchars($node->getAttribute('repo'),0).'<i class="fas fa-hashtag" aria-hidden="true"></i><code>'.htmlspecialchars(mb_substr($node->getAttribute('commit'),0,7,'utf-8'),0).'</code>';if($this->xpath->evaluate('string(@comment)and@comment!=\'\'',$node))$this->out.='<i class="fas fa-comment" aria-hidden="true"></i>';if($this->xpath->evaluate('string(@diff)and@diff!=\'\'',$node))$this->out.=' (diff)';$this->out.='</a>';break;case'GITHUBCOMPARE':$this->out.='<a class="Github-embed github-compare-link" href="https://github.com/'.htmlspecialchars($node->getAttribute('repo'),2).'/compare/'.htmlspecialchars($node->getAttribute('base'),2).'...'.htmlspecialchars($node->getAttribute('head'),2).'" target="_blank" rel="ugc noopener noreferrer"><i class="fab fa-github" aria-hidden="true"></i>'.htmlspecialchars($node->getAttribute('repo'),0).'<i class="fas fa-arrow-right" aria-hidden="true"></i><code>'.htmlspecialchars($node->getAttribute('base'),0).' → '.htmlspecialchars($node->getAttribute('head'),0).'</code></a>';break;case'GITHUBISSUE':$this->out.='<a class="Github-embed github-issue-link" href="https://github.com/'.htmlspecialchars($node->getAttribute('repo'),2).'/'.htmlspecialchars($node->getAttribute('type'),2).'/'.htmlspecialchars($node->getAttribute('issue').$node->getAttribute('comment'),2).'" target="_blank" rel="ugc noopener noreferrer"><i class="fab fa-github" aria-hidden="true"></i>'.htmlspecialchars($node->getAttribute('repo'),0).'<i class="fas fa-exclamation-circle" aria-hidden="true"></i>'.htmlspecialchars($node->getAttribute('issue'),0);if($this->xpath->evaluate('string(@comment)and@comment!=\'\'',$node))$this->out.='<i class="fas fa-comment" aria-hidden="true"></i>';$this->out.='</a>';break;case'GITHUBPR':$this->out.='<a class="Github-embed github-pr-link" target="_blank" rel="ugc noopener noreferrer" href="https://github.com/'.htmlspecialchars($node->getAttribute('repo'),2).'/pull/'.htmlspecialchars($node->getAttribute('pr'),2);if($this->xpath->evaluate('string(@comment)and@comment!=\'\'',$node))$this->out.=htmlspecialchars($node->getAttribute('comment'),2);if($this->xpath->evaluate('string(@commit)and@commit!=\'\'',$node))$this->out.='/commits/'.htmlspecialchars($node->getAttribute('commit'),2);$this->out.='"><i class="fab fa-github" aria-hidden="true"></i>'.htmlspecialchars($node->getAttribute('repo'),0).'<i class="fas fa-code-branch" aria-hidden="true"></i>'.htmlspecialchars($node->getAttribute('pr'),0);if($this->xpath->evaluate('string(@comment)and@comment!=\'\'',$node))$this->out.='<i class="fas fa-comment" aria-hidden="true"></i>';if($this->xpath->evaluate('string(@commit)and@commit!=\'\'',$node))$this->out.='<i class="fas fa-hashtag" aria-hidden="true"></i><code>'.htmlspecialchars(mb_substr($node->getAttribute('commit'),0,7,'utf-8'),0).'</code>';$this->out.='</a>';break;case'GITHUBREPO':$this->out.='<a class="Github-embed github-repo-link" href="https://github.com/'.htmlspecialchars($node->getAttribute('repo').$node->getAttribute('repopath'),2).'" target="_blank" rel="ugc noopener noreferrer"><i class="fab fa-github" aria-hidden="true"></i>'.htmlspecialchars($node->getAttribute('repo'),0);if($this->xpath->evaluate('string(@repopath)and@repopath!=\'\'',$node))$this->out.='<span class="github-repo-link--path">'.htmlspecialchars(mb_substr($node->getAttribute('repopath'),1,null,'utf-8'),0).'</span>';$this->out.='</a>';break;case'GLOBALNEWS':$this->out.='<span data-s9e-mediaembed="globalnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//globalnews.ca/video/embed/'.htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GOFUNDME':$this->out.='<span data-s9e-mediaembed="gofundme" style="display:inline-block;width:100%;max-width:349px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:118.911175%;padding-bottom:calc(59.312321% + 208px)"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.gofundme.com/mvc.php?route=widgets/mediawidget&amp;fund='.htmlspecialchars($node->getAttribute('id'),2).'&amp;image=1&amp;coinfo=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GOOGLEDRIVE':$this->out.='<span data-s9e-mediaembed="googledrive" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:75%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//drive.google.com/file/d/'.htmlspecialchars($node->getAttribute('id'),2).'/preview" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GOOGLEPLUS':$this->out.='<iframe data-s9e-mediaembed="googleplus" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" style="border:0;height:240px;max-width:450px;width:100%" src="https://s9e.github.io/iframe/2/googleplus.min.html#';if($node->hasAttribute('oid'))$this->out.=htmlspecialchars($node->getAttribute('oid'),2);else$this->out.='+'.htmlspecialchars($node->getAttribute('name'),2);$this->out.='/posts/'.htmlspecialchars($node->getAttribute('pid'),2).'"></iframe>';break;case'GOOGLESHEETS':if($node->getAttribute('type')==='chart')$this->out.='<span data-s9e-mediaembed="googlesheets" style="display:inline-block;width:100%;max-width:600px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:62%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://docs.google.com/spreadsheets/d/'.htmlspecialchars($node->getAttribute('id'),2).'/pubchart?oid='.htmlspecialchars($node->getAttribute('oid'),2).'&amp;format=interactive" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';else{$this->out.='<iframe data-s9e-mediaembed="googlesheets" allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:500px;resize:vertical;width:100%" src="https://docs.google.com/spreadsheets/d/'.htmlspecialchars($node->getAttribute('id'),2).'/p';if(str_starts_with($node->getAttribute('id'),'e/'))$this->out.='ubhtml?widget=true&amp;headers=false';else$this->out.='review';$this->out.='#gid='.htmlspecialchars($node->getAttribute('gid'),2).'"></iframe>';}break;case'GROUPMENTION':$this->out.='<span';if($node->getAttribute('deleted')!=1)if($this->xpath->evaluate('string(@color)!=\'\'',$node))$this->out.=' class="GroupMention GroupMention--colored" style="--color:'.htmlspecialchars($node->getAttribute('color'),2).';"';else$this->out.=' class="GroupMention"';else$this->out.=' class="GroupMention GroupMention--deleted"';$this->out.='><span class="GroupMention-name">@'.htmlspecialchars($node->getAttribute('groupname'),0).'</span>';if($this->xpath->evaluate('string(@icon)!=\'\'',$node))$this->out.='<i class="icon '.htmlspecialchars($node->getAttribute('icon'),2).'"></i>';$this->out.='</span>';break;case'H1':$this->out.='<h1>';$this->at($node);$this->out.='</h1>';break;case'H2':$this->out.='<h2>';$this->at($node);$this->out.='</h2>';break;case'H3':$this->out.='<h3>';$this->at($node);$this->out.='</h3>';break;case'H4':$this->out.='<h4>';$this->at($node);$this->out.='</h4>';break;case'H5':$this->out.='<h5>';$this->at($node);$this->out.='</h5>';break;case'H6':$this->out.='<h6>';$this->at($node);$this->out.='</h6>';break;case'HR':$this->out.='<hr>';break;case'HUDL':$this->out.='<span data-s9e-mediaembed="hudl" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.hudl.com/embed/';if($node->hasAttribute('id'))$this->out.='video/'.htmlspecialchars($node->getAttribute('id'),2);else$this->out.='athlete/'.htmlspecialchars($node->getAttribute('athlete'),2).'/highlights/'.htmlspecialchars($node->getAttribute('highlight'),2);$this->out.='"></iframe></span></span>';break;case'HULU':$this->out.='<span data-s9e-mediaembed="hulu" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://secure.hulu.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'I':$this->out.='<i>';$this->at($node);$this->out.='</i>';break;case'IGN':$this->out.='<span data-s9e-mediaembed="ign" style="display:inline-block;width:100%;max-width:468px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.196581%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//widgets.ign.com/video/embed/content.html?url='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'IMDB':$this->out.='<span data-s9e-mediaembed="imdb" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.imdb.com/video/imdb/vi'.htmlspecialchars($node->getAttribute('id'),2).'/imdb/embed?autoplay=false&amp;width=640" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'IMG':$this->out.='<img src="'.htmlspecialchars($node->getAttribute('src'),2).'" title="'.htmlspecialchars($node->getAttribute('title'),2).'" alt="'.htmlspecialchars($node->getAttribute('alt'),2).'"';if($node->hasAttribute('height'))$this->out.=' height="'.htmlspecialchars($node->getAttribute('height'),2).'"';if($node->hasAttribute('width'))$this->out.=' width="'.htmlspecialchars($node->getAttribute('width'),2).'"';$this->out.='>';break;case'IMGUR':$this->out.='<iframe data-s9e-mediaembed="imgur" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;{let s=this.style,d=e.data.split(\' \');s.height=d[0]+\'px\';s.width=d[1]+\'px\'};this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" style="border:0;height:400px;max-width:100%;width:542px" src="https://s9e.github.io/iframe/2/imgur.min.html#';if($node->getAttribute('type')==='album')$this->out.='a/';$this->out.=htmlspecialchars($node->getAttribute('id'),2).'"></iframe>';break;case'INDIEGOGO':$this->out.='<span data-s9e-mediaembed="indiegogo" style="display:inline-block;width:100%;max-width:222px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:200.45045%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.indiegogo.com/project/'.htmlspecialchars($node->getAttribute('id'),2).'/embedded" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'INSTAGRAM':$this->out.='<iframe data-s9e-mediaembed="instagram" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" style="border:0;height:542px;max-width:542px;width:100%" src="https://s9e.github.io/iframe/2/instagram.min.html#'.htmlspecialchars($node->getAttribute('id'),2);if($this->params['MEDIAEMBED_THEME']==='dark')$this->out.='#theme=dark';$this->out.='"></iframe>';break;case'INTERNETARCHIVE':if(str_contains($node->getAttribute('id'),'playlist=1'))$this->out.='<iframe data-s9e-mediaembed="internetarchive" allowfullscreen="" loading="lazy" scrolling="no" src="https://archive.org/embed/'.htmlspecialchars($node->getAttribute('id'),2).'&amp;list_height=150" style="border:0;height:170px;max-width:640px;width:100%"></iframe>';else{$this->out.='<span data-s9e-mediaembed="internetarchive" style="display:inline-block;width:100%;max-width:'.htmlspecialchars($node->getAttribute('width'),2).'px"><span style="display:block;overflow:hidden;position:relative;';if($node->getAttribute('width')>0)$this->out.='padding-bottom:'.htmlspecialchars(100*$node->getAttribute('height')/$node->getAttribute('width'),2).'%';$this->out.='"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://archive.org/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';}break;case'ISPOILER':$this->out.='<span class="spoiler" onclick="removeAttribute(\'class\')">';$this->at($node);$this->out.='</span>';break;case'IZLESENE':$this->out.='<span data-s9e-mediaembed="izlesene" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.izlesene.com/embedplayer/'.htmlspecialchars($node->getAttribute('id'),2).'?autoplay=0" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'JSFIDDLE':$this->out.='<iframe data-s9e-mediaembed="jsfiddle" allowfullscreen="" loading="lazy" scrolling="no" src="//jsfiddle.net/'.htmlspecialchars($node->getAttribute('id'),2).'/'.htmlspecialchars($node->getAttribute('revision'),2).'/embedded/'.htmlspecialchars($this->params['MEDIAEMBED_THEME'],2).'/" style="border:0;height:400px;width:100%"></iframe>';break;case'JWPLATFORM':$this->out.='<span data-s9e-mediaembed="jwplatform" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//content.jwplatform.com/players/'.htmlspecialchars($node->getAttribute('id'),2).'.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'KALTURA':$this->out.='<span data-s9e-mediaembed="kaltura" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:61.875%;padding-bottom:calc(56.25% + 36px)"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="https://cdnapisec.kaltura.com/p/'.htmlspecialchars($node->getAttribute('partner_id'),2).'/sp/';if($node->hasAttribute('sp'))$this->out.=htmlspecialchars($node->getAttribute('sp'),2);else$this->out.=htmlspecialchars($node->getAttribute('partner_id'),2).'00';$this->out.='/embedIframeJs/uiconf_id/'.htmlspecialchars($node->getAttribute('uiconf_id'),2).'/partner_id/'.htmlspecialchars($node->getAttribute('partner_id'),2).'?iframeembed=true&amp;entry_id='.htmlspecialchars($node->getAttribute('entry_id'),2).'"></iframe></span></span>';break;case'KHL':$this->out.='<span data-s9e-mediaembed="khl" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//video.khl.ru/iframe/feed/start/'.htmlspecialchars($node->getAttribute('id'),2).'?type_id=18&amp;width=560&amp;height=315" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'KICKSTARTER':$this->out.='<span data-s9e-mediaembed="kickstarter"';if($node->hasAttribute('video'))$this->out.=' style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.kickstarter.com/projects/'.htmlspecialchars($node->getAttribute('id'),2).'/widget/video.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span>';else$this->out.=' style="display:inline-block;width:100%;max-width:220px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:190.909091%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.kickstarter.com/projects/'.htmlspecialchars($node->getAttribute('id'),2).'/widget/card.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span>';$this->out.='</span>';break;case'LI':$this->out.='<li';if($this->xpath->evaluate('boolean(TASK)',$node))$this->out.=' data-task-id="'.htmlspecialchars($this->xpath->evaluate('string(TASK/@id)',$node),2).'" data-task-state="'.htmlspecialchars($this->xpath->evaluate('string(TASK/@state)',$node),2).'"';$this->out.='>';$this->at($node);$this->out.='</li>';break;case'LIBSYN':$this->out.='<iframe data-s9e-mediaembed="libsyn" allowfullscreen="" loading="lazy" scrolling="no" src="//html5-player.libsyn.com/embed/episode/id/'.htmlspecialchars($node->getAttribute('id'),2).'/thumbnail/no" style="border:0;height:90px;max-width:900px;width:100%"></iframe>';break;case'LIST':if(!$node->hasAttribute('type')){$this->out.='<ul>';$this->at($node);$this->out.='</ul>';}elseif(str_starts_with($node->getAttribute('type'),'decimal')||str_starts_with($node->getAttribute('type'),'lower')||str_starts_with($node->getAttribute('type'),'upper')){$this->out.='<ol style="list-style-type:'.htmlspecialchars($node->getAttribute('type'),2).'"';if($node->hasAttribute('start'))$this->out.=' start="'.htmlspecialchars($node->getAttribute('start'),2).'"';$this->out.='>';$this->at($node);$this->out.='</ol>';}else{$this->out.='<ul style="list-style-type:'.htmlspecialchars($node->getAttribute('type'),2).'">';$this->at($node);$this->out.='</ul>';}break;case'LIVELEAK':$this->out.='<span data-s9e-mediaembed="liveleak" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.liveleak.com/e/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'LIVESTREAM':$this->out.='<span data-s9e-mediaembed="livestream" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//';if($node->hasAttribute('clip_id'))$this->out.='cdn.livestream.com/embed/'.htmlspecialchars($node->getAttribute('channel'),2).'?layout=4&amp;autoplay=false&amp;clip='.htmlspecialchars($node->getAttribute('clip_id'),2);else{$this->out.='livestream.com/accounts/'.htmlspecialchars($node->getAttribute('account_id'),2).'/events/'.htmlspecialchars($node->getAttribute('event_id'),2);if($node->hasAttribute('video_id'))$this->out.='/videos/'.htmlspecialchars($node->getAttribute('video_id'),2);$this->out.='/player?autoPlay=false';}$this->out.='"></iframe></span></span>';break;case'MAILRU':$this->out.='<span data-s9e-mediaembed="mailru" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://my.mail.ru/video/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'MASTODON':$this->out.='<iframe data-s9e-mediaembed="mastodon" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" style="border:0;height:300px;max-width:550px;width:100%" src="https://s9e.github.io/iframe/2/mastodon.min.html#'.htmlspecialchars($node->getAttribute('name'),2);if($node->hasAttribute('host')&&$node->getAttribute('host')!=='mastodon.social')$this->out.='@'.htmlspecialchars($node->getAttribute('host'),2);$this->out.='/'.htmlspecialchars($node->getAttribute('id'),2).'"></iframe>';break;case'MEDIUM':$this->out.='<iframe data-s9e-mediaembed="medium" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/medium.min.html#'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:316px;max-width:900px;width:100%"></iframe>';break;case'MEGAPHONE':$this->out.='<iframe data-s9e-mediaembed="megaphone" allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:200px;max-width:900px;width:100%" src="https://player.megaphone.fm/'.htmlspecialchars($node->getAttribute('id'),2);if($this->params['MEDIAEMBED_THEME']==='light')$this->out.='?light=true';$this->out.='"></iframe>';break;case'METACAFE':$this->out.='<span data-s9e-mediaembed="metacafe" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.metacafe.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'MIXCLOUD':$this->out.='<iframe data-s9e-mediaembed="mixcloud" allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:120px;max-width:900px;width:100%" src="//www.mixcloud.com/widget/iframe/?feed=%2F'.htmlspecialchars($node->getAttribute('id'),2).'%2F&amp;light=';if($this->params['MEDIAEMBED_THEME']!=='dark')$this->out.='1';$this->out.='"></iframe>';break;case'MLB':$this->out.='<span data-s9e-mediaembed="mlb" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.mlb.com/video/share/c-'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'MRCTV':$this->out.='<span data-s9e-mediaembed="mrctv" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.mrctv.org/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'MSNBC':$this->out.='<span data-s9e-mediaembed="msnbc" style="display:inline-block;width:100%;max-width:640px"><span';if(str_contains($node->getAttribute('id'),'_'))$this->out.=' style="display:block;overflow:hidden;position:relative;padding-bottom:68.75%;padding-bottom:calc(56.25% + 80px)"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//player.theplatform.com/p/7wvmTC/MSNBCEmbeddedOffSite?guid=';else$this->out.=' style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.msnbc.com/msnbc/embedded-video/';$this->out.=htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe>';$this->out.='</span></span>';break;case'NATGEOCHANNEL':$this->out.='<span data-s9e-mediaembed="natgeochannel" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//channel.nationalgeographic.com/'.htmlspecialchars($node->getAttribute('id'),2).'/embed/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'NATGEOVIDEO':$this->out.='<span data-s9e-mediaembed="natgeovideo" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//player.d.nationalgeographic.com/players/ngsvideo/share/?guid='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'NBCNEWS':$this->out.='<span data-s9e-mediaembed="nbcnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.nbcnews.com/widget/video-embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'NBCSPORTS':$this->out.='<span data-s9e-mediaembed="nbcsports" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//vplayer.nbcsports.com/p/BxmELC/nbcsports_embed/select/media/'.htmlspecialchars($node->getAttribute('id'),2).'?parentUrl=" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'NHL':$this->out.='<span data-s9e-mediaembed="nhl" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="https://www.nhl.com/video/embed';if($node->hasAttribute('t'))$this->out.='/t-'.htmlspecialchars($node->getAttribute('t'),2);if($node->hasAttribute('c'))$this->out.='/c-'.htmlspecialchars($node->getAttribute('c'),2);$this->out.='?autostart=false"></iframe></span></span>';break;case'NPR':$this->out.='<iframe data-s9e-mediaembed="npr" allowfullscreen="" loading="lazy" scrolling="no" src="//www.npr.org/player/embed/'.htmlspecialchars($node->getAttribute('i'),2).'/'.htmlspecialchars($node->getAttribute('m'),2).'" style="border:0;height:228px;max-width:800px;width:100%"></iframe>';break;case'NYTIMES':$this->out.='<span data-s9e-mediaembed="nytimes" style="display:inline-block;width:100%;max-width:585px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:68.376068%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//graphics8.nytimes.com/video/players/offsite/index.html?videoId='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'ODYSEE':$this->out.='<span data-s9e-mediaembed="odysee" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="https://odysee.com/$/embed/';if($node->hasAttribute('id')){if($node->hasAttribute('name'))$this->out.=htmlspecialchars($node->getAttribute('name'),2);else$this->out.='-';$this->out.='/'.htmlspecialchars($node->getAttribute('id'),2);}else$this->out.=htmlspecialchars($node->getAttribute('path'),2);$this->out.='"></iframe></span></span>';break;case'ORFIUM':$this->out.='<iframe data-s9e-mediaembed="orfium" allowfullscreen="" loading="lazy" scrolling="no" src="https://www.orfium.com/embedded/';if($node->hasAttribute('album_id'))$this->out.='album/'.htmlspecialchars($node->getAttribute('album_id'),2);elseif($node->hasAttribute('playlist_id'))$this->out.='playlist/'.htmlspecialchars($node->getAttribute('playlist_id'),2);elseif($node->hasAttribute('set_id'))$this->out.='live-set/'.htmlspecialchars($node->getAttribute('set_id'),2);else$this->out.='track/'.htmlspecialchars($node->getAttribute('track_id'),2);$this->out.='" style="border:0;height:';if($node->hasAttribute('album_id'))$this->out.='550';else$this->out.='275';$this->out.='px;max-width:900px;width:100%"></iframe>';break;case'PASTEBIN':$this->out.='<iframe data-s9e-mediaembed="pastebin" allowfullscreen="" loading="lazy" scrolling="" src="//pastebin.com/embed_iframe.php?i='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:300px;resize:vertical;width:100%"></iframe>';break;case'PINTEREST':$this->out.='<iframe data-s9e-mediaembed="pinterest" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/pinterest.min.html#'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:360px;max-width:';if(str_contains($node->getAttribute('id'),'/'))$this->out.='730';else$this->out.='345';$this->out.='px;width:100%"></iframe>';break;case'PODBEAN':$this->out.='<iframe data-s9e-mediaembed="podbean" allowfullscreen="" loading="lazy" scrolling="no" src="https://www.podbean.com/player-v2/?i='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:150px;max-width:900px;width:100%"></iframe>';break;case'POSTMENTION':if($node->getAttribute('deleted')!=1)$this->out.='<a href="'.htmlspecialchars($this->params['DISCUSSION_URL'].$node->getAttribute('discussionid'),2).'/'.htmlspecialchars($node->getAttribute('number'),2).'" class="PostMention" data-id="'.htmlspecialchars($node->getAttribute('id'),2).'">'.htmlspecialchars($node->getAttribute('displayname'),0).'</a>';else$this->out.='<span class="PostMention PostMention--deleted" data-id="'.htmlspecialchars($node->getAttribute('id'),2).'">'.htmlspecialchars($node->getAttribute('displayname'),0).'</span>';break;case'PREZI':$this->out.='<span data-s9e-mediaembed="prezi" style="display:inline-block;width:100%;max-width:550px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:72.727273%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//prezi.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'QUOTE':$this->out.='<blockquote';if(!$node->hasAttribute('author'))$this->out.=' class="uncited"';$this->out.='><div>';if($node->hasAttribute('author'))$this->out.='<cite>'.htmlspecialchars($node->getAttribute('author'),0).' '.htmlspecialchars($this->params['L_WROTE'],0).'</cite>';$this->at($node);$this->out.='</div></blockquote>';break;case'REDDIT':$this->out.='<iframe data-s9e-mediaembed="reddit" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/reddit.min.html#'.htmlspecialchars($node->getAttribute('id').$node->getAttribute('path'),2).'#theme='.htmlspecialchars($this->params['MEDIAEMBED_THEME'],2).'" style="border:0;height:165px;max-width:800px;width:100%"></iframe>';break;case'RUMBLE':$this->out.='<span data-s9e-mediaembed="rumble" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://rumble.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'RUTUBE':$this->out.='<span data-s9e-mediaembed="rutube" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//rutube.ru/play/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'S':$this->out.='<s>';$this->at($node);$this->out.='</s>';break;case'SCRIBD':$this->out.='<iframe data-s9e-mediaembed="scribd" allowfullscreen="" loading="lazy" scrolling="no" src="https://www.scribd.com/embeds/'.htmlspecialchars($node->getAttribute('id'),2).'/content?view_mode=scroll&amp;show_recommendations=false" style="border:0;height:500px;resize:vertical;width:100%"></iframe>';break;case'SENDVID':$this->out.='<span data-s9e-mediaembed="sendvid" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//sendvid.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'SIZE':$this->out.='<span style="font-size:'.htmlspecialchars($node->getAttribute('size'),2).'px">';$this->at($node);$this->out.='</span>';break;case'SLIDESHARE':$this->out.='<span data-s9e-mediaembed="slideshare" style="display:inline-block;width:100%;max-width:597px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:81.407035%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.slideshare.net/slideshow/embed_code/key/'.htmlspecialchars($node->getAttribute('key'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'SOUNDCLOUD':$this->out.='<iframe data-s9e-mediaembed="soundcloud" allowfullscreen="" loading="lazy" scrolling="no" src="https://w.soundcloud.com/player/?url=';if($node->hasAttribute('playlist_id'))$this->out.='https%3A//api.soundcloud.com/playlists/'.htmlspecialchars($node->getAttribute('playlist_id'),2).'%3Fsecret_token%3D'.htmlspecialchars($node->getAttribute('secret_token'),2);elseif($node->hasAttribute('track_id'))$this->out.='https%3A//api.soundcloud.com/tracks/'.htmlspecialchars($node->getAttribute('track_id'),2).'%3Fsecret_token%3D'.htmlspecialchars($node->getAttribute('secret_token'),2);else{if(!str_contains($node->getAttribute('id'),'://'))$this->out.='https%3A//soundcloud.com/';$this->out.=htmlspecialchars($node->getAttribute('id'),2);}$this->out.='" style="border:0;height:';if($node->hasAttribute('playlist_id')||str_contains($node->getAttribute('id'),'/sets/'))$this->out.='450';else$this->out.='166';$this->out.='px;max-width:900px;width:100%"></iframe>';break;case'SPOILER':$this->out.='<details class="spoiler">';$this->at($node);$this->out.='</details>';break;case'SPORCLE':$this->out.='<iframe data-s9e-mediaembed="sporcle" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/sporcle.min.html#'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:535px;max-width:820px;width:100%"></iframe>';break;case'SPORTSNET':$this->out.='<span data-s9e-mediaembed="sportsnet" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//players.brightcove.net/1704050871/rkedLxwfab_default/index.html?videoId='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'SPOTIFY':$this->out.='<iframe data-s9e-mediaembed="spotify" allow="encrypted-media" allowfullscreen="" loading="lazy" scrolling="no" src="https://open.spotify.com/embed/'.htmlspecialchars(strtr($node->getAttribute('id'),':','/').$node->getAttribute('path'),2).'" style="border:0;border-radius:12px;height:';if(str_starts_with($node->getAttribute('id'),'episode')||str_starts_with($node->getAttribute('id'),'show')||str_starts_with($node->getAttribute('id'),'track'))$this->out.='152';else$this->out.='380';$this->out.='px;max-width:900px;width:100%"></iframe>';break;case'SPREAKER':$this->out.='<iframe data-s9e-mediaembed="spreaker" allowfullscreen="" loading="lazy" scrolling="no" src="https://widget.spreaker.com/player?episode_id='.htmlspecialchars($node->getAttribute('episode_id'),2).'&amp;show_id='.htmlspecialchars($node->getAttribute('show_id'),2).'&amp;theme='.htmlspecialchars($this->params['MEDIAEMBED_THEME'],2).'" style="border:0;height:'.htmlspecialchars(400-200*$node->hasAttribute('episode_id'),2).'px;max-width:900px;width:100%"></iframe>';break;case'STEAMSTORE':$this->out.='<iframe data-s9e-mediaembed="steamstore" allowfullscreen="" loading="lazy" scrolling="no" src="//store.steampowered.com/widget/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:190px;max-width:900px;width:100%"></iframe>';break;case'STITCHER':$this->out.='<iframe data-s9e-mediaembed="stitcher" allowfullscreen="" loading="lazy" scrolling="no" src="https://www.stitcher.com/embed/'.htmlspecialchars($node->getAttribute('fid'),2).'/'.htmlspecialchars($node->getAttribute('eid'),2).'" style="border:0;height:150px;max-width:900px;width:100%"></iframe>';break;case'STRAWPOLL':$this->out.='<span data-s9e-mediaembed="strawpoll" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="" src="//www.strawpoll.me/embed_1/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'STREAMABLE':$this->out.='<span data-s9e-mediaembed="streamable" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//streamable.com/e/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'STREAMJA':$this->out.='<span data-s9e-mediaembed="streamja" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://streamja.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'STRONG':$this->out.='<strong>';$this->at($node);$this->out.='</strong>';break;case'SUB':$this->out.='<sub>';$this->at($node);$this->out.='</sub>';break;case'SUP':$this->out.='<sup>';$this->at($node);$this->out.='</sup>';break;case'TABLE':$this->out.='<table>';$this->at($node);$this->out.='</table>';break;case'TAGMENTION':if($node->getAttribute('deleted')!=1){$this->out.='<a href="'.htmlspecialchars($this->params['TAG_URL'].$node->getAttribute('slug'),2).'" data-id="'.htmlspecialchars($node->getAttribute('id'),2).'" class="TagMention';if($node->getAttribute('color')!=='')$this->out.=' TagMention--colored';$this->out.='" style="';if($node->getAttribute('color')!=='')$this->out.='--color:'.htmlspecialchars($node->getAttribute('color'),2);$this->out.='"><span class="TagMention-text">';if($node->getAttribute('icon')!=='')$this->out.='<i class="icon '.htmlspecialchars($node->getAttribute('icon'),2).'"></i>';$this->out.=htmlspecialchars($node->getAttribute('tagname'),0).'</span></a>';}else$this->out.='<span class="TagMention TagMention--deleted" data-id="'.htmlspecialchars($node->getAttribute('id'),2).'"><span class="TagMention-text">'.htmlspecialchars($node->getAttribute('tagname'),0).'</span></span>';break;case'TASK':$this->out.='<input data-task-id="'.htmlspecialchars($node->getAttribute('id'),2).'" type="checkbox"';if($node->getAttribute('state')==='checked')$this->out.=' checked';if($this->params['TASKLISTS_EDITABLE']==='')$this->out.=' disabled';$this->out.='>';break;case'TBODY':$this->out.='<tbody>';$this->at($node);$this->out.='</tbody>';break;case'TD':$this->out.='<td';if($node->hasAttribute('align'))$this->out.=' style="text-align:'.htmlspecialchars($node->getAttribute('align'),2).'"';$this->out.='>';$this->at($node);$this->out.='</td>';break;case'TEAMCOCO':$this->out.='<span data-s9e-mediaembed="teamcoco" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//teamcoco.com/embed/v/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'TED':$this->out.='<span data-s9e-mediaembed="ted" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//embed.ted.com/'.htmlspecialchars($node->getAttribute('id'),2);if(!str_contains($node->getAttribute('id'),'.html'))$this->out.='.html';$this->out.='"></iframe></span></span>';break;case'TELEGRAM':$this->out.='<iframe data-s9e-mediaembed="telegram" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" style="border:0;height:96px;max-width:500px;width:100%" src="https://s9e.github.io/iframe/2/telegram.min.html#'.htmlspecialchars($node->getAttribute('id'),2);if($this->params['MEDIAEMBED_THEME']==='dark')$this->out.='#theme=dark';$this->out.='"></iframe>';break;case'TH':$this->out.='<th';if($node->hasAttribute('align'))$this->out.=' style="text-align:'.htmlspecialchars($node->getAttribute('align'),2).'"';$this->out.='>';$this->at($node);$this->out.='</th>';break;case'THEAD':$this->out.='<thead>';$this->at($node);$this->out.='</thead>';break;case'THEATLANTIC':$this->out.='<span data-s9e-mediaembed="theatlantic" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.theatlantic.com/video/iframe/'.htmlspecialchars($node->getAttribute('id'),2).'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'THEGUARDIAN':$this->out.='<span data-s9e-mediaembed="theguardian" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//embed.theguardian.com/embed/video/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'THEONION':$this->out.='<span data-s9e-mediaembed="theonion" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.theonion.com/video_embed/?id='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'THREADS':$this->out.='<iframe data-s9e-mediaembed="threads" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/threads.min.html#'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:300px;max-width:550px;width:100%"></iframe>';break;case'TIKTOK':$this->out.='<iframe data-s9e-mediaembed="tiktok" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/tiktok.min.html#'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:740px;max-width:325px;width:100%"></iframe>';break;case'TMZ':$this->out.='<span data-s9e-mediaembed="tmz" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.kaltura.com/index.php/kwidget/cache_st/133592691/wid/_591531/partner_id/591531/uiconf_id/9071262/entry_id/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'TR':$this->out.='<tr>';$this->at($node);$this->out.='</tr>';break;case'TRADINGVIEW':$this->out.='<iframe data-s9e-mediaembed="tradingview" allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:400px;width:100%" src="https://s.tradingview.com/';if($node->hasAttribute('symbol'))$this->out.='widgetembed/?interval=D&amp;symbol='.htmlspecialchars(strtr($node->getAttribute('symbol'),'-',':'),2);else$this->out.='embed/'.htmlspecialchars($node->getAttribute('chart'),2);$this->out.='"></iframe>';break;case'TRAILERADDICT':$this->out.='<span data-s9e-mediaembed="traileraddict" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//v.traileraddict.com/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'TRENDINGVIEWS':$this->out.='<span data-s9e-mediaembed="trendingviews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://trendingviews.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'TUMBLR':$this->out.='<iframe data-s9e-mediaembed="tumblr" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/tumblr.min.html#'.htmlspecialchars($node->getAttribute('key'),2).'/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:300px;max-width:542px;width:100%"></iframe>';break;case'TWENTYFOURSEVENSPORTS':if($node->hasAttribute('video_id'))$this->out.='<span data-s9e-mediaembed="twentyfoursevensports" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.cbssports.com/video/player/embed?args=player_id%3D'.htmlspecialchars($node->getAttribute('video_id'),2).'%26channel%3Dmobilevideo%26pcid%3D'.htmlspecialchars($node->getAttribute('video_id'),2).'%26width%3D640%26height%3D360%26autoplay%3Dfalse%26comp_ads_enabled%3Dfalse%26uvpc%3Dhttp%3A%2F%2Fsports.cbsimg.net%2Fvideo%2Fuvp%2Fconfig%2Fv4%2Fuvp_247sports.xml%26uvpc_m%3Dhttp%3A%2F%2Fsports.cbsimg.net%2Fvideo%2Fuvp%2Fconfig%2Fv4%2Fuvp_247sports_m.xml%26partner%3D247%26partner_m%3D247_mobile%26utag%3D247sportssite%26resizable%3Dtrue" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';else$this->out.='<iframe data-s9e-mediaembed="twentyfoursevensports" allowfullscreen="" loading="lazy" onload="window.addEventListener(\'message\',function(e){if(e.source===this.contentWindow&amp;&amp;e.data.height)this.style.height=e.data.height+\'px\'})" scrolling="no" src="https://247sports.com/PlayerSport/'.htmlspecialchars($node->getAttribute('player_id'),2).'/Embed/" style="border:0;height:200px;max-width:600px;width:100%"></iframe>';break;case'TWITCH':$this->out.='<span data-s9e-mediaembed="twitch" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" onload="this.contentWindow.postMessage(\'\',\'*\')" scrolling="no" src="https://s9e.github.io/iframe/2/twitch.min.html#channel='.htmlspecialchars($node->getAttribute('channel'),2).';clip_id='.htmlspecialchars($node->getAttribute('clip_id'),2).';t='.htmlspecialchars($node->getAttribute('t'),2).';video_id='.htmlspecialchars($node->getAttribute('video_id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'TWITTER':$this->out.='<iframe data-s9e-mediaembed="twitter" allow="autoplay *" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" style="border:0;height:350px;max-width:550px;width:100%" src="https://s9e.github.io/iframe/2/twitter.min.html#'.htmlspecialchars($node->getAttribute('id'),2);if($this->params['MEDIAEMBED_THEME']==='dark')$this->out.='#theme=dark';$this->out.='"></iframe>';break;case'U':$this->out.='<u>';$this->at($node);$this->out.='</u>';break;case'UPL-FILE':$this->out.='<div class="ButtonGroup" data-fof-upload-download-uuid="'.htmlspecialchars($node->getAttribute('uuid'),2).'"><div class="Button hasIcon Button--icon Button--primary"><i class="fas fa-download"></i></div><div class="Button">'.htmlspecialchars($node->getAttribute('content'),0).'</div><div class="Button">'.htmlspecialchars($node->getAttribute('size'),0).'</div></div>';break;case'UPL-IMAGE':$this->out.='<div class="fof-download row" data-fof-upload-download-uuid="'.htmlspecialchars($node->getAttribute('uuid'),2).'"><div class="card"><div class="wrapper" style="background:url('.htmlspecialchars($node->getAttribute('url'),2).') center / cover no-repeat"><div class="header"><ul class="menu-content"><li><div class="far fa-hdd"><span>'.htmlspecialchars($node->getAttribute('size'),0).'</span></div></li></ul></div><div class="data"><div class="content"><h4 class="title">'.htmlspecialchars($node->getAttribute('content'),0).'</h4><div class="Button Button--primary Button-icon Button--block"><i class="fas fa-download"></i></div></div></div></div></div></div>';break;case'UPL-IMAGE-PREVIEW':$this->out.='<img class="FoFUpload--Upl-Image-Preview" src="'.htmlspecialchars($node->getAttribute('url'),2).'" title="'.htmlspecialchars($node->getAttribute('title'),2).'" alt="'.htmlspecialchars($node->getAttribute('alt'),2).'" data-id="'.htmlspecialchars($node->getAttribute('uuid'),2).'" loading="lazy">';break;case'UPL-TEXT-PREVIEW':$this->out.='<figure class="FofUpload-TextPreview" data-loading="false" data-expanded="false" data-hassnippet="'.htmlspecialchars($node->getAttribute('has_snippet'),2).'"><figcaption class="FofUpload-TextPreviewTitle"><i aria-hidden="true" class="icon far fa-file"></i> '.htmlspecialchars($node->getAttribute('content'),0).'</figcaption><div class="FofUpload-TextPreviewSnippet"><pre><code data-preview-text="&lt;preview will appear here after posting&gt;" data-nosnippet-text="&lt;no preview snippet available&gt;">'.htmlspecialchars($node->getAttribute('snippet'),0).'</code></pre></div><div class="FofUpload-TextPreviewFull"></div><button type="button" class="Button hasIcon FofUpload-TextPreviewToggle"><i aria-hidden="true" class="icon fas fa-chevron-down Button-icon FofUpload-TextPreviewExpandIcon"></i><span class="Button-label FofUpload-TextPreviewExpand">
            Expand preview        </span><i aria-hidden="true" class="icon fas fa-chevron-up Button-icon FofUpload-TextPreviewCollapseIcon"></i><span class="Button-label FofUpload-TextPreviewCollapse">
            Collapse preview        </span><div data-size="small" class="FofUpload-TextPreviewToggleLoading LoadingIndicator-container LoadingIndicator-container--inline LoadingIndicator-container--small"><div aria-hidden="true" class="LoadingIndicator"></div></div></button><div class="FofUpload-TextPreviewError"><p><i aria-hidden="true" class="icon fas fa-exclamation-circle"></i>
            Error previewing file. It may have been deleted, or the provided file ID is invalid.
        </p></div><script>
        {
            const figure = document.currentScript.parentElement;

            const previewEl = figure.querySelector(\'.FofUpload-TextPreviewFull\');
            const snippetEl = figure.querySelector(\'.FofUpload-TextPreviewSnippet\');
            const loadingEl = figure.querySelector(\'.FofUpload-TextPreviewLoading\');
            const toggleBtn = figure.querySelector(\'.FofUpload-TextPreviewToggle\');

            const snippetText = \'\';

            const testUrl = new URL(location.origin);
            const url = new URL(\''.$node->getAttribute('url').'\');

            if (testUrl.origin !== url.origin) {
              // Prevent cross-origin requests
              handleError(new Error(\'Attempted to fetch a cross-origin file in text preview.\'));
            }

            function createCodeHtml(text) {
                const codeEl = document.createElement(\'code\');
                codeEl.innerText = text;

                return `<pre>${codeEl.outerHTML}`;
            }

            function handleError(e) {
                figure.setAttribute(\'data-error\', \'true\');

                console.group(\'[FoF Upload] Failed to preview text file.\');
                console.error(\'Failed to load text file: \' + url);
                console.log(e);
                console.groupEnd();
            }

            let fileContent = null;

            // Only allow toggling preview if showing a snippet
            if ('.$node->getAttribute('has_snippet').' && testUrl.origin === url.origin) {
                toggleBtn.addEventListener(\'click\', () => {
                    if (fileContent !== null) {
                        const expanded = figure.getAttribute(\'data-expanded\') === \'true\';
                        figure.setAttribute(\'data-expanded\', !expanded);
                        return;
                    }

                    figure.setAttribute(\'data-loading\', \'true\');

                    fetch(url)
                        .then(response => {
                            if (!response.ok) {
                                figure.setAttribute(\'data-loading\', \'false\');
                                throw response;
                            }

                            return response.text();
                        })
                        .then(text => {
                            fileContent = text;
                            previewEl.innerHTML = createCodeHtml(text);

                            figure.setAttribute(\'data-loading\', \'false\');
                            const expanded = figure.getAttribute(\'data-expanded\') === \'true\';
                            figure.setAttribute(\'data-expanded\', !expanded);
                        })
                        .catch(handleError);
                });
            }
        }
    </script></figure>';break;case'URL':$this->out.='<a href="'.htmlspecialchars($node->getAttribute('url'),2).'"';if($node->hasAttribute('rel'))$this->out.=' rel="'.htmlspecialchars($node->getAttribute('rel'),2).'"';if($node->hasAttribute('target'))$this->out.=' target="'.htmlspecialchars($node->getAttribute('target'),2).'"';if($node->hasAttribute('title'))$this->out.=' title="'.htmlspecialchars($node->getAttribute('title'),2).'"';$this->out.='>';$this->at($node);$this->out.='</a>';break;case'USERMENTION':if($node->getAttribute('deleted')!=1)$this->out.='<a href="'.htmlspecialchars($this->params['PROFILE_URL'].$node->getAttribute('slug'),2).'" class="UserMention">@'.htmlspecialchars($node->getAttribute('displayname'),0).'</a>';else$this->out.='<span class="UserMention UserMention--deleted">@'.htmlspecialchars($node->getAttribute('displayname'),0).'</span>';break;case'USTREAM':$this->out.='<span data-s9e-mediaembed="ustream" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.ustream.tv/embed/';if($node->hasAttribute('vid'))$this->out.='recorded/'.htmlspecialchars($node->getAttribute('vid'),2);else$this->out.=htmlspecialchars($node->getAttribute('cid'),2);$this->out.='?html5ui"></iframe></span></span>';break;case'VBOX7':$this->out.='<span data-s9e-mediaembed="vbox7" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//vbox7.com/emb/external.php?vid='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'VEOH':$this->out.='<span data-s9e-mediaembed="veoh" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:62.5%;padding-bottom:calc(56.25% + 40px)"><object data="//www.veoh.com/swf/webplayer/WebPlayer.swf?version=AFrontend.5.7.0.1509&amp;permalinkId=v'.htmlspecialchars($node->getAttribute('id'),2).'&amp;player=videodetailsembedded&amp;videoAutoPlay=0&amp;id=anonymous" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"></object></span></span>';break;case'VEVO':$this->out.='<span data-s9e-mediaembed="vevo" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://embed.vevo.com/?isrc='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'VIDEO':$this->out.='<video controls="" src="'.htmlspecialchars($node->getAttribute('src'),2).'"></video>';break;case'VIDEODETECTIVE':$this->out.='<span data-s9e-mediaembed="videodetective" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.videodetective.com/embed/video/?options=false&amp;autostart=false&amp;playlist=none&amp;publishedid='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'VIMEO':$this->out.='<span data-s9e-mediaembed="vimeo" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//player.vimeo.com/video/'.htmlspecialchars($node->getAttribute('id'),2);if($node->hasAttribute('h'))$this->out.='?h='.htmlspecialchars($node->getAttribute('h'),2);if($node->hasAttribute('t'))$this->out.='#t='.htmlspecialchars($node->getAttribute('t'),2);$this->out.='"></iframe></span></span>';break;case'VINE':$this->out.='<span data-s9e-mediaembed="vine" style="display:inline-block;width:100%;max-width:480px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://vine.co/v/'.htmlspecialchars($node->getAttribute('id'),2).'/embed/simple?audio=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'VK':$this->out.='<span data-s9e-mediaembed="vk" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//vk.com/video_ext.php?oid='.htmlspecialchars($node->getAttribute('oid'),2).'&amp;id='.htmlspecialchars($node->getAttribute('vid'),2).'&amp;hash='.htmlspecialchars($node->getAttribute('hash'),2).'&amp;hd=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'VOCAROO':$this->out.='<iframe data-s9e-mediaembed="vocaroo" allowfullscreen="" loading="lazy" scrolling="no" src="https://vocaroo.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:80px;max-width:900px;width:100%"></iframe>';break;case'VOX':$this->out.='<span data-s9e-mediaembed="vox" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//player.ooyala.com/iframe.html#pbid=a637d53c5c0a43c7bf4e342886b9d8b0&amp;ec='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'WASHINGTONPOST':$this->out.='<span data-s9e-mediaembed="washingtonpost" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.washingtonpost.com/video/c/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'WAVEKIT':$this->out.='<iframe data-s9e-mediaembed="wavekit" allowfullscreen="" loading="lazy" scrolling="no" src="https://play.wavekit.app/embed/';if($node->hasAttribute('playlist_id'))$this->out.='playlist/'.htmlspecialchars($node->getAttribute('playlist_id'),2);else$this->out.='audio/'.htmlspecialchars($node->getAttribute('audio_id'),2);$this->out.='" style="border:0;height:';if($node->hasAttribute('playlist_id'))$this->out.='40';else$this->out.='17';$this->out.='0px;max-width:900px;width:100%"></iframe>';break;case'WISTIA':if($node->getAttribute('type')==='audio')$this->out.='<iframe data-s9e-mediaembed="wistia" allowfullscreen="" loading="lazy" scrolling="no" src="https://fast.wistia.net/embed/iframe/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:218px;max-width:900px;width:100%"></iframe>';else$this->out.='<span data-s9e-mediaembed="wistia" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://fast.wistia.net/embed/iframe/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'WSHH':$this->out.='<span data-s9e-mediaembed="wshh" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//worldstarhiphop.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'WSJ':$this->out.='<span data-s9e-mediaembed="wsj" style="display:inline-block;width:100%;max-width:512px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//video-api.wsj.com/api-video/player/iframe.html?guid='.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'XBOXCLIPS':$this->out.='<span data-s9e-mediaembed="xboxclips" style="display:inline-block;width:100%;max-width:560px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//gameclips.io/'.htmlspecialchars($node->getAttribute('user'),2).'/'.htmlspecialchars($node->getAttribute('id'),2).'/embed" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'XBOXDVR':$this->out.='<span data-s9e-mediaembed="xboxdvr" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//gamerdvr.com/gamer/'.htmlspecialchars($node->getAttribute('user'),2).'/video/'.htmlspecialchars($node->getAttribute('id'),2).'/embed" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'YOUKU':$this->out.='<span data-s9e-mediaembed="youku" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//player.youku.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'YOUMAKER':$this->out.='<span data-s9e-mediaembed="youmaker" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.youmaker.com/embed/'.htmlspecialchars($node->getAttribute('id'),2).'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'YOUTUBE':$this->out.='<span data-s9e-mediaembed="youtube" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="background:url(https://i.ytimg.com/vi/'.htmlspecialchars($node->getAttribute('id'),2).'/hqdefault.jpg) 50% 50% / cover;border:0;height:100%;left:0;position:absolute;width:100%" src="https://www.youtube-nocookie.com/embed/'.htmlspecialchars($node->getAttribute('id'),2);if($node->hasAttribute('clip'))$this->out.='?clip='.htmlspecialchars($node->getAttribute('clip'),2).'&amp;clipt='.htmlspecialchars($node->getAttribute('clipt'),2);else{if($node->hasAttribute('list'))$this->out.='?list='.htmlspecialchars($node->getAttribute('list'),2);if($node->hasAttribute('t')){if($node->hasAttribute('list'))$this->out.='&amp;';else$this->out.='?';$this->out.='start='.htmlspecialchars($node->getAttribute('t'),2);}}$this->out.='"></iframe></span></span>';break;case'br':$this->out.='<br>';break;case'e':case'i':case's':break;case'p':$this->out.='<p>';$this->at($node);$this->out.='</p>';break;default:$this->at($node);}
	}
	/** {@inheritdoc} */
	public $enableQuickRenderer=true;
	/** {@inheritdoc} */
	protected $static=['/B'=>'</b>','/C'=>'</code>','/CENTER'=>'</div>','/CODE'=>'</code><script async="" crossorigin="anonymous" data-hljs-style="github" integrity="sha384-E9ssooeJ4kPel3JD7st0BgS50OLWFEdg4ZOp8lYPy52ctQazOIV37TCvzV8l4cYG" src="https://cdn.jsdelivr.net/gh/s9e/hljs-loader@1.0.34/loader.min.js"></script><script>
                    if(window.hljsLoader && !document.currentScript.parentNode.hasAttribute(\'data-s9e-livepreview-onupdate\')) {
                        window.hljsLoader.highlightBlocks(document.currentScript.parentNode);
                    }
                </script></pre>','/COLOR'=>'</span>','/DEL'=>'</del>','/EM'=>'</em>','/EMAIL'=>'</a>','/ESC'=>'','/H1'=>'</h1>','/H2'=>'</h2>','/H3'=>'</h3>','/H4'=>'</h4>','/H5'=>'</h5>','/H6'=>'</h6>','/I'=>'</i>','/ISPOILER'=>'</span>','/QUOTE'=>'</div></blockquote>','/S'=>'</s>','/SIZE'=>'</span>','/SPOILER'=>'</details>','/STRONG'=>'</strong>','/SUB'=>'</sub>','/SUP'=>'</sup>','/TABLE'=>'</table>','/TBODY'=>'</tbody>','/TD'=>'</td>','/TH'=>'</th>','/THEAD'=>'</thead>','/TR'=>'</tr>','/U'=>'</u>','/URL'=>'</a>','B'=>'<b>','C'=>'<code>','CENTER'=>'<div style="text-align:center">','DEL'=>'<del>','EM'=>'<em>','ESC'=>'','H1'=>'<h1>','H2'=>'<h2>','H3'=>'<h3>','H4'=>'<h4>','H5'=>'<h5>','H6'=>'<h6>','HR'=>'<hr>','I'=>'<i>','ISPOILER'=>'<span class="spoiler" onclick="removeAttribute(\'class\')">','S'=>'<s>','SPOILER'=>'<details class="spoiler">','STRONG'=>'<strong>','SUB'=>'<sub>','SUP'=>'<sup>','TABLE'=>'<table>','TBODY'=>'<tbody>','THEAD'=>'<thead>','TR'=>'<tr>','U'=>'<u>'];
	/** {@inheritdoc} */
	protected $dynamic=['ABCNEWS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="abcnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//abcnews.go.com/video/embed?id=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'ACAST'=>['(^[^ ]+(?> (?!(?:episode_id|show_id|t)=)[^=]+="[^"]*")*(?> episode_id="([^"]*)")?(?> (?!(?:show_id|t)=)[^=]+="[^"]*")*(?> show_id="([^"]*)")?(?> (?!t=)[^=]+="[^"]*")*(?> t="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="acast" allowfullscreen="" loading="lazy" scrolling="no" src="https://embed.acast.com/$2/$1?seek=$3" style="border:0;height:188px;max-width:900px;width:100%"></iframe>'],'ANCHOR'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="anchor" allowfullscreen="" loading="lazy" scrolling="no" src="//anchor.fm/x/embed/episodes/x-$1" style="border:0;height:102px;max-width:768px;width:100%"></iframe>'],'AUDIOBOOM'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="audioboom" allowfullscreen="" loading="lazy" scrolling="no" src="//audioboom.com/posts/$1/embed/v3" style="border:0;height:150px;max-width:700px;width:100%"></iframe>'],'BITCHUTE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="bitchute" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.bitchute.com/embed/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'BLEACHERREPORT'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="bleacherreport" style="display:inline-block;width:100%;max-width:320px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//bleacherreport.com/video_embed?id=$1&amp;library=video-cms" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'BUNNY'=>['(^[^ ]+(?> (?!video_(?:library_)?id=)[^=]+="[^"]*")*(?> video_id="([^"]*)")?(?> (?!video_library_id=)[^=]+="[^"]*")*(?> video_library_id="([^"]*)")?.*)s','<span data-s9e-mediaembed="bunny" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://iframe.mediadelivery.net/embed/$2/$1?autoplay=false" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'CASTOS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="castos" allowfullscreen="" loading="lazy" scrolling="no" src="https://player.castos.com/player/$1" style="border:0;height:150px;max-width:900px;width:100%"></iframe>'],'CLYP'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="clyp" allowfullscreen="" loading="lazy" scrolling="no" src="https://clyp.it/$1/widget" style="border:0;height:265px;max-width:900px;width:100%"></iframe>'],'CNBC'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="cnbc" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://player.cnbc.com/p/gZWlPC/cnbc_global?playertype=synd&amp;byGuid=$1&amp;size=640_360" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'CNN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="cnn" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//fave.api.cnn.io/v1/fav/?video=$1&amp;customer=cnn&amp;edition=international&amp;env=prod" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'CNNMONEY'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="cnnmoney" style="display:inline-block;width:100%;max-width:560px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:64.285714%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//money.cnn.com/.element/ssi/video/7.0/players/embed.player.html?videoid=video/$1&amp;width=560&amp;height=360" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'CODEPEN'=>['(^[^ ]+(?> (?!(?:id|user)=)[^=]+="[^"]*")*(?> id="([^"]*)")?(?> (?!user=)[^=]+="[^"]*")*(?> user="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="codepen" allowfullscreen="" loading="lazy" scrolling="no" src="https://codepen.io/$2/embed/$1?height=400&amp;default-tab=html,result" style="border:0;height:400px;width:100%"></iframe>'],'COLOR'=>['(^[^ ]+(?> (?!color=)[^=]+="[^"]*")*(?> color="([^"]*)")?.*)s','<span style="color:$1">'],'COMEDYCENTRAL'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="comedycentral" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//media.mtvnservices.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'COUB'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="coub" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//coub.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'EIGHTTRACKS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="eighttracks" style="display:inline-block;width:100%;max-width:400px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//8tracks.com/mixes/$1/player_v3_universal" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'EMAIL'=>['(^[^ ]+(?> (?!email=)[^=]+="[^"]*")*(?> email="([^"]*)")?.*)s','<a href="mailto:$1">'],'ESPN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="espn" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.espn.com/core/video/iframe?id=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'FLICKR'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="flickr" style="display:inline-block;width:100%;max-width:500px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.flickr.com/photos/_/$1/player/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'FOXNEWS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="foxnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//video.foxnews.com/v/video-embed.html?video_id=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'FUNNYORDIE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="funnyordie" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.funnyordie.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'GAMESPOT'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="gamespot" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.gamespot.com/videos/embed/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'GIST'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="gist" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="" src="https://s9e.github.io/iframe/2/gist.min.html#$1" style="border:0;height:180px;width:100%"></iframe>'],'GLOBALNEWS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="globalnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//globalnews.ca/video/embed/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'GOFUNDME'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="gofundme" style="display:inline-block;width:100%;max-width:349px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:118.911175%;padding-bottom:calc(59.312321% + 208px)"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.gofundme.com/mvc.php?route=widgets/mediawidget&amp;fund=$1&amp;image=1&amp;coinfo=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'GOOGLEDRIVE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="googledrive" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:75%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//drive.google.com/file/d/$1/preview" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'HULU'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="hulu" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://secure.hulu.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'IGN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="ign" style="display:inline-block;width:100%;max-width:468px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.196581%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//widgets.ign.com/video/embed/content.html?url=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'IMDB'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="imdb" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.imdb.com/video/imdb/vi$1/imdb/embed?autoplay=false&amp;width=640" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'IMG'=>['(^[^ ]+(?> (?!(?:alt|height|src|title|width)=)[^=]+="[^"]*")*(?> alt="([^"]*)")?(?> (?!(?:height|src|title|width)=)[^=]+="[^"]*")*( height="[^"]*")?(?> (?!(?:src|title|width)=)[^=]+="[^"]*")*(?> src="([^"]*)")?(?> (?!(?:title|width)=)[^=]+="[^"]*")*(?> title="([^"]*)")?(?> (?!width=)[^=]+="[^"]*")*( width="[^"]*")?.*)s','<img src="$3" title="$4" alt="$1"$2$5>'],'INDIEGOGO'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="indiegogo" style="display:inline-block;width:100%;max-width:222px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:200.45045%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.indiegogo.com/project/$1/embedded" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'IZLESENE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="izlesene" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.izlesene.com/embedplayer/$1?autoplay=0" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'JWPLATFORM'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="jwplatform" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//content.jwplatform.com/players/$1.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'KHL'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="khl" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//video.khl.ru/iframe/feed/start/$1?type_id=18&amp;width=560&amp;height=315" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'LIBSYN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="libsyn" allowfullscreen="" loading="lazy" scrolling="no" src="//html5-player.libsyn.com/embed/episode/id/$1/thumbnail/no" style="border:0;height:90px;max-width:900px;width:100%"></iframe>'],'LIVELEAK'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="liveleak" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.liveleak.com/e/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'MAILRU'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="mailru" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://my.mail.ru/video/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'MEDIUM'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="medium" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/medium.min.html#$1" style="border:0;height:316px;max-width:900px;width:100%"></iframe>'],'METACAFE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="metacafe" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.metacafe.com/embed/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'MLB'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="mlb" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.mlb.com/video/share/c-$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'MRCTV'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="mrctv" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.mrctv.org/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'NATGEOCHANNEL'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="natgeochannel" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//channel.nationalgeographic.com/$1/embed/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'NATGEOVIDEO'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="natgeovideo" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//player.d.nationalgeographic.com/players/ngsvideo/share/?guid=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'NBCNEWS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="nbcnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.nbcnews.com/widget/video-embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'NBCSPORTS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="nbcsports" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//vplayer.nbcsports.com/p/BxmELC/nbcsports_embed/select/media/$1?parentUrl=" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'NPR'=>['(^[^ ]+(?> (?![im]=)[^=]+="[^"]*")*(?> i="([^"]*)")?(?> (?!m=)[^=]+="[^"]*")*(?> m="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="npr" allowfullscreen="" loading="lazy" scrolling="no" src="//www.npr.org/player/embed/$1/$2" style="border:0;height:228px;max-width:800px;width:100%"></iframe>'],'NYTIMES'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="nytimes" style="display:inline-block;width:100%;max-width:585px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:68.376068%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//graphics8.nytimes.com/video/players/offsite/index.html?videoId=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'PASTEBIN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="pastebin" allowfullscreen="" loading="lazy" scrolling="" src="//pastebin.com/embed_iframe.php?i=$1" style="border:0;height:300px;resize:vertical;width:100%"></iframe>'],'PODBEAN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="podbean" allowfullscreen="" loading="lazy" scrolling="no" src="https://www.podbean.com/player-v2/?i=$1" style="border:0;height:150px;max-width:900px;width:100%"></iframe>'],'PREZI'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="prezi" style="display:inline-block;width:100%;max-width:550px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:72.727273%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//prezi.com/embed/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'RUMBLE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="rumble" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://rumble.com/embed/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'RUTUBE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="rutube" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//rutube.ru/play/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'SCRIBD'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="scribd" allowfullscreen="" loading="lazy" scrolling="no" src="https://www.scribd.com/embeds/$1/content?view_mode=scroll&amp;show_recommendations=false" style="border:0;height:500px;resize:vertical;width:100%"></iframe>'],'SENDVID'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="sendvid" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//sendvid.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'SIZE'=>['(^[^ ]+(?> (?!size=)[^=]+="[^"]*")*(?> size="([^"]*)")?.*)s','<span style="font-size:$1px">'],'SLIDESHARE'=>['(^[^ ]+(?> (?!key=)[^=]+="[^"]*")*(?> key="([^"]*)")?.*)s','<span data-s9e-mediaembed="slideshare" style="display:inline-block;width:100%;max-width:597px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:81.407035%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.slideshare.net/slideshow/embed_code/key/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'SPORCLE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="sporcle" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/sporcle.min.html#$1" style="border:0;height:535px;max-width:820px;width:100%"></iframe>'],'SPORTSNET'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="sportsnet" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//players.brightcove.net/1704050871/rkedLxwfab_default/index.html?videoId=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'STEAMSTORE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="steamstore" allowfullscreen="" loading="lazy" scrolling="no" src="//store.steampowered.com/widget/$1" style="border:0;height:190px;max-width:900px;width:100%"></iframe>'],'STITCHER'=>['(^[^ ]+(?> (?![ef]id=)[^=]+="[^"]*")*(?> eid="([^"]*)")?(?> (?!fid=)[^=]+="[^"]*")*(?> fid="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="stitcher" allowfullscreen="" loading="lazy" scrolling="no" src="https://www.stitcher.com/embed/$2/$1" style="border:0;height:150px;max-width:900px;width:100%"></iframe>'],'STRAWPOLL'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="strawpoll" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="" src="//www.strawpoll.me/embed_1/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'STREAMABLE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="streamable" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//streamable.com/e/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'STREAMJA'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="streamja" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://streamja.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'TEAMCOCO'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="teamcoco" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//teamcoco.com/embed/v/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'THEATLANTIC'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="theatlantic" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.theatlantic.com/video/iframe/$1/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'THEGUARDIAN'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="theguardian" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//embed.theguardian.com/embed/video/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'THEONION'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="theonion" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.theonion.com/video_embed/?id=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'THREADS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="threads" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/threads.min.html#$1" style="border:0;height:300px;max-width:550px;width:100%"></iframe>'],'TIKTOK'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="tiktok" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/tiktok.min.html#$1" style="border:0;height:740px;max-width:325px;width:100%"></iframe>'],'TMZ'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="tmz" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.kaltura.com/index.php/kwidget/cache_st/133592691/wid/_591531/partner_id/591531/uiconf_id/9071262/entry_id/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'TRAILERADDICT'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="traileraddict" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//v.traileraddict.com/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'TRENDINGVIEWS'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="trendingviews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://trendingviews.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'TUMBLR'=>['(^[^ ]+(?> (?!(?:id|key)=)[^=]+="[^"]*")*(?> id="([^"]*)")?(?> (?!key=)[^=]+="[^"]*")*(?> key="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="tumblr" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/tumblr.min.html#$2/$1" style="border:0;height:300px;max-width:542px;width:100%"></iframe>'],'TWITCH'=>['(^[^ ]+(?> (?!(?:c(?:hannel|lip_id)|t|video_id)=)[^=]+="[^"]*")*(?> channel="([^"]*)")?(?> (?!(?:clip_id|t|video_id)=)[^=]+="[^"]*")*(?> clip_id="([^"]*)")?(?> (?!(?:t|video_id)=)[^=]+="[^"]*")*(?> t="([^"]*)")?(?> (?!video_id=)[^=]+="[^"]*")*(?> video_id="([^"]*)")?.*)s','<span data-s9e-mediaembed="twitch" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" onload="this.contentWindow.postMessage(\'\',\'*\')" scrolling="no" src="https://s9e.github.io/iframe/2/twitch.min.html#channel=$1;clip_id=$2;t=$3;video_id=$4" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'UPL-IMAGE-PREVIEW'=>['(^[^ ]+(?> (?!(?:alt|title|u(?:rl|uid))=)[^=]+="[^"]*")*(?> alt="([^"]*)")?(?> (?!(?:title|u(?:rl|uid))=)[^=]+="[^"]*")*(?> title="([^"]*)")?(?> (?!u(?:rl|uid)=)[^=]+="[^"]*")*(?> url="([^"]*)")?(?> (?!uuid=)[^=]+="[^"]*")*(?> uuid="([^"]*)")?.*)s','<img class="FoFUpload--Upl-Image-Preview" src="$3" title="$2" alt="$1" data-id="$4" loading="lazy">'],'URL'=>['(^[^ ]+(?> (?!(?:rel|t(?:arget|itle)|url)=)[^=]+="[^"]*")*( rel="[^"]*")?(?> (?!(?:t(?:arget|itle)|url)=)[^=]+="[^"]*")*( target="[^"]*")?(?> (?!(?:title|url)=)[^=]+="[^"]*")*( title="[^"]*")?(?> (?!url=)[^=]+="[^"]*")*(?> url="([^"]*)")?.*)s','<a href="$4"$1$2$3>'],'VBOX7'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="vbox7" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//vbox7.com/emb/external.php?vid=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'VEOH'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="veoh" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:62.5%;padding-bottom:calc(56.25% + 40px)"><object data="//www.veoh.com/swf/webplayer/WebPlayer.swf?version=AFrontend.5.7.0.1509&amp;permalinkId=v$1&amp;player=videodetailsembedded&amp;videoAutoPlay=0&amp;id=anonymous" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"></object></span></span>'],'VEVO'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="vevo" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://embed.vevo.com/?isrc=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'VIDEO'=>['(^[^ ]+(?> (?!src=)[^=]+="[^"]*")*(?> src="([^"]*)")?.*)s','<video controls="" src="$1"></video>'],'VIDEODETECTIVE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="videodetective" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.videodetective.com/embed/video/?options=false&amp;autostart=false&amp;playlist=none&amp;publishedid=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'VINE'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="vine" style="display:inline-block;width:100%;max-width:480px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://vine.co/v/$1/embed/simple?audio=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'VK'=>['(^[^ ]+(?> (?!(?:[ov]id|hash)=)[^=]+="[^"]*")*(?> hash="([^"]*)")?(?> (?![ov]id=)[^=]+="[^"]*")*(?> oid="([^"]*)")?(?> (?!vid=)[^=]+="[^"]*")*(?> vid="([^"]*)")?.*)s','<span data-s9e-mediaembed="vk" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//vk.com/video_ext.php?oid=$2&amp;id=$3&amp;hash=$1&amp;hd=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'VOCAROO'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<iframe data-s9e-mediaembed="vocaroo" allowfullscreen="" loading="lazy" scrolling="no" src="https://vocaroo.com/embed/$1" style="border:0;height:80px;max-width:900px;width:100%"></iframe>'],'VOX'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="vox" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//player.ooyala.com/iframe.html#pbid=a637d53c5c0a43c7bf4e342886b9d8b0&amp;ec=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'WASHINGTONPOST'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="washingtonpost" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.washingtonpost.com/video/c/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'WSHH'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="wshh" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//worldstarhiphop.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'WSJ'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="wsj" style="display:inline-block;width:100%;max-width:512px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//video-api.wsj.com/api-video/player/iframe.html?guid=$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'XBOXCLIPS'=>['(^[^ ]+(?> (?!(?:id|user)=)[^=]+="[^"]*")*(?> id="([^"]*)")?(?> (?!user=)[^=]+="[^"]*")*(?> user="([^"]*)")?.*)s','<span data-s9e-mediaembed="xboxclips" style="display:inline-block;width:100%;max-width:560px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//gameclips.io/$2/$1/embed" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'XBOXDVR'=>['(^[^ ]+(?> (?!(?:id|user)=)[^=]+="[^"]*")*(?> id="([^"]*)")?(?> (?!user=)[^=]+="[^"]*")*(?> user="([^"]*)")?.*)s','<span data-s9e-mediaembed="xboxdvr" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//gamerdvr.com/gamer/$2/video/$1/embed" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'YOUKU'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="youku" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//player.youku.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>'],'YOUMAKER'=>['(^[^ ]+(?> (?!id=)[^=]+="[^"]*")*(?> id="([^"]*)")?.*)s','<span data-s9e-mediaembed="youmaker" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.youmaker.com/embed/$1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>']];
	/** {@inheritdoc} */
	protected $quickRegexp='(<(?:(?!/)((?:A(?:BCNEWS|CAST|NCHOR|PPLEPODCASTS|UDI(?:O(?:BOOM|MACK)|US))|B(?:ANDCAMP|BCNEWS|ITCHUTE|LEACHERREPORT|RIGHTCOVE|UNNY)|C(?:ASTOS|BSNEWS|LYP|N(?:BC|N(?:MONEY)?)|O(?:DEPEN|MEDYCENTRAL|UB))|D(?:AILYMOTION|EMOCRACYNOW|UMPERT)|E(?:IGHTTRACKS|SPN)|F(?:A(?:CEBOOK|LSTAD)|LICKR|OXNEWS|P|UNNYORDIE)|G(?:AMESPOT|ETTY|I(?:FS|PHY|ST|THUBCOMPARE)|LOBALNEWS|O(?:FUNDME|OGLE(?:DRIVE|PLUS|SHEETS)))|H(?:R|U(?:DL|LU))|I(?:GN|M(?:DB|G(?:UR)?)|N(?:DIEGOGO|STAGRAM|TERNETARCHIVE)|ZLESENE)|J(?:SFIDDLE|WPLATFORM)|K(?:ALTURA|HL|ICKSTARTER)|LI(?:BSYN|VE(?:LEAK|STREAM))|M(?:A(?:ILRU|STODON)|E(?:DIUM|GAPHONE|TACAFE)|IXCLOUD|LB|RCTV|SNBC)|N(?:ATGEO(?:CHANNEL|VIDEO)|BC(?:NEW|SPORT)S|HL|PR|YTIMES)|O(?:DYSEE|RFIUM)|P(?:ASTEBIN|INTEREST|O(?:DBEA|STMENTIO)N|REZI)|R(?:EDDIT|U(?:MBL|TUB)E)|S(?:CRIBD|ENDVID|LIDESHARE|OUNDCLOUD|P(?:O(?:R(?:CLE|TSNET)|TIFY)|REAKER)|T(?:EAMSTORE|ITCHER|R(?:AWPOLL|EAM(?:ABLE|JA))))|T(?:A(?:GMENTION|SK)|E(?:AMCOCO|D|LEGRAM)|H(?:E(?:ATLANTIC|GUARDIAN|ONION)|READS)|IKTOK|MZ|R(?:A(?:DINGVIEW|ILERADDICT)|ENDINGVIEWS)|UMBLR|W(?:ENTYFOURSEVENSPORTS|IT(?:CH|TER)))|U(?:PL-(?:FILE|IMAGE(?:-PREVIEW)?|TEXT-PREVIEW)|S(?:ERMENTION|TREAM))|V(?:BOX7|E(?:OH|VO)|I(?:DEO(?:DETECTIVE)?|MEO|NE)|K|O(?:CAROO|X))|W(?:A(?:SHINGTONPOS|VEKI)T|ISTIA|S(?:HH|J))|XBOX(?:CLIPS|DVR)|YOU(?:KU|MAKER|TUBE)))(?: [^>]*)?>.*?</\\1|(/?(?!br/|p>)[^ />]+)[^>]*?(/)?)>)s';
	/** {@inheritdoc} */
	protected $quickRenderingTest='((?<=<)(?:[!?]|(?:AMAZON|E|G(?:ITHUB(?:COMMIT|ISSUE|PR|REPO)|ROUPMENTION)|LI)[ />]))';
	/** {@inheritdoc} */
	protected function renderQuickTemplate($id, $xml)
	{
		$attributes=$this->matchAttributes($xml);
		$html='';switch($id){case'/LIST':$attributes=array_pop($this->attributes);if(!isset($attributes['type']))$html.='</ul>';elseif(str_starts_with($attributes['type']??'','decimal')||str_starts_with($attributes['type']??'','lower')||str_starts_with($attributes['type']??'','upper'))$html.='</ol>';else$html.='</ul>';break;case'APPLEPODCASTS':$attributes+=['country'=>null,'podcast_id'=>null];$html.='<iframe data-s9e-mediaembed="applepodcasts" allow="autoplay *;encrypted-media *" allowfullscreen="" loading="lazy" scrolling="no"';$html.=' src="https://embed.podcasts.apple.com/'.$attributes['country'].'/podcast/episode/id'.$attributes['podcast_id'].'?theme='.htmlspecialchars($this->params['MEDIAEMBED_THEME'],2);if(isset($attributes['episode_id']))$html.='&amp;i='.$attributes['episode_id'].'" style="border:0;height:175px;max-width:900px;width:100%"';else$html.='" style="border:0;height:450px;max-width:900px;width:100%"';$html.='></iframe>';break;case'AUDIOMACK':$attributes+=['mode'=>null,'artist'=>null,'title'=>null];$html.='<iframe data-s9e-mediaembed="audiomack" allowfullscreen="" loading="lazy" scrolling="no"';if($attributes['mode']==='album'){$html.=' src="https://www.audiomack.com/embed/album/';if(isset($attributes['id']))$html.=($attributes['id']??'');else$html.=$attributes['artist'].'/'.$attributes['title'];$html.='" style="border:0;height:400px;max-width:900px;width:100%"';}else{$html.=' src="https://www.audiomack.com/embed/song/';if(isset($attributes['id']))$html.=($attributes['id']??'');else$html.=$attributes['artist'].'/'.$attributes['title'];$html.='" style="border:0;height:252px;max-width:900px;width:100%"';}$html.='></iframe>';break;case'AUDIUS':$attributes+=['playlist_id'=>null];$html.='<iframe data-s9e-mediaembed="audius" allowfullscreen="" loading="lazy" scrolling="no" src="https://audius.co/embed/';if(isset($attributes['track_id']))$html.='track/'.$attributes['track_id'].'?flavor=compact';elseif(isset($attributes['album_id']))$html.='album/'.$attributes['album_id'].'?flavor=card';else$html.='playlist/'.$attributes['playlist_id'].'?flavor=card';$html.='" style="border:0;height:';if(isset($attributes['track_id']))$html.='12';else$html.='48';$html.='0px;max-width:';if(isset($attributes['track_id']))$html.='9';else$html.='4';$html.='00px;width:100%"></iframe>';break;case'BANDCAMP':$attributes+=['track_num'=>null,'track_id'=>null];$html.='<span data-s9e-mediaembed="bandcamp" style="display:inline-block;width:100%;max-width:400px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:100%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//bandcamp.com/EmbeddedPlayer/size=large/minimal=true/';if(isset($attributes['album_id'])){$html.='album='.$attributes['album_id'];if(isset($attributes['track_num']))$html.='/t='.$attributes['track_num'];}else$html.='track='.$attributes['track_id'];if($this->params['MEDIAEMBED_THEME']==='dark')$html.='/bgcol=333333/linkcol=0f91ff';$html.='"></iframe></span></span>';break;case'BBCNEWS':$attributes+=['playlist'=>null,'id'=>null];$html.='<span data-s9e-mediaembed="bbcnews" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.bbc.com/news/av-embeds/';if(str_starts_with($attributes['playlist']??'','/news/'))if(str_contains($attributes['playlist']??'','-'))$html.=htmlspecialchars(substr(strstr(substr(strstr(strtr(htmlspecialchars_decode($attributes['playlist']??''),'A','#'),'news/'),5),'-'),1),2);else$html.=htmlspecialchars(substr(strstr(strtr(htmlspecialchars_decode($attributes['playlist']??''),'A','/'),'/news/'),6),2);elseif(str_contains($attributes['id']??'','/'))$html.=htmlspecialchars(substr(strstr(htmlspecialchars_decode($attributes['id']??''),'/'),1),2);else$html.=($attributes['id']??'');$html.='"></iframe></span></span>';break;case'BRIGHTCOVE':$attributes+=['bcpid'=>null,'bctid'=>null];$html.='<span data-s9e-mediaembed="brightcove" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="https://';if(isset($attributes['bckey']))$html.='link.brightcove.com/services/player/bcpid'.$attributes['bcpid'].'?bckey='.$attributes['bckey'].'&amp;bctid='.$attributes['bctid'].'&amp;secureConnections=true&amp;secureHTMLConnections=true&amp;autoStart=false&amp;height=360&amp;width=640';else$html.='players.brightcove.net/'.$attributes['bcpid'].'/default_default/index.html?videoId='.$attributes['bctid'];$html.='"></iframe></span></span>';break;case'CBSNEWS':$attributes+=['id'=>null];$html.='<span data-s9e-mediaembed="cbsnews" style="display:inline-block;width:100%;max-width:640px"><span';if(str_contains($attributes['id']??'','-'))$html.=' style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.cbsnews.com/embed/videos/'.$attributes['id'].'/" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe>';elseif(isset($attributes['pid']))$html.=' style="display:block;overflow:hidden;position:relative;padding-bottom:62.1875%;padding-bottom:calc(56.25% + 38px)"><object data="//www.cbsnews.com/common/video/cbsnews_player.swf" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"><param name="flashvars" value="pType=embed&amp;si=254&amp;pid='.$attributes['pid'].'"></object>';else$html.=' style="display:block;overflow:hidden;position:relative;padding-bottom:62.5%;padding-bottom:calc(56.25% + 40px)"><object data="//i.i.cbsi.com/cnwk.1d/av/video/cbsnews/atlantis2/cbsnews_player_embed.swf" style="height:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param name="allowfullscreen" value="true"><param name="flashvars" value="si=254&amp;contentValue='.$attributes['id'].'"></object>';$html.='</span></span>';break;case'CODE':$html.='<pre><code';if(isset($attributes['lang']))$html.=' class="language-'.$attributes['lang'].'"';$html.='>';break;case'DAILYMOTION':$attributes+=['id'=>null];$html.='<span data-s9e-mediaembed="dailymotion" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.dailymotion.com/embed/video/'.$attributes['id'];if(isset($attributes['t']))$html.='?start='.$attributes['t'];$html.='"></iframe></span></span>';break;case'DEMOCRACYNOW':$attributes+=['id'=>null];$html.='<span data-s9e-mediaembed="democracynow" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.democracynow.org/embed/';if(str_contains($attributes['id']??'','/headlines'))$html.='headlines/'.htmlspecialchars(strstr(htmlspecialchars_decode($attributes['id']??''),'/headlines',true),2);elseif(str_starts_with($attributes['id']??'','2'))$html.='story/'.$attributes['id'];elseif(str_starts_with($attributes['id']??'','shows/'))$html.='show/'.htmlspecialchars(substr(strstr(htmlspecialchars_decode($attributes['id']??''),'/'),1),2);else$html.=($attributes['id']??'');$html.='"></iframe></span></span>';break;case'DUMPERT':$attributes+=['id'=>null];$html.='<span data-s9e-mediaembed="dumpert" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.dumpert.nl/embed/'.strtr($attributes['id']??'','/','_').'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'FACEBOOK':$attributes+=['type'=>null,'pfbid'=>null];$html.='<iframe data-s9e-mediaembed="facebook" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" style="border:0;height:360px;max-width:640px;width:100%" src="https://s9e.github.io/iframe/2/facebook.min.html#';if(isset($attributes['user'])){$html.=$attributes['user'].'/';if($attributes['type']==='r'||$attributes['type']==='v')$html.='video';else$html.='post';$html.='s/';if(isset($attributes['id']))$html.=($attributes['id']??'');else$html.='pfbid'.$attributes['pfbid'];}elseif(isset($attributes['id']))$html.=$attributes['type'].$attributes['id'];else$html.='pfbid'.$attributes['pfbid'];$html.='"></iframe>';break;case'FALSTAD':$attributes+=['ctz'=>null];$html.='<iframe data-s9e-mediaembed="falstad" allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:500px;max-height:90vh;width:100%" src="https://www.falstad.com/circuit/circuitjs.html?running=false&amp;c';if(isset($attributes['cct']))$html.='ct='.$attributes['cct'];else$html.='tz='.$attributes['ctz'];$html.='"></iframe>';break;case'FP':$attributes+=['char'=>null];$html.=str_replace('&quot;','"',$attributes['char']??'');break;case'GETTY':$attributes+=['width'=>null,'height'=>null,'id'=>null,'et'=>null,'sig'=>null];$html.='<span data-s9e-mediaembed="getty" style="display:inline-block;width:100%;max-width:'.$attributes['width'].'px"><span style="display:block;overflow:hidden;position:relative;';if(htmlspecialchars_decode($attributes['width']??'')>0)$html.='padding-bottom:'.htmlspecialchars(100*$attributes['height']/htmlspecialchars_decode($attributes['width']??''),2).'%';$html.='"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//embed.gettyimages.com/embed/'.$attributes['id'].'?et='.$attributes['et'].'&amp;tld=com&amp;sig='.$attributes['sig'].'&amp;caption=false&amp;ver=1" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GIFS':$attributes+=['width'=>null,'height'=>null,'id'=>null];$html.='<span data-s9e-mediaembed="gifs" style="display:inline-block;width:100%;max-width:'.$attributes['width'].'px"><span style="display:block;overflow:hidden;position:relative;';if(htmlspecialchars_decode($attributes['width']??'')>0)$html.='padding-bottom:'.htmlspecialchars(100*$attributes['height']/htmlspecialchars_decode($attributes['width']??''),2).'%';$html.='"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//gifs.com/embed/'.$attributes['id'].'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'GIPHY':$attributes+=['width'=>null,'height'=>null,'id'=>null,'type'=>null];$html.='<span data-s9e-mediaembed="giphy" style="display:inline-block;width:100%;max-width:'.$attributes['width'].'px"><span style="display:block;overflow:hidden;position:relative;';if(htmlspecialchars_decode($attributes['width']??'')>0)$html.='padding-bottom:'.htmlspecialchars(100*$attributes['height']/htmlspecialchars_decode($attributes['width']??''),2).'%';$html.='"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//giphy.com/embed/'.$attributes['id'];if($attributes['type']==='video')$html.='/video';$html.='"></iframe></span></span>';break;case'GITHUBCOMPARE':$attributes+=['repo'=>null,'base'=>null,'head'=>null];$html.='<a class="Github-embed github-compare-link" href="https://github.com/'.$attributes['repo'].'/compare/'.$attributes['base'].'...'.$attributes['head'].'" target="_blank" rel="ugc noopener noreferrer"><i class="fab fa-github" aria-hidden="true"></i>'.str_replace('&quot;','"',$attributes['repo']??'').'<i class="fas fa-arrow-right" aria-hidden="true"></i><code>'.str_replace('&quot;','"',$attributes['base']??'').' → '.str_replace('&quot;','"',$attributes['head']??'').'</code></a>';break;case'GOOGLEPLUS':$attributes+=['name'=>null,'pid'=>null];$html.='<iframe data-s9e-mediaembed="googleplus" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" style="border:0;height:240px;max-width:450px;width:100%" src="https://s9e.github.io/iframe/2/googleplus.min.html#';if(isset($attributes['oid']))$html.=($attributes['oid']??'');else$html.='+'.$attributes['name'];$html.='/posts/'.$attributes['pid'].'"></iframe>';break;case'GOOGLESHEETS':$attributes+=['type'=>null,'id'=>null,'oid'=>null,'gid'=>null];if($attributes['type']==='chart')$html.='<span data-s9e-mediaembed="googlesheets" style="display:inline-block;width:100%;max-width:600px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:62%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://docs.google.com/spreadsheets/d/'.$attributes['id'].'/pubchart?oid='.$attributes['oid'].'&amp;format=interactive" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';else{$html.='<iframe data-s9e-mediaembed="googlesheets" allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:500px;resize:vertical;width:100%" src="https://docs.google.com/spreadsheets/d/'.$attributes['id'].'/p';if(str_starts_with($attributes['id']??'','e/'))$html.='ubhtml?widget=true&amp;headers=false';else$html.='review';$html.='#gid='.$attributes['gid'].'"></iframe>';}break;case'HUDL':$attributes+=['athlete'=>null,'highlight'=>null];$html.='<span data-s9e-mediaembed="hudl" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.hudl.com/embed/';if(isset($attributes['id']))$html.='video/'.$attributes['id'];else$html.='athlete/'.$attributes['athlete'].'/highlights/'.$attributes['highlight'];$html.='"></iframe></span></span>';break;case'IMGUR':$attributes+=['type'=>null,'id'=>null];$html.='<iframe data-s9e-mediaembed="imgur" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;{let s=this.style,d=e.data.split(\' \');s.height=d[0]+\'px\';s.width=d[1]+\'px\'};this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" style="border:0;height:400px;max-width:100%;width:542px" src="https://s9e.github.io/iframe/2/imgur.min.html#';if($attributes['type']==='album')$html.='a/';$html.=$attributes['id'].'"></iframe>';break;case'INSTAGRAM':$attributes+=['id'=>null];$html.='<iframe data-s9e-mediaembed="instagram" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" style="border:0;height:542px;max-width:542px;width:100%" src="https://s9e.github.io/iframe/2/instagram.min.html#'.$attributes['id'];if($this->params['MEDIAEMBED_THEME']==='dark')$html.='#theme=dark';$html.='"></iframe>';break;case'INTERNETARCHIVE':$attributes+=['id'=>null,'width'=>null,'height'=>null];if(str_contains($attributes['id']??'','playlist=1'))$html.='<iframe data-s9e-mediaembed="internetarchive" allowfullscreen="" loading="lazy" scrolling="no" src="https://archive.org/embed/'.$attributes['id'].'&amp;list_height=150" style="border:0;height:170px;max-width:640px;width:100%"></iframe>';else{$html.='<span data-s9e-mediaembed="internetarchive" style="display:inline-block;width:100%;max-width:'.$attributes['width'].'px"><span style="display:block;overflow:hidden;position:relative;';if(htmlspecialchars_decode($attributes['width']??'')>0)$html.='padding-bottom:'.htmlspecialchars(100*$attributes['height']/htmlspecialchars_decode($attributes['width']??''),2).'%';$html.='"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://archive.org/embed/'.$attributes['id'].'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';}break;case'JSFIDDLE':$attributes+=['id'=>null,'revision'=>null];$html.='<iframe data-s9e-mediaembed="jsfiddle" allowfullscreen="" loading="lazy" scrolling="no" src="//jsfiddle.net/'.$attributes['id'].'/'.$attributes['revision'].'/embedded/'.htmlspecialchars($this->params['MEDIAEMBED_THEME'],2).'/" style="border:0;height:400px;width:100%"></iframe>';break;case'KALTURA':$attributes+=['partner_id'=>null,'uiconf_id'=>null,'entry_id'=>null];$html.='<span data-s9e-mediaembed="kaltura" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:61.875%;padding-bottom:calc(56.25% + 36px)"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="https://cdnapisec.kaltura.com/p/'.$attributes['partner_id'].'/sp/';if(isset($attributes['sp']))$html.=($attributes['sp']??'');else$html.=$attributes['partner_id'].'00';$html.='/embedIframeJs/uiconf_id/'.$attributes['uiconf_id'].'/partner_id/'.$attributes['partner_id'].'?iframeembed=true&amp;entry_id='.$attributes['entry_id'].'"></iframe></span></span>';break;case'KICKSTARTER':$attributes+=['id'=>null];$html.='<span data-s9e-mediaembed="kickstarter"';if(isset($attributes['video']))$html.=' style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.kickstarter.com/projects/'.$attributes['id'].'/widget/video.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span>';else$html.=' style="display:inline-block;width:100%;max-width:220px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:190.909091%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//www.kickstarter.com/projects/'.$attributes['id'].'/widget/card.html" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span>';$html.='</span>';break;case'LIST':$attributes+=['type'=>null];if(!isset($attributes['type']))$html.='<ul>';elseif(str_starts_with($attributes['type']??'','decimal')||str_starts_with($attributes['type']??'','lower')||str_starts_with($attributes['type']??'','upper')){$html.='<ol style="list-style-type:'.$attributes['type'].'"';if(isset($attributes['start']))$html.=' start="'.$attributes['start'].'"';$html.='>';}else$html.='<ul style="list-style-type:'.$attributes['type'].'">';$this->attributes[]=$attributes;break;case'LIVESTREAM':$attributes+=['channel'=>null,'account_id'=>null,'event_id'=>null];$html.='<span data-s9e-mediaembed="livestream" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//';if(isset($attributes['clip_id']))$html.='cdn.livestream.com/embed/'.$attributes['channel'].'?layout=4&amp;autoplay=false&amp;clip='.$attributes['clip_id'];else{$html.='livestream.com/accounts/'.$attributes['account_id'].'/events/'.$attributes['event_id'];if(isset($attributes['video_id']))$html.='/videos/'.$attributes['video_id'];$html.='/player?autoPlay=false';}$html.='"></iframe></span></span>';break;case'MASTODON':$attributes+=['name'=>null,'id'=>null];$html.='<iframe data-s9e-mediaembed="mastodon" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" style="border:0;height:300px;max-width:550px;width:100%" src="https://s9e.github.io/iframe/2/mastodon.min.html#'.$attributes['name'];if(isset($attributes['host'])&&htmlspecialchars_decode($attributes['host']??'')!=='mastodon.social')$html.='@'.$attributes['host'];$html.='/'.$attributes['id'].'"></iframe>';break;case'MEGAPHONE':$attributes+=['id'=>null];$html.='<iframe data-s9e-mediaembed="megaphone" allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:200px;max-width:900px;width:100%" src="https://player.megaphone.fm/'.$attributes['id'];if($this->params['MEDIAEMBED_THEME']==='light')$html.='?light=true';$html.='"></iframe>';break;case'MIXCLOUD':$attributes+=['id'=>null];$html.='<iframe data-s9e-mediaembed="mixcloud" allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:120px;max-width:900px;width:100%" src="//www.mixcloud.com/widget/iframe/?feed=%2F'.$attributes['id'].'%2F&amp;light=';if($this->params['MEDIAEMBED_THEME']!=='dark')$html.='1';$html.='"></iframe>';break;case'MSNBC':$attributes+=['id'=>null];$html.='<span data-s9e-mediaembed="msnbc" style="display:inline-block;width:100%;max-width:640px"><span';if(str_contains($attributes['id']??'','_'))$html.=' style="display:block;overflow:hidden;position:relative;padding-bottom:68.75%;padding-bottom:calc(56.25% + 80px)"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="//player.theplatform.com/p/7wvmTC/MSNBCEmbeddedOffSite?guid=';else$html.=' style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.msnbc.com/msnbc/embedded-video/';$html.=$attributes['id'].'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe>';$html.='</span></span>';break;case'NHL':$html.='<span data-s9e-mediaembed="nhl" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="https://www.nhl.com/video/embed';if(isset($attributes['t']))$html.='/t-'.$attributes['t'];if(isset($attributes['c']))$html.='/c-'.$attributes['c'];$html.='?autostart=false"></iframe></span></span>';break;case'ODYSEE':$attributes+=['name'=>null,'id'=>null,'path'=>null];$html.='<span data-s9e-mediaembed="odysee" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="https://odysee.com/$/embed/';if(isset($attributes['id'])){if(isset($attributes['name']))$html.=($attributes['name']??'');else$html.='-';$html.='/'.$attributes['id'];}else$html.=($attributes['path']??'');$html.='"></iframe></span></span>';break;case'ORFIUM':$attributes+=['track_id'=>null];$html.='<iframe data-s9e-mediaembed="orfium" allowfullscreen="" loading="lazy" scrolling="no" src="https://www.orfium.com/embedded/';if(isset($attributes['album_id']))$html.='album/'.$attributes['album_id'];elseif(isset($attributes['playlist_id']))$html.='playlist/'.$attributes['playlist_id'];elseif(isset($attributes['set_id']))$html.='live-set/'.$attributes['set_id'];else$html.='track/'.$attributes['track_id'];$html.='" style="border:0;height:';if(isset($attributes['album_id']))$html.='550';else$html.='275';$html.='px;max-width:900px;width:100%"></iframe>';break;case'PINTEREST':$attributes+=['id'=>null];$html.='<iframe data-s9e-mediaembed="pinterest" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/pinterest.min.html#'.$attributes['id'].'" style="border:0;height:360px;max-width:';if(str_contains($attributes['id']??'','/'))$html.='730';else$html.='345';$html.='px;width:100%"></iframe>';break;case'POSTMENTION':$attributes+=['deleted'=>null,'discussionid'=>null,'number'=>null,'id'=>null,'displayname'=>null];if(htmlspecialchars_decode($attributes['deleted']??'')!=1)$html.='<a href="'.htmlspecialchars($this->params['DISCUSSION_URL'].htmlspecialchars_decode($attributes['discussionid']??''),2).'/'.$attributes['number'].'" class="PostMention" data-id="'.$attributes['id'].'">'.str_replace('&quot;','"',$attributes['displayname']??'').'</a>';else$html.='<span class="PostMention PostMention--deleted" data-id="'.$attributes['id'].'">'.str_replace('&quot;','"',$attributes['displayname']??'').'</span>';break;case'QUOTE':$html.='<blockquote';if(!isset($attributes['author']))$html.=' class="uncited"';$html.='><div>';if(isset($attributes['author']))$html.='<cite>'.str_replace('&quot;','"',$attributes['author']??'').' '.htmlspecialchars($this->params['L_WROTE'],0).'</cite>';break;case'REDDIT':$attributes+=['id'=>null,'path'=>null];$html.='<iframe data-s9e-mediaembed="reddit" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" src="https://s9e.github.io/iframe/2/reddit.min.html#'.$attributes['id'].$attributes['path'].'#theme='.htmlspecialchars($this->params['MEDIAEMBED_THEME'],2).'" style="border:0;height:165px;max-width:800px;width:100%"></iframe>';break;case'SOUNDCLOUD':$attributes+=['secret_token'=>null,'id'=>null];$html.='<iframe data-s9e-mediaembed="soundcloud" allowfullscreen="" loading="lazy" scrolling="no" src="https://w.soundcloud.com/player/?url=';if(isset($attributes['playlist_id']))$html.='https%3A//api.soundcloud.com/playlists/'.$attributes['playlist_id'].'%3Fsecret_token%3D'.$attributes['secret_token'];elseif(isset($attributes['track_id']))$html.='https%3A//api.soundcloud.com/tracks/'.$attributes['track_id'].'%3Fsecret_token%3D'.$attributes['secret_token'];else{if(!str_contains($attributes['id']??'','://'))$html.='https%3A//soundcloud.com/';$html.=($attributes['id']??'');}$html.='" style="border:0;height:';if(isset($attributes['playlist_id'])||str_contains($attributes['id']??'','/sets/'))$html.='450';else$html.='166';$html.='px;max-width:900px;width:100%"></iframe>';break;case'SPOTIFY':$attributes+=['id'=>null,'path'=>null];$html.='<iframe data-s9e-mediaembed="spotify" allow="encrypted-media" allowfullscreen="" loading="lazy" scrolling="no" src="https://open.spotify.com/embed/'.htmlspecialchars(strtr(htmlspecialchars_decode($attributes['id']??''),':','/').htmlspecialchars_decode($attributes['path']??''),2).'" style="border:0;border-radius:12px;height:';if(str_starts_with($attributes['id']??'','episode')||str_starts_with($attributes['id']??'','show')||str_starts_with($attributes['id']??'','track'))$html.='152';else$html.='380';$html.='px;max-width:900px;width:100%"></iframe>';break;case'SPREAKER':$attributes+=['episode_id'=>null,'show_id'=>null];$html.='<iframe data-s9e-mediaembed="spreaker" allowfullscreen="" loading="lazy" scrolling="no" src="https://widget.spreaker.com/player?episode_id='.$attributes['episode_id'].'&amp;show_id='.$attributes['show_id'].'&amp;theme='.htmlspecialchars($this->params['MEDIAEMBED_THEME'],2).'" style="border:0;height:'.htmlspecialchars(400-200*isset($attributes['episode_id']),2).'px;max-width:900px;width:100%"></iframe>';break;case'TAGMENTION':$attributes+=['deleted'=>null,'slug'=>null,'id'=>null,'color'=>null,'icon'=>null,'tagname'=>null];if(htmlspecialchars_decode($attributes['deleted']??'')!=1){$html.='<a href="'.htmlspecialchars($this->params['TAG_URL'].htmlspecialchars_decode($attributes['slug']??''),2).'" data-id="'.$attributes['id'].'" class="TagMention';if(htmlspecialchars_decode($attributes['color']??'')!=='')$html.=' TagMention--colored';$html.='" style="';if(htmlspecialchars_decode($attributes['color']??'')!=='')$html.='--color:'.$attributes['color'];$html.='"><span class="TagMention-text">';if(htmlspecialchars_decode($attributes['icon']??'')!=='')$html.='<i class="icon '.$attributes['icon'].'"></i>';$html.=str_replace('&quot;','"',$attributes['tagname']??'').'</span></a>';}else$html.='<span class="TagMention TagMention--deleted" data-id="'.$attributes['id'].'"><span class="TagMention-text">'.str_replace('&quot;','"',$attributes['tagname']??'').'</span></span>';break;case'TASK':$attributes+=['id'=>null,'state'=>null];$html.='<input data-task-id="'.$attributes['id'].'" type="checkbox"';if($attributes['state']==='checked')$html.=' checked';if($this->params['TASKLISTS_EDITABLE']==='')$html.=' disabled';$html.='>';break;case'TD':$html.='<td';if(isset($attributes['align']))$html.=' style="text-align:'.$attributes['align'].'"';$html.='>';break;case'TED':$attributes+=['id'=>null];$html.='<span data-s9e-mediaembed="ted" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//embed.ted.com/'.$attributes['id'];if(!str_contains($attributes['id']??'','.html'))$html.='.html';$html.='"></iframe></span></span>';break;case'TELEGRAM':$attributes+=['id'=>null];$html.='<iframe data-s9e-mediaembed="telegram" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" style="border:0;height:96px;max-width:500px;width:100%" src="https://s9e.github.io/iframe/2/telegram.min.html#'.$attributes['id'];if($this->params['MEDIAEMBED_THEME']==='dark')$html.='#theme=dark';$html.='"></iframe>';break;case'TH':$html.='<th';if(isset($attributes['align']))$html.=' style="text-align:'.$attributes['align'].'"';$html.='>';break;case'TRADINGVIEW':$attributes+=['chart'=>null];$html.='<iframe data-s9e-mediaembed="tradingview" allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:400px;width:100%" src="https://s.tradingview.com/';if(isset($attributes['symbol']))$html.='widgetembed/?interval=D&amp;symbol='.strtr($attributes['symbol']??'','-',':');else$html.='embed/'.$attributes['chart'];$html.='"></iframe>';break;case'TWENTYFOURSEVENSPORTS':$attributes+=['player_id'=>null];if(isset($attributes['video_id']))$html.='<span data-s9e-mediaembed="twentyfoursevensports" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://www.cbssports.com/video/player/embed?args=player_id%3D'.$attributes['video_id'].'%26channel%3Dmobilevideo%26pcid%3D'.$attributes['video_id'].'%26width%3D640%26height%3D360%26autoplay%3Dfalse%26comp_ads_enabled%3Dfalse%26uvpc%3Dhttp%3A%2F%2Fsports.cbsimg.net%2Fvideo%2Fuvp%2Fconfig%2Fv4%2Fuvp_247sports.xml%26uvpc_m%3Dhttp%3A%2F%2Fsports.cbsimg.net%2Fvideo%2Fuvp%2Fconfig%2Fv4%2Fuvp_247sports_m.xml%26partner%3D247%26partner_m%3D247_mobile%26utag%3D247sportssite%26resizable%3Dtrue" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';else$html.='<iframe data-s9e-mediaembed="twentyfoursevensports" allowfullscreen="" loading="lazy" onload="window.addEventListener(\'message\',function(e){if(e.source===this.contentWindow&amp;&amp;e.data.height)this.style.height=e.data.height+\'px\'})" scrolling="no" src="https://247sports.com/PlayerSport/'.$attributes['player_id'].'/Embed/" style="border:0;height:200px;max-width:600px;width:100%"></iframe>';break;case'TWITTER':$attributes+=['id'=>null];$html.='<iframe data-s9e-mediaembed="twitter" allow="autoplay *" allowfullscreen="" loading="lazy" onload="let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])" scrolling="no" style="border:0;height:350px;max-width:550px;width:100%" src="https://s9e.github.io/iframe/2/twitter.min.html#'.$attributes['id'];if($this->params['MEDIAEMBED_THEME']==='dark')$html.='#theme=dark';$html.='"></iframe>';break;case'UPL-FILE':$attributes+=['uuid'=>null,'content'=>null,'size'=>null];$html.='<div class="ButtonGroup" data-fof-upload-download-uuid="'.$attributes['uuid'].'"><div class="Button hasIcon Button--icon Button--primary"><i class="fas fa-download"></i></div><div class="Button">'.str_replace('&quot;','"',$attributes['content']??'').'</div><div class="Button">'.str_replace('&quot;','"',$attributes['size']??'').'</div></div>';break;case'UPL-IMAGE':$attributes+=['uuid'=>null,'url'=>null,'size'=>null,'content'=>null];$html.='<div class="fof-download row" data-fof-upload-download-uuid="'.$attributes['uuid'].'"><div class="card"><div class="wrapper" style="background:url('.$attributes['url'].') center / cover no-repeat"><div class="header"><ul class="menu-content"><li><div class="far fa-hdd"><span>'.str_replace('&quot;','"',$attributes['size']??'').'</span></div></li></ul></div><div class="data"><div class="content"><h4 class="title">'.str_replace('&quot;','"',$attributes['content']??'').'</h4><div class="Button Button--primary Button-icon Button--block"><i class="fas fa-download"></i></div></div></div></div></div></div>';break;case'UPL-TEXT-PREVIEW':$attributes+=['has_snippet'=>null,'content'=>null,'snippet'=>null,'url'=>null];$html.='<figure class="FofUpload-TextPreview" data-loading="false" data-expanded="false" data-hassnippet="'.$attributes['has_snippet'].'"><figcaption class="FofUpload-TextPreviewTitle"><i aria-hidden="true" class="icon far fa-file"></i> '.str_replace('&quot;','"',$attributes['content']??'').'</figcaption><div class="FofUpload-TextPreviewSnippet"><pre><code data-preview-text="&lt;preview will appear here after posting&gt;" data-nosnippet-text="&lt;no preview snippet available&gt;">'.str_replace('&quot;','"',$attributes['snippet']??'').'</code></pre></div><div class="FofUpload-TextPreviewFull"></div><button type="button" class="Button hasIcon FofUpload-TextPreviewToggle"><i aria-hidden="true" class="icon fas fa-chevron-down Button-icon FofUpload-TextPreviewExpandIcon"></i><span class="Button-label FofUpload-TextPreviewExpand">
            Expand preview        </span><i aria-hidden="true" class="icon fas fa-chevron-up Button-icon FofUpload-TextPreviewCollapseIcon"></i><span class="Button-label FofUpload-TextPreviewCollapse">
            Collapse preview        </span><div data-size="small" class="FofUpload-TextPreviewToggleLoading LoadingIndicator-container LoadingIndicator-container--inline LoadingIndicator-container--small"><div aria-hidden="true" class="LoadingIndicator"></div></div></button><div class="FofUpload-TextPreviewError"><p><i aria-hidden="true" class="icon fas fa-exclamation-circle"></i>
            Error previewing file. It may have been deleted, or the provided file ID is invalid.
        </p></div><script>
        {
            const figure = document.currentScript.parentElement;

            const previewEl = figure.querySelector(\'.FofUpload-TextPreviewFull\');
            const snippetEl = figure.querySelector(\'.FofUpload-TextPreviewSnippet\');
            const loadingEl = figure.querySelector(\'.FofUpload-TextPreviewLoading\');
            const toggleBtn = figure.querySelector(\'.FofUpload-TextPreviewToggle\');

            const snippetText = \'\';

            const testUrl = new URL(location.origin);
            const url = new URL(\''.htmlspecialchars_decode($attributes['url']??'').'\');

            if (testUrl.origin !== url.origin) {
              // Prevent cross-origin requests
              handleError(new Error(\'Attempted to fetch a cross-origin file in text preview.\'));
            }

            function createCodeHtml(text) {
                const codeEl = document.createElement(\'code\');
                codeEl.innerText = text;

                return `<pre>${codeEl.outerHTML}`;
            }

            function handleError(e) {
                figure.setAttribute(\'data-error\', \'true\');

                console.group(\'[FoF Upload] Failed to preview text file.\');
                console.error(\'Failed to load text file: \' + url);
                console.log(e);
                console.groupEnd();
            }

            let fileContent = null;

            // Only allow toggling preview if showing a snippet
            if ('.htmlspecialchars_decode($attributes['has_snippet']??'').' && testUrl.origin === url.origin) {
                toggleBtn.addEventListener(\'click\', () => {
                    if (fileContent !== null) {
                        const expanded = figure.getAttribute(\'data-expanded\') === \'true\';
                        figure.setAttribute(\'data-expanded\', !expanded);
                        return;
                    }

                    figure.setAttribute(\'data-loading\', \'true\');

                    fetch(url)
                        .then(response => {
                            if (!response.ok) {
                                figure.setAttribute(\'data-loading\', \'false\');
                                throw response;
                            }

                            return response.text();
                        })
                        .then(text => {
                            fileContent = text;
                            previewEl.innerHTML = createCodeHtml(text);

                            figure.setAttribute(\'data-loading\', \'false\');
                            const expanded = figure.getAttribute(\'data-expanded\') === \'true\';
                            figure.setAttribute(\'data-expanded\', !expanded);
                        })
                        .catch(handleError);
                });
            }
        }
    </script></figure>';break;case'USERMENTION':$attributes+=['deleted'=>null,'slug'=>null,'displayname'=>null];if(htmlspecialchars_decode($attributes['deleted']??'')!=1)$html.='<a href="'.htmlspecialchars($this->params['PROFILE_URL'].htmlspecialchars_decode($attributes['slug']??''),2).'" class="UserMention">@'.str_replace('&quot;','"',$attributes['displayname']??'').'</a>';else$html.='<span class="UserMention UserMention--deleted">@'.str_replace('&quot;','"',$attributes['displayname']??'').'</span>';break;case'USTREAM':$attributes+=['cid'=>null];$html.='<span data-s9e-mediaembed="ustream" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//www.ustream.tv/embed/';if(isset($attributes['vid']))$html.='recorded/'.$attributes['vid'];else$html.=($attributes['cid']??'');$html.='?html5ui"></iframe></span></span>';break;case'VIMEO':$attributes+=['id'=>null];$html.='<span data-s9e-mediaembed="vimeo" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="border:0;height:100%;left:0;position:absolute;width:100%" src="//player.vimeo.com/video/'.$attributes['id'];if(isset($attributes['h']))$html.='?h='.$attributes['h'];if(isset($attributes['t']))$html.='#t='.$attributes['t'];$html.='"></iframe></span></span>';break;case'WAVEKIT':$attributes+=['audio_id'=>null];$html.='<iframe data-s9e-mediaembed="wavekit" allowfullscreen="" loading="lazy" scrolling="no" src="https://play.wavekit.app/embed/';if(isset($attributes['playlist_id']))$html.='playlist/'.$attributes['playlist_id'];else$html.='audio/'.$attributes['audio_id'];$html.='" style="border:0;height:';if(isset($attributes['playlist_id']))$html.='40';else$html.='17';$html.='0px;max-width:900px;width:100%"></iframe>';break;case'WISTIA':$attributes+=['type'=>null,'id'=>null];if($attributes['type']==='audio')$html.='<iframe data-s9e-mediaembed="wistia" allowfullscreen="" loading="lazy" scrolling="no" src="https://fast.wistia.net/embed/iframe/'.$attributes['id'].'" style="border:0;height:218px;max-width:900px;width:100%"></iframe>';else$html.='<span data-s9e-mediaembed="wistia" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" src="https://fast.wistia.net/embed/iframe/'.$attributes['id'].'" style="border:0;height:100%;left:0;position:absolute;width:100%"></iframe></span></span>';break;case'YOUTUBE':$attributes+=['id'=>null,'clipt'=>null,'t'=>null];$html.='<span data-s9e-mediaembed="youtube" style="display:inline-block;width:100%;max-width:640px"><span style="display:block;overflow:hidden;position:relative;padding-bottom:56.25%"><iframe allowfullscreen="" loading="lazy" scrolling="no" style="background:url(https://i.ytimg.com/vi/'.$attributes['id'].'/hqdefault.jpg) 50% 50% / cover;border:0;height:100%;left:0;position:absolute;width:100%" src="https://www.youtube-nocookie.com/embed/'.$attributes['id'];if(isset($attributes['clip']))$html.='?clip='.$attributes['clip'].'&amp;clipt='.$attributes['clipt'];else{if(isset($attributes['list']))$html.='?list='.$attributes['list'];if(isset($attributes['t'])){if(isset($attributes['list']))$html.='&amp;';else$html.='?';$html.='start='.$attributes['t'];}}$html.='"></iframe></span></span>';}

		return $html;
	}
}