<?php

use Symfony\Component\Translation\MessageCatalogue;

$catalogue = new MessageCatalogue('en', array (
  'messages+intl-icu' => 
  array (
    'core.admin.appearance.colored_header_label' => 'Colored Header',
    'core.admin.appearance.colors_heading' => 'Colors',
    'core.admin.appearance.colors_primary_label' => 'Primary Color',
    'core.admin.appearance.colors_secondary_label' => 'Secondary Color',
    'core.admin.appearance.colors_text' => 'Choose two colors to theme your forum with. The first will be used as a highlight color, while the second will be used to style background elements.',
    'core.admin.appearance.custom_footer_heading' => 'Custom Footer',
    'core.admin.appearance.custom_footer_text' => '=> core.ref.custom_footer_text',
    'core.admin.appearance.custom_header_heading' => 'Custom Header',
    'core.admin.appearance.custom_header_text' => '=> core.ref.custom_header_text',
    'core.admin.appearance.custom_styles_cannot_use_less_features' => 'The @import and data-uri features are not allowed in custom LESS.',
    'core.admin.appearance.custom_styles_heading' => 'Custom Styles',
    'core.admin.appearance.custom_styles_text' => 'Customize your forum\'s appearance by adding your own Less/CSS code to be applied on top of Flarum\'s default styles.',
    'core.admin.appearance.dark_mode_label' => 'Dark Mode',
    'core.admin.appearance.description' => 'Customize your forum\'s colors, logos, and other variables.',
    'core.admin.appearance.edit_css_button' => 'Edit Custom CSS',
    'core.admin.appearance.edit_footer_button' => '=> core.ref.custom_footer_title',
    'core.admin.appearance.edit_header_button' => '=> core.ref.custom_header_title',
    'core.admin.appearance.enter_hex_message' => 'Please enter a hexadecimal color code.',
    'core.admin.appearance.favicon_heading' => 'Favicon',
    'core.admin.appearance.favicon_text' => 'Upload an image to be displayed as the forum\'s shortcut icon.',
    'core.admin.appearance.logo_heading' => 'Logo',
    'core.admin.appearance.logo_text' => 'Upload an image to be displayed in place of the forum title.',
    'core.admin.appearance.title' => 'Appearance',
    'core.admin.basics.all_discussions_label' => '=> core.ref.all_discussions',
    'core.admin.basics.default_language_heading' => 'Default Language',
    'core.admin.basics.description' => 'Set your forum title, language, and other basic settings.',
    'core.admin.basics.display_name_heading' => 'User Display Name',
    'core.admin.basics.display_name_text' => 'Select the driver that should be used for users\' display names. By default, the username is shown.',
    'core.admin.basics.forum_description_heading' => 'Forum Description',
    'core.admin.basics.forum_description_text' => 'Enter a short sentence or two that describes your community. This will appear in the meta tag and show up in search engines.',
    'core.admin.basics.forum_title_heading' => 'Forum Title',
    'core.admin.basics.home_page_heading' => 'Home Page',
    'core.admin.basics.home_page_text' => 'Choose the page which users will first see when they visit your forum.',
    'core.admin.basics.show_language_selector_label' => 'Show language selector',
    'core.admin.basics.slug_driver_heading' => 'Slug Driver: {model}',
    'core.admin.basics.slug_driver_text' => 'Select a driver to be used for slugging this model.',
    'core.admin.basics.title' => 'Basics',
    'core.admin.basics.welcome_banner_heading' => 'Welcome Banner',
    'core.admin.basics.welcome_banner_text' => 'Configure the text that displays in the banner on the All Discussions page. Use this to welcome guests to your forum.',
    'core.admin.create_user.email_placeholder' => '=> core.ref.email',
    'core.admin.create_user.email_confirmed_label' => 'Require user to confirm this email',
    'core.admin.create_user.password_placeholder' => '=> core.ref.password',
    'core.admin.create_user.submit_and_create_another_button' => 'Create and add another',
    'core.admin.create_user.submit_button' => 'Create user',
    'core.admin.create_user.title' => 'Create new user',
    'core.admin.create_user.use_random_password' => 'Generate random password',
    'core.admin.create_user.username_placeholder' => '=> core.ref.username',
    'core.admin.dashboard.clear_cache_button' => 'Clear Cache',
    'core.admin.dashboard.description' => 'Your forum at a glance.',
    'core.admin.dashboard.io_error_message' => 'Could not write to filesystem. Check your filesystem permissions and try again. Or try running from the command line.',
    'core.admin.dashboard.status.headers.scheduler-status' => 'Scheduler',
    'core.admin.dashboard.status.headers.queue-driver' => 'Queue Driver',
    'core.admin.dashboard.status.headers.session-driver' => 'Session Driver',
    'core.admin.dashboard.status.scheduler.active' => 'Active',
    'core.admin.dashboard.status.scheduler.inactive' => 'Inactive',
    'core.admin.dashboard.status.scheduler.never-run' => 'Never run',
    'core.admin.dashboard.title' => 'Dashboard',
    'core.admin.dashboard.tools_button' => 'Tools',
    'core.admin.debug-warning.detail' => 'When <code>debug</code> mode is active, Flarum will rebuild its <code>JavaScript</code> and <code>CSS</code> assets on every request, and could also potentially leak other information, such as database secrets, environment variables, etc.

It is highly recommended to disable <code>debug</code> in your <code>config.php</code> file in production. See <link>Flarum docs</link> for more information.
',
    'core.admin.debug-warning.label' => 'Debug mode active',
    'core.admin.edit_css.customize_text' => 'Customize your forum\'s appearance by adding your own Less/CSS code to be applied on top of Flarum\'s <a>default styles</a>.',
    'core.admin.edit_css.submit_button' => '=> core.ref.save_changes',
    'core.admin.edit_css.title' => 'Edit Custom CSS',
    'core.admin.edit_footer.customize_text' => '=> core.ref.custom_footer_text',
    'core.admin.edit_footer.submit_button' => '=> core.ref.save_changes',
    'core.admin.edit_footer.title' => '=> core.ref.custom_footer_title',
    'core.admin.edit_group.color_label' => '=> core.ref.color',
    'core.admin.edit_group.delete_button' => 'Delete Group',
    'core.admin.edit_group.delete_confirmation' => 'Are you sure you want to delete this group? The group members will NOT be deleted.',
    'core.admin.edit_group.hide_label' => 'Hide on forum',
    'core.admin.edit_group.icon_label' => '=> core.ref.icon',
    'core.admin.edit_group.icon_text' => '=> core.ref.icon_text',
    'core.admin.edit_group.name_label' => 'Name',
    'core.admin.edit_group.plural_placeholder' => 'Plural (e.g. Mods)',
    'core.admin.edit_group.singular_placeholder' => 'Singular (e.g. Mod)',
    'core.admin.edit_group.submit_button' => '=> core.ref.save_changes',
    'core.admin.edit_group.title' => 'Create Group',
    'core.admin.edit_header.customize_text' => '=> core.ref.custom_header_text',
    'core.admin.edit_header.submit_button' => '=> core.ref.save_changes',
    'core.admin.edit_header.title' => '=> core.ref.custom_header_title',
    'core.admin.email.addresses_heading' => 'Addresses',
    'core.admin.email.description' => 'Configure the driver, settings and addresses your forum will use to send email.',
    'core.admin.email.driver_heading' => 'Choose a Driver',
    'core.admin.email.driver_label' => 'Driver',
    'core.admin.email.from_label' => 'Sender',
    'core.admin.email.mail_encryption_label' => 'Encryption',
    'core.admin.email.mail_host_label' => 'Host',
    'core.admin.email.mail_mailgun_domain_label' => 'Domain',
    'core.admin.email.mail_mailgun_region_label' => 'Region',
    'core.admin.email.mail_mailgun_secret_label' => 'Secret key',
    'core.admin.email.mail_password_label' => '=> core.ref.password',
    'core.admin.email.mail_port_label' => 'Port',
    'core.admin.email.mail_username_label' => '=> core.ref.username',
    'core.admin.email.mailgun_heading' => 'Mailgun Settings',
    'core.admin.email.not_sending_message' => 'Flarum currently does not send emails. This can be due to the selected driver, or errors in its configuration.',
    'core.admin.email.send_test_mail_button' => 'Send',
    'core.admin.email.send_test_mail_heading' => 'Send Test Mail',
    'core.admin.email.send_test_mail_success' => 'Test mail sent successfully!',
    'core.admin.email.send_test_mail_text' => 'This will send an email using the above configuration to your email, {email}.',
    'core.admin.email.smtp_heading' => 'SMTP Settings',
    'core.admin.email.title' => '=> core.ref.email',
    'core.admin.extension.configure_scopes' => 'Configure Scopes',
    'core.admin.extension.confirm_purge' => 'Purging will remove all database entries and assets related to the extension. It will not uninstall the extension; that must be done via Composer. Are you sure you want to continue?',
    'core.admin.extension.disabled' => 'Disabled',
    'core.admin.extension.enable_to_see' => 'Enable the extension to view and change settings.',
    'core.admin.extension.enabled' => 'Enabled',
    'core.admin.extension.info_links.discuss' => 'Discuss',
    'core.admin.extension.info_links.documentation' => 'Documentation',
    'core.admin.extension.info_links.donate' => 'Donate',
    'core.admin.extension.info_links.source' => 'Source',
    'core.admin.extension.info_links.support' => 'Support',
    'core.admin.extension.info_links.website' => 'Website',
    'core.admin.extension.no_permissions' => 'This extension has no permissions.',
    'core.admin.extension.no_settings' => 'This extension has no settings.',
    'core.admin.extension.open_modal' => 'Open Settings',
    'core.admin.extension.permissions_title' => 'Permissions',
    'core.admin.extension.purge_button' => 'Purge',
    'core.admin.extension.readme.button_label' => 'README',
    'core.admin.extension.readme.no_readme' => 'This extension does not appear to have a README file',
    'core.admin.extension.readme.title' => '{extName} documentation',
    'core.admin.header.get_help' => 'Get Help',
    'core.admin.header.log_out_button' => '=> core.ref.log_out',
    'core.admin.loading.title' => 'Please Wait...',
    'core.admin.nav.appearance_button' => '=> core.admin.appearance.title',
    'core.admin.nav.appearance_title' => '=> core.admin.appearance.description',
    'core.admin.nav.basics_button' => '=> core.admin.basics.title',
    'core.admin.nav.basics_title' => '=> core.admin.basics.description',
    'core.admin.nav.categories.authentication' => 'Authentication',
    'core.admin.nav.categories.core' => 'Core Configuration',
    'core.admin.nav.categories.discussion' => 'Discussion',
    'core.admin.nav.categories.feature' => 'Features',
    'core.admin.nav.categories.formatting' => 'Formatting',
    'core.admin.nav.categories.language' => 'Languages',
    'core.admin.nav.categories.moderation' => 'Moderation',
    'core.admin.nav.categories.other' => 'Other Extensions',
    'core.admin.nav.categories.theme' => 'Themes',
    'core.admin.nav.dashboard_button' => '=> core.admin.dashboard.title',
    'core.admin.nav.dashboard_title' => '=> core.admin.dashboard.description',
    'core.admin.nav.email_button' => '=> core.ref.email',
    'core.admin.nav.email_title' => '=> core.admin.email.description',
    'core.admin.nav.permissions_button' => '=> core.admin.permissions.title',
    'core.admin.nav.permissions_title' => '=> core.admin.permissions.description',
    'core.admin.nav.userlist_button' => '=> core.admin.users.title',
    'core.admin.nav.userlist_title' => '=> core.admin.users.description',
    'core.admin.nav.search_placeholder' => 'Search Extensions',
    'core.admin.permissions.allow_hide_own_posts_label' => 'Allow deleting own posts',
    'core.admin.permissions.allow_post_editing_label' => 'Allow post editing',
    'core.admin.permissions.allow_renaming_label' => 'Allow renaming',
    'core.admin.permissions.create_access_token_label' => 'Create access token',
    'core.admin.permissions.create_heading' => 'Create',
    'core.admin.permissions.delete_discussions_forever_label' => 'Delete discussions forever',
    'core.admin.permissions.delete_discussions_label' => 'Delete discussions',
    'core.admin.permissions.delete_posts_forever_label' => 'Delete posts forever',
    'core.admin.permissions.delete_posts_label' => 'Delete posts',
    'core.admin.permissions.description' => 'Configure who can see and do what.',
    'core.admin.permissions.edit_posts_label' => 'Edit posts',
    'core.admin.permissions.edit_users_label' => 'Edit user attributes',
    'core.admin.permissions.edit_users_credentials_label' => 'Edit user credentials',
    'core.admin.permissions.edit_users_groups_label' => 'Edit user groups',
    'core.admin.permissions.global_heading' => 'Global',
    'core.admin.permissions.moderate_heading' => 'Moderate',
    'core.admin.permissions.moderate_access_tokens_label' => 'Moderate Access Tokens',
    'core.admin.permissions.new_group_button' => 'New Group',
    'core.admin.permissions.participate_heading' => 'Participate',
    'core.admin.permissions.post_without_throttle_label' => 'Reply multiple times without waiting',
    'core.admin.permissions.read_heading' => 'Read',
    'core.admin.permissions.remove_scope_label' => 'Remove scope of {scope}',
    'core.admin.permissions.rename_discussions_label' => 'Rename discussions',
    'core.admin.permissions.reply_to_discussions_label' => 'Reply to discussions',
    'core.admin.permissions.search_users_label' => '=> core.ref.search_users',
    'core.admin.permissions.sign_up_label' => 'Sign up',
    'core.admin.permissions.start_discussions_label' => 'Start discussions',
    'core.admin.permissions.title' => 'Permissions',
    'core.admin.permissions.view_forum_label' => 'View forum (discussions and users)',
    'core.admin.permissions.view_hidden_groups_label' => 'View hidden group badges',
    'core.admin.permissions.view_last_seen_at_label' => 'Always view user last seen time',
    'core.admin.permissions.view_post_ips_label' => 'View post IP addresses',
    'core.admin.permissions_controls.allow_indefinitely_button' => 'Indefinitely',
    'core.admin.permissions_controls.allow_never_button' => '=> core.ref.never',
    'core.admin.permissions_controls.allow_some_minutes_button' => '{count, plural, one {For # minute} other {For # minutes}}',
    'core.admin.permissions_controls.allow_ten_minutes_button' => 'For 10 minutes',
    'core.admin.permissions_controls.allow_until_reply_button' => 'Until next reply',
    'core.admin.permissions_controls.everyone_button' => 'Everyone',
    'core.admin.permissions_controls.members_button' => '=> core.group.members',
    'core.admin.permissions_controls.signup_closed_button' => 'Closed',
    'core.admin.permissions_controls.signup_open_button' => 'Open',
    'core.admin.settings.saved_message' => 'Your changes were saved.',
    'core.admin.settings.submit_button' => '=> core.ref.save_changes',
    'core.admin.upload_image.remove_button' => '=> core.ref.remove',
    'core.admin.upload_image.upload_button' => 'Choose an Image...',
    'core.admin.users.create_user_button' => 'New User',
    'core.admin.users.description' => 'A paginated list of all users on your forum.',
    'core.admin.users.grid.columns.display_name.title' => 'Display name',
    'core.admin.users.grid.columns.edit_user.button' => '=> core.ref.edit',
    'core.admin.users.grid.columns.edit_user.tooltip' => 'Edit {username}',
    'core.admin.users.grid.columns.email.title' => '=> core.ref.email',
    'core.admin.users.grid.columns.email.visibility_hide' => 'Hide email address',
    'core.admin.users.grid.columns.email.visibility_show' => 'Show email address',
    'core.admin.users.grid.columns.group_badges.no_badges' => 'None',
    'core.admin.users.grid.columns.group_badges.title' => 'Groups',
    'core.admin.users.grid.columns.join_time.title' => 'Joined',
    'core.admin.users.grid.columns.user_actions.title' => 'Actions',
    'core.admin.users.grid.columns.user_id.title' => 'ID',
    'core.admin.users.grid.columns.username.profile_link_tooltip' => 'Visit {username}\'s profile',
    'core.admin.users.grid.columns.username.title' => '=> core.ref.username',
    'core.admin.users.grid.invalid_column_content' => 'Invalid',
    'core.admin.users.pagination.back_button' => 'Previous page',
    'core.admin.users.pagination.first_button' => 'Go to first page',
    'core.admin.users.pagination.go_to_page_textbox_a11y_label' => 'Go directly to page number',
    'core.admin.users.pagination.last_button' => 'Go to last page',
    'core.admin.users.pagination.next_button' => 'Next page',
    'core.admin.users.pagination.page_counter' => 'Page {current} of {total}',
    'core.admin.users.search_placeholder' => '=> core.ref.search_users',
    'core.admin.users.title' => '=> core.ref.users',
    'core.admin.users.total_users' => 'Total users: {count}',
    'core.forum.change_email.confirm_password_placeholder' => '=> core.ref.confirm_password',
    'core.forum.change_email.confirmation_message' => '=> core.ref.confirmation_email_sent',
    'core.forum.change_email.dismiss_button' => '=> core.ref.okay',
    'core.forum.change_email.incorrect_password_message' => 'The password you entered is incorrect.',
    'core.forum.change_email.submit_button' => '=> core.ref.save_changes',
    'core.forum.change_email.title' => '=> core.ref.change_email',
    'core.forum.change_password.send_button' => 'Send Password Reset Email',
    'core.forum.change_password.text' => 'Click the button below and check your email for a link to change your password.',
    'core.forum.change_password.title' => '=> core.ref.change_password',
    'core.forum.composer.close_tooltip' => 'Close',
    'core.forum.composer.exit_full_screen_tooltip' => 'Exit Full Screen',
    'core.forum.composer.full_screen_tooltip' => 'Full Screen',
    'core.forum.composer.minimize_tooltip' => 'Minimize',
    'core.forum.composer.preview_tooltip' => 'Preview',
    'core.forum.composer_discussion.body_placeholder' => 'Write a Post...',
    'core.forum.composer_discussion.discard_confirmation' => 'You have not posted your discussion. Do you wish to discard it?',
    'core.forum.composer_discussion.submit_button' => 'Post Discussion',
    'core.forum.composer_discussion.title' => '=> core.ref.start_a_discussion',
    'core.forum.composer_discussion.title_placeholder' => 'Discussion Title',
    'core.forum.composer_edit.discard_confirmation' => 'You have not saved your changes. Do you wish to discard them?',
    'core.forum.composer_edit.edited_message' => 'Your edit was made.',
    'core.forum.composer_edit.post_link' => 'Post #{number} in {discussion}',
    'core.forum.composer_edit.submit_button' => '=> core.ref.save_changes',
    'core.forum.composer_edit.view_button' => '=> core.ref.view',
    'core.forum.composer_reply.body_placeholder' => '=> core.ref.write_a_reply',
    'core.forum.composer_reply.discard_confirmation' => 'You have not posted your reply. Do you wish to discard it?',
    'core.forum.composer_reply.posted_message' => 'Your reply was posted.',
    'core.forum.composer_reply.submit_button' => 'Post Reply',
    'core.forum.composer_reply.view_button' => '=> core.ref.view',
    'core.forum.discussion_controls.cannot_reply_button' => 'Can\'t Reply',
    'core.forum.discussion_controls.cannot_reply_text' => 'You don\'t have permission to reply to this discussion.',
    'core.forum.discussion_controls.delete_button' => '=> core.ref.delete',
    'core.forum.discussion_controls.delete_confirmation' => 'Are you sure you want to delete this discussion?',
    'core.forum.discussion_controls.delete_forever_button' => '=> core.ref.delete_forever',
    'core.forum.discussion_controls.log_in_to_reply_button' => 'Log In to Reply',
    'core.forum.discussion_controls.rename_button' => '=> core.ref.rename',
    'core.forum.discussion_controls.reply_button' => '=> core.ref.reply',
    'core.forum.discussion_controls.restore_button' => '=> core.ref.restore',
    'core.forum.discussion_controls.toggle_dropdown_accessible_label' => 'Toggle discussion actions dropdown menu',
    'core.forum.discussion_list.empty_text' => 'It looks as though there are no discussions here.',
    'core.forum.discussion_list.load_more_button' => '=> core.ref.load_more',
    'core.forum.discussion_list.replied_text' => '{username} replied {ago}',
    'core.forum.discussion_list.started_text' => '{username} started {ago}',
    'core.forum.discussion_list.total_replies_a11y_label' => '{count, plural, one {# reply} other {# replies}}',
    'core.forum.discussion_list.unread_replies_a11y_label' => '{count, plural, one {# unread reply} other {# unread replies}}. Mark unread {count, plural, one {reply} other {replies}} as read.',
    'core.forum.forgot_password.dismiss_button' => '=> core.ref.okay',
    'core.forum.forgot_password.email_placeholder' => '=> core.ref.email',
    'core.forum.forgot_password.email_sent_message' => 'If the email you entered is registered with this site, we\'ll send you an email containing a link to reset your password. Check your spam folder if you don\'t receive it within the next minute or two.',
    'core.forum.forgot_password.not_found_message' => 'There is no user registered with that email address.',
    'core.forum.forgot_password.submit_button' => 'Recover Password',
    'core.forum.forgot_password.text' => 'Enter your email address and we will send you a link to reset your password.',
    'core.forum.forgot_password.title' => 'Forgot Password',
    'core.forum.header.admin_button' => 'Administration',
    'core.forum.header.back_to_index_tooltip' => 'Back to Discussion List',
    'core.forum.header.locale_dropdown_accessible_label' => 'Change forum locale',
    'core.forum.header.log_in_link' => '=> core.ref.log_in',
    'core.forum.header.log_out_button' => '=> core.ref.log_out',
    'core.forum.header.profile_button' => 'Profile',
    'core.forum.header.search_clear_button_accessible_label' => 'Clear search query',
    'core.forum.header.search_placeholder' => 'Search Forum',
    'core.forum.header.search_role_label' => 'Search Forum',
    'core.forum.header.session_dropdown_accessible_label' => 'Toggle session options dropdown menu',
    'core.forum.header.settings_button' => '=> core.ref.settings',
    'core.forum.header.sign_up_link' => '=> core.ref.sign_up',
    'core.forum.index.all_discussions_link' => '=> core.ref.all_discussions',
    'core.forum.index.cannot_start_discussion_button' => 'Can\'t Start Discussion',
    'core.forum.index.mark_all_as_read_confirmation' => 'Are you sure you want to mark all discussions as read?',
    'core.forum.index.mark_all_as_read_tooltip' => '=> core.ref.mark_all_as_read',
    'core.forum.index.meta_title_text' => '=> core.ref.all_discussions',
    'core.forum.index.refresh_tooltip' => 'Refresh',
    'core.forum.index.start_discussion_button' => '=> core.ref.start_a_discussion',
    'core.forum.index.toggle_sidenav_dropdown_accessible_label' => 'Toggle navigation dropdown menu',
    'core.forum.index_sort.latest_button' => 'Latest',
    'core.forum.index_sort.newest_button' => 'Newest',
    'core.forum.index_sort.oldest_button' => 'Oldest',
    'core.forum.index_sort.relevance_button' => 'Relevance',
    'core.forum.index_sort.toggle_dropdown_accessible_label' => 'Change discussion list sorting',
    'core.forum.index_sort.top_button' => 'Top',
    'core.forum.log_in.forgot_password_link' => 'Forgot password?',
    'core.forum.log_in.invalid_login_message' => 'Your login details were incorrect.',
    'core.forum.log_in.password_placeholder' => '=> core.ref.password',
    'core.forum.log_in.remember_me_label' => 'Remember Me',
    'core.forum.log_in.sign_up_text' => 'Don\'t have an account? <a>Sign Up</a>',
    'core.forum.log_in.submit_button' => '=> core.ref.log_in',
    'core.forum.log_in.title' => '=> core.ref.log_in',
    'core.forum.log_in.username_or_email_placeholder' => 'Username or Email',
    'core.forum.notifications.delete_all_confirm' => 'Are you sure you want to delete all notifications? This action is not reversable',
    'core.forum.notifications.delete_all_tooltip' => 'Delete all notifications',
    'core.forum.notifications.discussion_renamed_text' => '{username} changed the title',
    'core.forum.notifications.empty_text' => 'No Notifications',
    'core.forum.notifications.mark_all_as_read_tooltip' => '=> core.ref.mark_all_as_read',
    'core.forum.notifications.mark_as_read_tooltip' => 'Mark as Read',
    'core.forum.notifications.title' => '=> core.ref.notifications',
    'core.forum.notifications.toggle_dropdown_accessible_label' => 'View notifications',
    'core.forum.notifications.tooltip' => '=> core.ref.notifications',
    'core.forum.post.edited_text' => 'Edited',
    'core.forum.post.edited_tooltip' => '{username} edited {ago}',
    'core.forum.post.number_tooltip' => 'Post #{number}',
    'core.forum.post_controls.delete_button' => '=> core.ref.delete',
    'core.forum.post_controls.delete_confirmation' => 'Are you sure you want to delete this post forever? This action cannot be undone.',
    'core.forum.post_controls.delete_forever_button' => '=> core.ref.delete_forever',
    'core.forum.post_controls.edit_button' => '=> core.ref.edit',
    'core.forum.post_controls.hide_confirmation' => 'Are you sure you want to delete this post?',
    'core.forum.post_controls.restore_button' => '=> core.ref.restore',
    'core.forum.post_controls.toggle_dropdown_accessible_label' => 'Toggle post controls dropdown menu',
    'core.forum.post_scrubber.now_link' => 'Now',
    'core.forum.post_scrubber.original_post_link' => 'Original Post',
    'core.forum.post_scrubber.unread_text' => '{count} unread',
    'core.forum.post_scrubber.viewing_text' => '{count, plural, one {{index} of {formattedCount} post} other {{index} of {formattedCount} posts}}',
    'core.forum.post_stream.discussion_renamed_old_tooltip' => 'The old title was: "{old}"',
    'core.forum.post_stream.discussion_renamed_text' => '{username} changed the title to {new} {time}.',
    'core.forum.post_stream.load_more_button' => '=> core.ref.load_more',
    'core.forum.post_stream.reply_placeholder' => '=> core.ref.write_a_reply',
    'core.forum.post_stream.time_lapsed_text' => '{period} later',
    'core.forum.rename_discussion.submit_button' => '=> core.ref.rename',
    'core.forum.rename_discussion.title' => 'Rename Discussion',
    'core.forum.search.all_discussions_button' => 'Search all discussions for "{query}"',
    'core.forum.search.discussions_heading' => '=> core.ref.discussions',
    'core.forum.search.users_heading' => '=> core.ref.users',
    'core.forum.security.browser_on_operating_system' => '{browser} on {os}',
    'core.forum.security.cannot_terminate_current_session' => 'Cannot terminate the current active session. Log out instead.',
    'core.forum.security.created' => 'Created',
    'core.forum.security.current_active_session' => 'Current Active Session',
    'core.forum.security.developer_tokens_heading' => 'Developer Tokens',
    'core.forum.security.empty_text' => 'It looks like there is nothing to see here.',
    'core.forum.security.global_logout.heading' => 'Global Logout',
    'core.forum.security.global_logout.help_text' => 'Clears current cookie session, terminates all sessions, revokes developer tokens, and invalidates any email confirmation or password reset emails.',
    'core.forum.security.global_logout.log_out_button' => '=> core.ref.log_out',
    'core.forum.security.hide_access_token' => 'Hide Token',
    'core.forum.security.last_activity' => 'Last activity',
    'core.forum.security.never' => '=> core.ref.never',
    'core.forum.security.new_access_token_button' => '=> core.ref.new_token',
    'core.forum.security.new_access_token_modal.submit_button' => 'Create Token',
    'core.forum.security.new_access_token_modal.title' => '=> core.ref.new_token',
    'core.forum.security.new_access_token_modal.title_placeholder' => 'Title',
    'core.forum.security.revoke_access_token' => 'Revoke',
    'core.forum.security.revoke_access_token_confirmation' => '=> core.ref.generic_confirmation_message',
    'core.forum.security.sessions_heading' => 'Active Sessions',
    'core.forum.security.session_terminated' => '{count, plural, one {Session terminated} other {# Sessions terminated}}.',
    'core.forum.security.session_termination_failed' => 'An error occurred while terminating your sessions.',
    'core.forum.security.show_access_token' => 'View Token',
    'core.forum.security.terminate_all_other_sessions' => 'Terminate all other sessions',
    'core.forum.security.terminate_all_other_sessions_confirmation' => '=> core.ref.generic_confirmation_message',
    'core.forum.security.terminate_session' => 'Terminate',
    'core.forum.security.title' => '=> core.ref.security',
    'core.forum.security.token_revoked' => 'Token revoked.',
    'core.forum.security.token_item_title' => '{title} - {token}',
    'core.forum.security.token_title_placeholder' => '/',
    'core.forum.settings.account_heading' => 'Account',
    'core.forum.settings.change_email_button' => '=> core.ref.change_email',
    'core.forum.settings.change_password_button' => '=> core.ref.change_password',
    'core.forum.settings.notification_checkbox_a11y_label_template' => 'Receive "{description}" notifications via {method}',
    'core.forum.settings.notifications_heading' => '=> core.ref.notifications',
    'core.forum.settings.notify_by_email_heading' => '=> core.ref.email',
    'core.forum.settings.notify_by_web_heading' => 'Web',
    'core.forum.settings.notify_discussion_renamed_label' => 'Someone renames a discussion I started',
    'core.forum.settings.privacy_disclose_online_label' => 'Allow others to see when I am online',
    'core.forum.settings.privacy_heading' => 'Privacy',
    'core.forum.settings.title' => '=> core.ref.settings',
    'core.forum.sign_up.dismiss_button' => '=> core.ref.okay',
    'core.forum.sign_up.email_placeholder' => '=> core.ref.email',
    'core.forum.sign_up.log_in_text' => 'Already have an account? <a>Log In</a>',
    'core.forum.sign_up.password_placeholder' => '=> core.ref.password',
    'core.forum.sign_up.submit_button' => '=> core.ref.sign_up',
    'core.forum.sign_up.title' => '=> core.ref.sign_up',
    'core.forum.sign_up.username_placeholder' => '=> core.ref.username',
    'core.forum.sign_up.welcome_text' => 'Welcome, {username}!',
    'core.forum.user.avatar_remove_button' => '=> core.ref.remove',
    'core.forum.user.avatar_upload_button' => 'Upload',
    'core.forum.user.avatar_upload_tooltip' => 'Upload a new avatar',
    'core.forum.user.discussions_link' => '=> core.ref.discussions',
    'core.forum.user.in_discussion_text' => 'In {discussion}',
    'core.forum.user.joined_date_text' => 'Joined {ago}',
    'core.forum.user.online_text' => 'Online',
    'core.forum.user.posts_empty_text' => 'It looks like there are no posts here.',
    'core.forum.user.posts_link' => '=> core.ref.posts',
    'core.forum.user.posts_load_more_button' => '=> core.ref.load_more',
    'core.forum.user.security_link' => '=> core.ref.security',
    'core.forum.user.settings_link' => '=> core.ref.settings',
    'core.forum.user_controls.button' => 'Controls',
    'core.forum.user_controls.delete_button' => '=> core.ref.delete',
    'core.forum.user_controls.delete_confirmation' => 'Are you sure you want to delete this user? The user\'s posts will NOT be deleted.',
    'core.forum.user_controls.delete_error_message' => 'Deletion of user <i>{username} ({email})</i> failed',
    'core.forum.user_controls.delete_success_message' => 'User <i>{username} ({email})</i> was deleted',
    'core.forum.user_controls.edit_button' => '=> core.ref.edit',
    'core.forum.user_controls.toggle_dropdown_accessible_label' => 'Toggle user controls dropdown menu',
    'core.forum.user_email_confirmation.alert_message' => '=> core.ref.confirmation_email_sent',
    'core.forum.user_email_confirmation.resend_button' => 'Resend Confirmation Email',
    'core.forum.user_email_confirmation.sent_message' => 'Sent',
    'core.forum.welcome_hero.hide' => 'Hide welcome message',
    'core.lib.debug_button' => 'Debug',
    'core.lib.alert.dismiss_a11y_label' => 'Dismiss alert',
    'core.lib.badge.hidden_tooltip' => 'Hidden',
    'core.lib.dropdown.toggle_dropdown_accessible_label' => 'Toggle dropdown menu',
    'core.lib.data_segment.label' => '{label}:',
    'core.lib.edit_user.activate_button' => 'Activate User',
    'core.lib.edit_user.email_heading' => '=> core.ref.email',
    'core.lib.edit_user.email_label' => '=> core.ref.email',
    'core.lib.edit_user.groups_heading' => 'Groups',
    'core.lib.edit_user.password_heading' => '=> core.ref.password',
    'core.lib.edit_user.password_label' => '=> core.ref.password',
    'core.lib.edit_user.set_password_label' => 'Set new password',
    'core.lib.edit_user.submit_button' => '=> core.ref.save_changes',
    'core.lib.edit_user.title' => '=> core.ref.edit_user',
    'core.lib.edit_user.username_heading' => '=> core.ref.username',
    'core.lib.edit_user.username_label' => '=> core.ref.username',
    'core.lib.edit_user.nothing_available' => 'You are not allowed to edit this user.',
    'core.lib.error.circular_dependencies_message' => 'Circular dependencies detected: {extensions}. Aborting. Please disable one of the extensions and try again.',
    'core.lib.error.dependent_extensions_message' => 'Cannot disable {extension} until the following dependent extensions are disabled: {extensions}',
    'core.lib.error.extension_initialiation_failed_message' => '{extension} failed to initialize, check the browser console for further information.',
    'core.lib.error.generic_message' => 'Oops! Something went wrong. Please reload the page and try again.',
    'core.lib.error.generic_cross_origin_message' => 'Oops! Something went wrong during a cross-origin request. Please reload the page and try again.',
    'core.lib.error.missing_dependencies_message' => 'Cannot enable {extension} until the following dependencies are enabled: {extensions}',
    'core.lib.error.not_found_message' => 'The requested resource was not found.',
    'core.lib.error.payload_too_large_message' => 'The request payload was too large.',
    'core.lib.error.permission_denied_message' => 'You do not have permission to do that.',
    'core.lib.error.rate_limit_exceeded_message' => 'You\'re going a little too quickly. Please try again in a few seconds.',
    'core.lib.error.render_failed_message' => 'Sorry, we encountered an error while displaying this content. If you\'re a user, please try again later. If you\'re an administrator, take a look in your Flarum log files for more information.',
    'core.lib.loading_indicator.accessible_label' => '=> core.ref.loading',
    'core.lib.meta_titles.with_page_title' => '{pageNumber, plural, =1 {{pageTitle} - {forumName}} other {{pageTitle}: Page # - {forumName}}}',
    'core.lib.meta_titles.without_page_title' => '{pageNumber, plural, =1 {{forumName}} other {Page # - {forumName}}}',
    'core.lib.modal.close' => 'Close',
    'core.lib.nav.drawer_button' => 'Open Navigation Drawer',
    'core.lib.number_suffix.kilo_text' => 'K',
    'core.lib.number_suffix.mega_text' => 'M',
    'core.lib.datetime_formats.humanTimeShort' => 'D MMM',
    'core.lib.datetime_formats.humanTimeLong' => 'll',
    'core.lib.datetime_formats.scrubber' => 'MMMM YYYY',
    'core.lib.series.glue_text' => ', ',
    'core.lib.series.three_text' => '{first}, {second}, and {third}',
    'core.lib.series.two_text' => '{first} and {second}',
    'core.lib.username.deleted_text' => '[deleted]',
    'core.views.admin.extensions.caption' => '=> core.ref.extensions',
    'core.views.admin.extensions.disable' => 'Disable',
    'core.views.admin.extensions.empty' => 'No installed extensions',
    'core.views.admin.extensions.enable' => 'Enable',
    'core.views.admin.extensions.name' => 'Extension Name',
    'core.views.admin.extensions.package_name' => 'Package Name',
    'core.views.admin.extensions.version' => 'Version',
    'core.views.admin.info.caption' => 'Application Info',
    'core.views.admin.title' => 'Administration',
    'core.views.confirm_email.submit_button' => '=> core.ref.confirm_email',
    'core.views.confirm_email.text' => 'Click the button below to confirm your account\'s email.',
    'core.views.confirm_email.title' => '=> core.ref.confirm_email',
    'core.views.content.javascript_disabled_message' => 'This site is best viewed in a modern browser with JavaScript enabled.',
    'core.views.content.load_error_message' => 'Something went wrong while trying to load the full version of this site. Try hard-refreshing this page to fix the error.',
    'core.views.content.loading_text' => '=> core.ref.loading',
    'core.views.discussion.next_page_button' => '=> core.ref.next_page',
    'core.views.discussion.previous_page_button' => '=> core.ref.previous_page',
    'core.views.error.csrf_token_mismatch' => 'You have been inactive for too long.',
    'core.views.error.csrf_token_mismatch_return_link' => 'Go back, to try again',
    'core.views.error.invalid_confirmation_token' => 'This confirmation link has already been used or is invalid.',
    'core.views.error.not_authenticated' => 'You do not have permission to access this page. Try again after logging in.',
    'core.views.error.not_found' => 'The page you requested could not be found.',
    'core.views.error.not_found_return_link' => 'Return to {forum}',
    'core.views.error.permission_denied' => 'You do not have permission to access this page.',
    'core.views.error.unknown' => 'An error occurred while trying to load this page.',
    'core.views.index.all_discussions_heading' => '=> core.ref.all_discussions',
    'core.views.index.next_page_button' => '=> core.ref.next_page',
    'core.views.index.previous_page_button' => '=> core.ref.previous_page',
    'core.views.log_out.log_out_button' => '=> core.ref.log_out',
    'core.views.log_out.log_out_confirmation' => 'Are you sure you want to log out of {forum}?',
    'core.views.log_out.title' => '=> core.ref.log_out',
    'core.views.reset_password.confirm_password_label' => 'Confirm New Password',
    'core.views.reset_password.new_password_label' => 'New Password',
    'core.views.reset_password.submit_button' => '=> core.ref.save_changes',
    'core.views.reset_password.title' => '=> core.ref.reset_your_password',
    'core.api.invalid_username_message' => 'The username may only contain letters, numbers, and dashes.',
    'core.api.invalid_filter_type.must_be_numeric_message' => 'The {filter} filter must be numeric.',
    'core.api.invalid_filter_type.must_not_be_array_message' => 'The {filter} filter must not be an array.',
    'core.api.invalid_filter_type.must_not_be_multidimensional_array_message' => 'The {filter} filter must not be a multidimensional array.',
    'core.email.activate_account.subject' => 'Activate Your New Account',
    'core.email.activate_account.body' => 'Hey {username}!

Someone (hopefully you!) has signed up to {forum} with this email address.

If this was you, simply click the following link and your account will be activated:
{url}

If you did not sign up, please ignore this email.
',
    'core.email.confirm_email.subject' => 'Confirm Your New Email Address',
    'core.email.confirm_email.body' => 'Hey {username}!

Someone (hopefully you!) has changed their email address on {forum} to this one.

If this was you, simply click the following link and your email will be confirmed:
{url}

If this was not you, please ignore this email.
',
    'core.email.reset_password.subject' => '=> core.ref.reset_your_password',
    'core.email.reset_password.body' => 'Hey {username}!

Someone (hopefully you!) has submitted a forgotten password request for your account on {forum}.

If this was you, click the following link to reset your password:
{url}

If you do not wish to change your password, just ignore this email and nothing will happen.
',
    'core.email.send_test.subject' => 'Flarum Email Test',
    'core.email.send_test.body' => 'Hey {username}!

This is a test email to confirm that your Flarum email configuration is working properly.

If this was you, this email means that your configuration works!

If this was not you, please ignore this email.
',
    'core.ref.all_discussions' => 'All Discussions',
    'core.ref.change_email' => 'Change Email',
    'core.ref.change_password' => 'Change Password',
    'core.ref.color' => 'Color',
    'core.ref.confirm_password' => 'Confirm Password',
    'core.ref.confirm_email' => 'Confirm Email',
    'core.ref.confirmation_email_sent' => 'We\'ve sent a confirmation email to {email}. If it doesn\'t arrive soon, check your spam folder.',
    'core.ref.custom_footer_text' => 'Add HTML to be displayed at the very bottom of the page.',
    'core.ref.custom_footer_title' => 'Edit Custom Footer',
    'core.ref.custom_header_text' => 'Add HTML to be displayed at the very top of the page, above Flarum\'s own header.',
    'core.ref.custom_header_title' => 'Edit Custom Header',
    'core.ref.delete' => 'Delete',
    'core.ref.delete_forever' => 'Delete Forever',
    'core.ref.discussions' => 'Discussions',
    'core.ref.edit' => 'Edit',
    'core.ref.edit_user' => 'Edit User',
    'core.ref.email' => 'Email',
    'core.ref.extensions' => 'Extensions',
    'core.ref.generic_confirmation_message' => 'Are you sure you want to proceed? This action cannot be undone.',
    'core.ref.icon' => 'Icon',
    'core.ref.icon_text' => 'Enter the name of any <a>FontAwesome</a> icon class, <em>including</em> the <code>fas fa-</code> prefix.',
    'core.ref.load_more' => 'Load More',
    'core.ref.loading' => 'Loading...',
    'core.ref.log_in' => 'Log In',
    'core.ref.log_out' => 'Log Out',
    'core.ref.mark_all_as_read' => 'Mark All as Read',
    'core.ref.never' => 'Never',
    'core.ref.new_token' => 'New Token',
    'core.ref.next_page' => 'Next Page',
    'core.ref.notifications' => 'Notifications',
    'core.ref.okay' => 'OK',
    'core.ref.password' => 'Password',
    'core.ref.posts' => 'Posts',
    'core.ref.previous_page' => 'Previous Page',
    'core.ref.remove' => 'Remove',
    'core.ref.rename' => 'Rename',
    'core.ref.reply' => 'Reply',
    'core.ref.reset_your_password' => 'Reset Your Password',
    'core.ref.restore' => 'Restore',
    'core.ref.save_changes' => 'Save Changes',
    'core.ref.search_users' => 'Search users',
    'core.ref.security' => 'Security',
    'core.ref.settings' => 'Settings',
    'core.ref.sign_up' => 'Sign Up',
    'core.ref.some_others' => '{count, plural, one {# other} other {# others}}',
    'core.ref.start_a_discussion' => 'Start a Discussion',
    'core.ref.username' => 'Username',
    'core.ref.users' => 'Users',
    'core.ref.view' => 'View',
    'core.ref.write_a_reply' => 'Write a Reply...',
    'core.ref.you' => 'You',
    'core.group.admin' => 'Admin',
    'core.group.admins' => 'Admins',
    'core.group.guest' => 'Guest',
    'core.group.guests' => 'Guests',
    'core.group.member' => 'Member',
    'core.group.members' => 'Members',
    'core.group.mod' => 'Mod',
    'core.group.mods' => 'Mods',
    'validation.accepted' => 'The :attribute must be accepted.',
    'validation.active_url' => 'The :attribute is not a valid URL.',
    'validation.after' => 'The :attribute must be a date after :date.',
    'validation.after_or_equal' => 'The :attribute must be a date after or equal to :date.',
    'validation.alpha' => 'The :attribute must only contain letters.',
    'validation.alpha_dash' => 'The :attribute must only contain letters, numbers, dashes and underscores.',
    'validation.alpha_num' => 'The :attribute must only contain letters and numbers.',
    'validation.array' => 'The :attribute must be an array.',
    'validation.before' => 'The :attribute must be a date before :date.',
    'validation.before_or_equal' => 'The :attribute must be a date before or equal to :date.',
    'validation.between.numeric' => 'The :attribute must be between :min and :max.',
    'validation.between.file' => 'The :attribute must be between :min and :max kilobytes.',
    'validation.between.string' => 'The :attribute must be between :min and :max characters.',
    'validation.between.array' => 'The :attribute must have between :min and :max items.',
    'validation.boolean' => 'The :attribute field must be true or false.',
    'validation.confirmed' => 'The :attribute confirmation does not match.',
    'validation.date' => 'The :attribute is not a valid date.',
    'validation.date_equals' => 'The :attribute must be a date equal to :date.',
    'validation.date_format' => 'The :attribute does not match the format :format.',
    'validation.different' => 'The :attribute and :other must be different.',
    'validation.digits' => 'The :attribute must be :digits digits.',
    'validation.digits_between' => 'The :attribute must be between :min and :max digits.',
    'validation.dimensions' => 'The :attribute has invalid image dimensions.',
    'validation.distinct' => 'The :attribute field has a duplicate value.',
    'validation.email' => 'The :attribute must be a valid email address.',
    'validation.ends_with' => 'The :attribute must end with one of the following: :values.',
    'validation.exists' => 'The selected :attribute is invalid.',
    'validation.file' => 'The :attribute must be a file.',
    'validation.file_too_large' => 'The :attribute is too large.',
    'validation.file_upload_failed' => 'The :attribute failed to upload.',
    'validation.filled' => 'The :attribute field must have a value.',
    'validation.gt.numeric' => 'The :attribute must be greater than :value.',
    'validation.gt.file' => 'The :attribute must be greater than :value kilobytes.',
    'validation.gt.string' => 'The :attribute must be greater than :value characters.',
    'validation.gt.array' => 'The :attribute must have more than :value items.',
    'validation.gte.numeric' => 'The :attribute must be greater than or equal :value.',
    'validation.gte.file' => 'The :attribute must be greater than or equal :value kilobytes.',
    'validation.gte.string' => 'The :attribute must be greater than or equal :value characters.',
    'validation.gte.array' => 'The :attribute must have :value items or more.',
    'validation.image' => 'The :attribute must be an image.',
    'validation.in' => 'The selected :attribute is invalid.',
    'validation.in_array' => 'The :attribute field does not exist in :other.',
    'validation.integer' => 'The :attribute must be an integer.',
    'validation.ip' => 'The :attribute must be a valid IP address.',
    'validation.ipv4' => 'The :attribute must be a valid IPv4 address.',
    'validation.ipv6' => 'The :attribute must be a valid IPv6 address.',
    'validation.json' => 'The :attribute must be a valid JSON string.',
    'validation.lt.numeric' => 'The :attribute must be less than :value.',
    'validation.lt.file' => 'The :attribute must be less than :value kilobytes.',
    'validation.lt.string' => 'The :attribute must be less than :value characters.',
    'validation.lt.array' => 'The :attribute must have less than :value items.',
    'validation.lte.numeric' => 'The :attribute must be less than or equal :value.',
    'validation.lte.file' => 'The :attribute must be less than or equal :value kilobytes.',
    'validation.lte.string' => 'The :attribute must be less than or equal :value characters.',
    'validation.lte.array' => 'The :attribute must not have more than :value items.',
    'validation.max.numeric' => 'The :attribute must not be greater than :max.',
    'validation.max.file' => 'The :attribute must not be greater than :max kilobytes.',
    'validation.max.string' => 'The :attribute must not be greater than :max characters.',
    'validation.max.array' => 'The :attribute must not have more than :max items.',
    'validation.mimes' => 'The :attribute must be a file of type: :values.',
    'validation.mimetypes' => 'The :attribute must be a file of type: :values.',
    'validation.min.numeric' => 'The :attribute must be at least :min.',
    'validation.min.file' => 'The :attribute must be at least :min kilobytes.',
    'validation.min.string' => 'The :attribute must be at least :min characters.',
    'validation.min.array' => 'The :attribute must have at least :min items.',
    'validation.multiple_of' => 'The :attribute must be a multiple of :value.',
    'validation.not_in' => 'The selected :attribute is invalid.',
    'validation.not_regex' => 'The :attribute format is invalid.',
    'validation.numeric' => 'The :attribute must be a number.',
    'validation.password' => 'The password is incorrect.',
    'validation.present' => 'The :attribute field must be present.',
    'validation.regex' => 'The :attribute format is invalid.',
    'validation.required' => 'The :attribute field is required.',
    'validation.required_array_keys' => 'The :attribute array must contain entries for: :values.',
    'validation.required_if' => 'The :attribute field is required when :other is :value.',
    'validation.required_unless' => 'The :attribute field is required unless :other is in :values.',
    'validation.required_with' => 'The :attribute field is required when :values is present.',
    'validation.required_with_all' => 'The :attribute field is required when :values are present.',
    'validation.required_without' => 'The :attribute field is required when :values is not present.',
    'validation.required_without_all' => 'The :attribute field is required when none of :values are present.',
    'validation.prohibited' => 'The :attribute field is prohibited.',
    'validation.prohibited_if' => 'The :attribute field is prohibited when :other is :value.',
    'validation.prohibited_unless' => 'The :attribute field is prohibited unless :other is in :values.',
    'validation.same' => 'The :attribute and :other must match.',
    'validation.size.numeric' => 'The :attribute must be :size.',
    'validation.size.file' => 'The :attribute must be :size kilobytes.',
    'validation.size.string' => 'The :attribute must be :size characters.',
    'validation.size.array' => 'The :attribute must contain :size items.',
    'validation.starts_with' => 'The :attribute must start with one of the following: :values.',
    'validation.string' => 'The :attribute must be a string.',
    'validation.timezone' => 'The :attribute must be a valid zone.',
    'validation.unique' => 'The :attribute has already been taken.',
    'validation.uploaded' => 'The :attribute failed to upload.',
    'validation.url' => 'The :attribute format is invalid.',
    'validation.uuid' => 'The :attribute must be a valid UUID.',
    'validation.attributes.username' => 'username',
    'validation.attributes.password' => 'password',
    'validation.attributes.email' => 'email',
    'validation.attributes.title' => 'title',
    'validation.attributes.content' => 'content',
    'validation.attributes.name_singular' => 'singular name',
    'validation.attributes.name_plural' => 'plural name',
    'validation.attributes.tag_count_primary' => 'number of primary tags',
    'validation.attributes.tag_count_secondary' => 'number of secondary tags',
    'flarum-flags.admin.permissions.flag_posts_label' => 'Flag posts',
    'flarum-flags.admin.permissions.view_flags_label' => 'View flagged posts',
    'flarum-flags.admin.settings.flag_own_posts_label' => 'Allow users to flag their own posts',
    'flarum-flags.admin.settings.guidelines_url_label' => 'Community Guidelines URL',
    'flarum-flags.admin.settings.title' => 'Flags Settings',
    'flarum-flags.forum.flag_post.confirmation_message' => 'Thank you for flagging this post. Our moderators will look into it.',
    'flarum-flags.forum.flag_post.dismiss_button' => '=> core.ref.okay',
    'flarum-flags.forum.flag_post.reason_details_placeholder' => 'Additional details (optional)',
    'flarum-flags.forum.flag_post.reason_inappropriate_label' => 'Inappropriate',
    'flarum-flags.forum.flag_post.reason_inappropriate_text' => 'This post is offensive, abusive, or violates our <a>community guidelines</a>.',
    'flarum-flags.forum.flag_post.reason_missing_message' => 'Please provide some details for our moderators.',
    'flarum-flags.forum.flag_post.reason_off_topic_label' => 'Off-topic',
    'flarum-flags.forum.flag_post.reason_off_topic_text' => 'This post is not relevant to the current discussion and should be moved elsewhere.',
    'flarum-flags.forum.flag_post.reason_other_label' => 'Other (please specify)',
    'flarum-flags.forum.flag_post.reason_spam_label' => 'Spam',
    'flarum-flags.forum.flag_post.reason_spam_text' => 'This post is an advertisement.',
    'flarum-flags.forum.flag_post.submit_button' => '=> flarum-flags.ref.flag_post',
    'flarum-flags.forum.flag_post.title' => '=> flarum-flags.ref.flag_post',
    'flarum-flags.forum.flagged_posts.empty_text' => 'No Flags',
    'flarum-flags.forum.flagged_posts.item_text' => '{username} in <em>{discussion}</em>',
    'flarum-flags.forum.flagged_posts.title' => '=> flarum-flags.ref.flagged_posts',
    'flarum-flags.forum.flagged_posts.tooltip' => '=> flarum-flags.ref.flagged_posts',
    'flarum-flags.forum.post.dismiss_flag_button' => 'Dismiss Flag',
    'flarum-flags.forum.post.flagged_by_text' => 'Flagged by {username}',
    'flarum-flags.forum.post.flagged_by_with_reason_text' => 'Flagged by {username} as {reason}',
    'flarum-flags.forum.post_controls.flag_button' => 'Flag',
    'flarum-flags.ref.flag_post' => 'Flag Post',
    'flarum-flags.ref.flagged_posts' => 'Flagged Posts',
    'flarum-suspend.admin.permissions.suspend_users_label' => 'Suspend users',
    'flarum-suspend.forum.notifications.user_suspended_text' => 'You have been suspended for {timeReadable}',
    'flarum-suspend.forum.notifications.user_suspended_indefinite_text' => 'You have been suspended indefinitely',
    'flarum-suspend.forum.notifications.user_unsuspended_text' => 'You have been unsuspended',
    'flarum-suspend.forum.suspension_info.dismiss_button' => 'Dismiss',
    'flarum-suspend.forum.suspension_info.indefinite' => 'This is an indefinite suspension',
    'flarum-suspend.forum.suspension_info.limited' => 'This suspension will be in force until {date}',
    'flarum-suspend.forum.suspension_info.title' => 'This account is suspended',
    'flarum-suspend.forum.suspend_user.display_message' => 'Display message for user',
    'flarum-suspend.forum.suspend_user.indefinitely_label' => 'Suspended indefinitely',
    'flarum-suspend.forum.suspend_user.limited_time_days_text' => ' days',
    'flarum-suspend.forum.suspend_user.limited_time_label' => 'Suspended for a limited time...',
    'flarum-suspend.forum.suspend_user.not_suspended_label' => 'Not suspended',
    'flarum-suspend.forum.suspend_user.placeholder_optional' => 'Optional',
    'flarum-suspend.forum.suspend_user.reason' => 'Reason for suspension',
    'flarum-suspend.forum.suspend_user.status_heading' => 'Suspension Status',
    'flarum-suspend.forum.suspend_user.submit_button' => '=> core.ref.save_changes',
    'flarum-suspend.forum.suspend_user.title' => 'Suspend {username}',
    'flarum-suspend.forum.user_badge.suspended_tooltip' => 'Suspended',
    'flarum-suspend.forum.user_controls.suspend_button' => 'Suspend',
    'flarum-suspend.email.no_reason_given' => 'No reason was given for this suspension.',
    'flarum-suspend.email.suspended.subject' => 'Your account has been suspended',
    'flarum-suspend.email.suspended.body' => 'Hey {recipient_display_name},

You have been suspended for the following reason:

---
{suspension_message}
---
',
    'flarum-suspend.email.unsuspended.subject' => 'Your account has been unsuspended',
    'flarum-suspend.email.unsuspended.body' => 'Hey {recipient_display_name},

You have been unsuspended. You can head back to the forum by clicking on the following link:

{forum_url}
',
    'flarum-suspend.validation.attributes.suspendedUntil' => 'suspended until',
    'flarum-approval.admin.permissions.approve_posts_label' => 'Approve posts',
    'flarum-approval.admin.permissions.reply_without_approval_label' => 'Reply to discussions without approval',
    'flarum-approval.admin.permissions.start_discussions_without_approval_label' => 'Start discussions without approval',
    'flarum-approval.forum.badge.awaiting_approval_tooltip' => '=> flarum-approval.ref.awaiting_approval',
    'flarum-approval.forum.post.awaiting_approval_text' => '=> flarum-approval.ref.awaiting_approval',
    'flarum-approval.forum.post_controls.approve_button' => 'Approve',
    'flarum-approval.ref.awaiting_approval' => 'Awaiting approval',
    'flarum-tags.admin.basics.tags_label' => '=> flarum-tags.ref.tags',
    'flarum-tags.admin.edit_tag.color_label' => '=> core.ref.color',
    'flarum-tags.admin.edit_tag.delete_tag_button' => 'Delete Tag',
    'flarum-tags.admin.edit_tag.delete_tag_confirmation' => 'Are you sure you want to delete this tag? The tag\'s discussions will NOT be deleted.',
    'flarum-tags.admin.edit_tag.description_label' => 'Description',
    'flarum-tags.admin.edit_tag.hide_label' => 'Hide from All Discussions',
    'flarum-tags.admin.edit_tag.icon_label' => '=> core.ref.icon',
    'flarum-tags.admin.edit_tag.icon_text' => '=> core.ref.icon_text',
    'flarum-tags.admin.edit_tag.name_label' => '=> flarum-tags.ref.name',
    'flarum-tags.admin.edit_tag.name_placeholder' => '=> flarum-tags.ref.name',
    'flarum-tags.admin.edit_tag.slug_label' => 'Slug',
    'flarum-tags.admin.edit_tag.submit_button' => '=> core.ref.save_changes',
    'flarum-tags.admin.edit_tag.title' => 'Create Tag',
    'flarum-tags.admin.nav.tags_button' => '=> flarum-tags.ref.tags',
    'flarum-tags.admin.nav.tags_text' => 'Manage the list of tags available to organise discussions with.',
    'flarum-tags.admin.permissions.allow_edit_tags_label' => 'Allow tag editing',
    'flarum-tags.admin.permissions.bypass_tag_counts_label' => 'Bypass tag requirements',
    'flarum-tags.admin.permissions.restrict_by_tag_heading' => 'Restrict by Tag',
    'flarum-tags.admin.permissions.tag_discussions_label' => 'Tag discussions',
    'flarum-tags.admin.settings.button_text' => '=> flarum-tags.ref.choose_tags',
    'flarum-tags.admin.tag_settings.range_separator_text' => ' to ',
    'flarum-tags.admin.tag_settings.required_primary_heading' => 'Required Number of Primary Tags',
    'flarum-tags.admin.tag_settings.required_primary_text' => 'Enter the minimum and maximum number of primary tags that may be applied to a discussion.',
    'flarum-tags.admin.tag_settings.required_secondary_heading' => 'Required Number of Secondary Tags',
    'flarum-tags.admin.tag_settings.required_secondary_text' => 'Enter the minimum and maximum number of secondary tags that may be applied to a discussion.',
    'flarum-tags.admin.tag_settings.title' => 'Tag Settings',
    'flarum-tags.admin.tags.about_tags_text' => 'Tags are used to categorize discussions. Primary tags are like traditional forum categories: they can be arranged in a two-level hierarchy. Secondary tags do not have hierarchy or order, and are useful for micro-categorization.',
    'flarum-tags.admin.tags.create_primary_tag_button' => 'Create Primary Tag',
    'flarum-tags.admin.tags.create_secondary_tag_button' => 'Create Secondary Tag',
    'flarum-tags.admin.tags.edit_tag_label' => 'Edit Tag {tag}',
    'flarum-tags.admin.tags.primary_heading' => 'Primary Tags',
    'flarum-tags.admin.tags.secondary_heading' => 'Secondary Tags',
    'flarum-tags.admin.tags.settings_heading' => 'Settings',
    'flarum-tags.forum.all_tags.meta_description_text' => 'All Tags',
    'flarum-tags.forum.all_tags.meta_title_text' => '=> flarum-tags.ref.tags',
    'flarum-tags.forum.choose_tags.edit_title' => 'Edit Tags for {title}',
    'flarum-tags.forum.choose_tags.title' => 'Choose Tags for Your Discussion',
    'flarum-tags.forum.composer_discussion.choose_tags_link' => '=> flarum-tags.ref.choose_tags',
    'flarum-tags.forum.discussion_controls.edit_tags_button' => 'Edit Tags',
    'flarum-tags.forum.header.back_to_tags_tooltip' => 'Back to Tag List',
    'flarum-tags.forum.index.more_link' => 'More...',
    'flarum-tags.forum.index.tags_link' => '=> flarum-tags.ref.tags',
    'flarum-tags.forum.index.untagged_link' => 'Untagged',
    'flarum-tags.forum.post_stream.added_and_removed_tags_text' => '{username} added the {tagsAdded} and removed the {tagsRemoved} {time}.',
    'flarum-tags.forum.post_stream.added_tags_text' => '{username} added the {tagsAdded} {time}.',
    'flarum-tags.forum.post_stream.removed_tags_text' => '{username} removed the {tagsRemoved} {time}.',
    'flarum-tags.forum.post_stream.tags_text' => '{count, plural, one {{tags} tag} other {{tags} tags}}',
    'flarum-tags.forum.tag.meta_description_text' => 'All discussions with the {tag} tag',
    'flarum-tags.lib.deleted_tag_text' => 'Deleted',
    'flarum-tags.lib.tag_selection_modal.bypass_requirements' => 'Bypass tag requirements',
    'flarum-tags.lib.tag_selection_modal.choose_primary_placeholder' => '{count, plural, one {Choose a primary tag} other {Choose # primary tags}}',
    'flarum-tags.lib.tag_selection_modal.choose_secondary_placeholder' => '=> flarum-tags.ref.choose_tags_placeholder',
    'flarum-tags.lib.tag_selection_modal.choose_tags_placeholder' => '=> flarum-tags.ref.choose_tags_placeholder',
    'flarum-tags.lib.tag_selection_modal.submit_button' => '=> core.ref.okay',
    'flarum-tags.lib.tag_selection_modal.title' => '=> flarum-tags.ref.choose_tags',
    'flarum-tags.ref.choose_tags' => 'Choose Tags',
    'flarum-tags.ref.choose_tags_placeholder' => '{count, plural, one {Choose 1 more tag} other {Choose # more tags}}',
    'flarum-tags.ref.name' => 'Name',
    'flarum-tags.ref.tags' => 'Tags',
    'flarum-tags.validation.attributes.name' => 'name',
    'flarum-tags.validation.attributes.slug' => 'slug',
    'flarum-tags.validation.attributes.is_hidden' => 'hidden',
    'flarum-tags.validation.attributes.description' => 'description',
    'flarum-tags.validation.attributes.color' => 'color',
    'flarum-tags.validation.attributes.tag_count_primary' => '=> validation.attributes.tag_count_primary',
    'flarum-tags.validation.attributes.tag_count_secondary' => '=> validation.attributes.tag_count_secondary',
    'signature.forum.buttons.signature' => 'Signature',
    'signature.forum.buttons.save' => 'Save Signature',
    'signature.forum.buttons.edit' => 'Edit Signature',
    'signature.forum.errors.max_char_limit_exceed' => 'Maximum character limit exceeded.',
    'signature.forum.errors.max_image_count_exceed' => 'Maximum image count exceeded.',
    'signature.forum.profile.click' => 'Click to write your signature',
    'signature.admin.permissions.edit_signature_others' => 'Edit other users\' signatures',
    'signature.admin.permissions.allow_signature' => 'Can have a signature',
    'signature.admin.settings.maximum_image_count.description' => 'Maximum inserted images.',
    'signature.admin.settings.maximum_image_count.help' => 'When the user exceeds the maximum image count in their signature, they will be prevented from saving until the image count is accordingly.',
    'signature.admin.settings.maximum_char_limit.description' => 'Maximum character limit of signature.',
    'signature.admin.settings.maximum_char_limit.help' => 'When the user exceeds the maximum character limit in their signature, they will be prevented from saving until the character count is accordingly.',
    'signature.admin.settings.allow_inline_editing.description' => 'Inline editing of signature.',
    'signature.admin.settings.allow_inline_editing.help' => 'When enabled, users can edit their signature while viewing a post.',
    'fof-user-directory.forum.header.back_to_user_directory_tooltip' => 'Back to User Directory',
    'fof-user-directory.forum.hero.title' => '=> fof-user-directory.forum.page.nav',
    'fof-user-directory.forum.search.users_heading' => 'Search all users for "{query}"',
    'fof-user-directory.forum.search.field.placeholder' => 'Search all users',
    'fof-user-directory.forum.search.kinds.group' => 'Group',
    'fof-user-directory.forum.search.kinds.text' => 'Free text',
    'fof-user-directory.forum.page.nav' => 'User Directory',
    'fof-user-directory.forum.page.refresh_tooltip' => '=> core.forum.index.refresh_tooltip',
    'fof-user-directory.forum.page.load_more_button' => '=> core.ref.load_more',
    'fof-user-directory.forum.page.empty_text' => 'We could not find any user matching your search.',
    'fof-user-directory.forum.page.filter_button' => 'Filter Groups',
    'fof-user-directory.forum.page.usercard.discussion-count' => '{count, plural, one { {count} discussion} other {{count} discussions}}',
    'fof-user-directory.forum.page.usercard.post-count' => '{count, plural, one { {count} post} other {{count} posts}}',
    'fof-user-directory.admin.permissions.view_user_directory' => 'View user directory',
    'fof-user-directory.admin.settings.link' => 'Add link on homepage for users able to see the directory',
    'fof-user-directory.admin.settings.default-sort' => 'Default sort',
    'fof-user-directory.admin.settings.use-small-cards' => 'Use small user cards',
    'fof-user-directory.admin.settings.disable-global-search-source' => 'Do not add User Directory to the Flarum global search field',
    'fof-user-directory.admin.settings.link-group-mentions' => 'Link group mentions in posts to the User Directory',
    'fof-user-directory.lib.sort.not_specified' => 'Use Flarum default',
    'fof-user-directory.lib.sort.default' => 'Default',
    'fof-user-directory.lib.sort.username_az' => 'Username (a-z)',
    'fof-user-directory.lib.sort.username_za' => 'Username (z-a)',
    'fof-user-directory.lib.sort.newest' => 'Newest',
    'fof-user-directory.lib.sort.oldest' => 'Oldest',
    'fof-user-directory.lib.sort.most_posts' => 'Most posts',
    'fof-user-directory.lib.sort.least_posts' => 'Least posts',
    'fof-user-directory.lib.sort.most_discussions' => 'Most discussions',
    'fof-user-directory.lib.sort.least_discussions' => 'Least discussions',
    'fof-user-bio.admin.permission.view' => 'View bio',
    'fof-user-bio.admin.permission.editOwn' => 'Edit own bio',
    'fof-user-bio.admin.permission.editAny' => 'Edit any bio',
    'fof-user-bio.admin.setting.bioLimit' => 'Bio character limit',
    'fof-user-bio.admin.setting.maxLines' => 'Max number of lines to show at a time',
    'fof-user-bio.admin.setting.allowFormatting' => 'Allow formatting in bio',
    'fof-user-bio.admin.setting.allowFormatting_help' => 'By design, this formatting is separate from post formatting. If the BBCode and/or Markdown extensions are enabled, they will be available to format the bio. No images or embeds are allowed. Extensions that add to the Flarum formatter must *explicitly* add support for the bio formatter.',
    'fof-user-bio.forum.userbioPlaceholder' => 'Write something about yourself',
    'fof-user-bio.forum.userbioPlaceholderOtherUser' => 'Write a bio for {username}',
    'fof-user-bio.forum.profile.cancel_confirm' => 'Are you sure you want to cancel editing your bio? You\'ll lose any changes you\'ve made.',
    'fof-user-bio.forum.profile.cancel_button' => 'Cancel',
    'fof-user-bio.forum.profile.save_button' => 'Save',
    'fof-user-bio.forum.profile.edit_bio_label' => 'Edit bio',
    'flarum-gdpr.lib.data.uploads.export_description' => 'All files uploaded by the user.',
    'flarum-gdpr.lib.data.uploads.anonymize_description' => 'Removes the user reference from the uploaded files. The files themselves remain accessible to users that could view them pre-anonymization.',
    'flarum-gdpr.lib.data.uploads.delete_description' => 'Deletes all files uploaded by the user.',
    'fof-upload.admin.nav.shared-uploads-button' => 'Shared uploads',
    'fof-upload.admin.shared-uploads.description' => 'Upload files that can be used by all users of your forum.',
    'fof-upload.admin.shared-uploads.introduction' => 'Shared uploads are files that can be used by all users of your forum. They are not attached to any post, but can be inserted into posts by using the media manager.

<strong>Warning:</strong> Shared uploads are not protected by any permissions. Anyone with the URL can view them.
',
    'fof-upload.admin.shared-uploads.no-files' => 'No shared files have been uploaded yet.',
    'fof-upload.admin.shared-uploads.title' => 'Shared uploads',
    'fof-upload.admin.shared-uploads.upload-new-button' => 'Upload new file',
    'fof-upload.admin.pane.title' => 'Upload',
    'fof-upload.admin.pane.description' => 'Set up uploading services and preferences.',
    'fof-upload.admin.help_texts.disable-download-logging' => 'Disable logging every download made by users of your forum. Keeping it enabled allows you to view the number of downloads and other metrics in the nearby future.
',
    'fof-upload.admin.help_texts.disable-hotlink-protection' => 'Hotlink protection prevents opening downloads from other sites. Current method requires a csrf token and post id.
',
    'fof-upload.admin.help_texts.download_templates' => 'Download templates are how uploads are shown on your forum, eg like previews, buttons. Currently available:
',
    'fof-upload.admin.help_texts.mime_types' => 'Please configure your mapping here. Each mime type regular expression will be handled by a specific upload adapter and download template.
',
    'fof-upload.admin.help_texts.resize' => 'Choose whether you want to resize your images before they get uploaded. You can choose a maximum width and height, in pixels. The resizing process keeps the aspect ratio of the images.
',
    'fof-upload.admin.help_texts.client_extension' => 'By default Upload will choose a safe file extension based on the MIME type.
For some file types based around ZIP or binary data this can result in generic extensions being used instead of the expected one.
Here you can enter a comma-separated list of file extensions that will be kept verbatim.
',
    'fof-upload.admin.help_texts.watermark' => 'Choose whether images will have a watermark added during upload. Watermarks are added to non-gifs based on your preferences below.
',
    'fof-upload.admin.help_texts.s3_compatible_storage' => 'The following settings are only required when using S3 compatible storage. If you use AWS, you can leave them blank.
',
    'fof-upload.admin.help_texts.s3_acl' => 'The ACL that should be applied to the uploaded object (default: private). For possible values, see https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl
',
    'fof-upload.admin.help_texts.custom_s3_url' => 'Use this setting if you are using an S3-compatible service that requires a specific URL format (e.g., Backblaze B2) or if you are experiencing issues with the default URL format. This setting is generally not necessary for most services. Ensure the URL includes the protocol (https://) and is correctly formatted. Example: https://your-bucket.s3.your-region.backblazeb2.com
',
    'fof-upload.admin.help_texts.s3_instance_profile' => 'Leave key and secret empty to use credentials in instance profile.
',
    'fof-upload.admin.help_texts.composer_buttons' => 'By default both the media manager button and upload button are visible. You can also choose to display only one button.
',
    'fof-upload.admin.labels.aws-s3.bucket' => 'Bucket',
    'fof-upload.admin.labels.aws-s3.key' => 'Key',
    'fof-upload.admin.labels.aws-s3.region' => 'Region',
    'fof-upload.admin.labels.aws-s3.secret' => 'Secret',
    'fof-upload.admin.labels.aws-s3.title' => 'AWS S3 storage settings',
    'fof-upload.admin.labels.aws-s3.advanced_title' => 'Advanced S3 storage settings',
    'fof-upload.admin.labels.aws-s3.endpoint' => 'Endpoint',
    'fof-upload.admin.labels.aws-s3.use_path_style_endpoint' => 'Use path style endpoint',
    'fof-upload.admin.labels.aws-s3.acl' => 'Access Control List (ACL)',
    'fof-upload.admin.labels.aws-s3.custom_url' => 'Custom S3 URL',
    'fof-upload.admin.labels.disable-download-logging.title' => 'Disable logging downloads',
    'fof-upload.admin.labels.disable-download-logging.toggle' => 'Disable',
    'fof-upload.admin.labels.disable-hotlink-protection.title' => 'Disable hotlink protection',
    'fof-upload.admin.labels.disable-hotlink-protection.toggle' => 'Disable',
    'fof-upload.admin.labels.imgur.client_id' => 'Imgur client ID',
    'fof-upload.admin.labels.imgur.title' => 'Imgur image storage settings',
    'fof-upload.admin.labels.imgur.tos' => 'It is your responsibility to ensure your forum users adhere to Imgur\'s <a>Terms of service</a>',
    'fof-upload.admin.labels.local.cdn_url' => 'Content Delivery URL (prefixes files)',
    'fof-upload.admin.labels.local.title' => 'Local storage settings',
    'fof-upload.admin.labels.qiniu.title' => 'Qiniu storage settings',
    'fof-upload.admin.labels.qiniu.key' => 'Key',
    'fof-upload.admin.labels.qiniu.secret' => 'Secret',
    'fof-upload.admin.labels.qiniu.bucket' => 'Bucket',
    'fof-upload.admin.labels.preferences.max_file_size' => 'Maximum file size (in kilobytes)',
    'fof-upload.admin.labels.preferences.mime_types' => 'Configure your mime type, upload adapter mapping',
    'fof-upload.admin.labels.preferences.title' => 'General preferences',
    'fof-upload.admin.labels.preferences.php_ini_values' => 'Your <code>php.ini</code> values are <code>post_max_size={post}</code> and <code>upload_max_filesize={upload}</code>. Ensure the value set here is below these thresholds, or adjust them accordingly. If using <code>Nginx</code>, also ensure that <code>client_max_body_size</code> is of sufficient size for your chosen max limit.',
    'fof-upload.admin.labels.resize.max_width' => 'Maximum image width/height',
    'fof-upload.admin.labels.resize.title' => 'Image resize',
    'fof-upload.admin.labels.resize.toggle' => 'Resize images',
    'fof-upload.admin.labels.client_extension.title' => 'User-provided file extensions',
    'fof-upload.admin.labels.watermark.file' => 'Upload your watermark image',
    'fof-upload.admin.labels.watermark.position' => 'Watermark position',
    'fof-upload.admin.labels.watermark.title' => 'Watermark images',
    'fof-upload.admin.labels.watermark.toggle' => 'Watermark images',
    'fof-upload.admin.labels.composer_buttons.title' => 'Composer buttons',
    'fof-upload.admin.labels.composer_buttons.options.both' => 'Both',
    'fof-upload.admin.labels.composer_buttons.options.upload-btn' => 'Upload button only',
    'fof-upload.admin.labels.composer_buttons.options.media-btn' => 'Media manager button only',
    'fof-upload.admin.labels.inspect-mime' => 'Test file MIME type',
    'fof-upload.admin.permissions.download_label' => 'Download files',
    'fof-upload.admin.permissions.upload_label' => 'Upload files',
    'fof-upload.admin.permissions.view_user_uploads_label' => 'View user uploads',
    'fof-upload.admin.permissions.delete_uploads_of_others_label' => 'Delete user uploads',
    'fof-upload.admin.permissions.upload_shared_label' => 'Upload shared files',
    'fof-upload.admin.permissions.access_shared_label' => 'Access shared files in Media Manager',
    'fof-upload.admin.templates.file' => 'Default file download template',
    'fof-upload.admin.templates.file_description' => 'Shows the file name and some general information. Proxies downloads through php, allowing for statistics gathering and hotlink protection.
',
    'fof-upload.admin.templates.image' => 'Default image download template',
    'fof-upload.admin.templates.image_description' => 'Shows a thumbnail of the image and proxies download through php. Allowing statistics to be gathered and hotlink protection.
',
    'fof-upload.admin.templates.image-preview' => 'Complete image preview template',
    'fof-upload.admin.templates.image-preview_description' => 'Shows the complete image in-line. No download functionality, no statistics are gathered and hotlink protection is ignored.
',
    'fof-upload.admin.templates.markdown-image' => 'Markdown image template',
    'fof-upload.admin.templates.markdown-image_description' => 'Shows the complete image in-line using Markdown. <strong>You must have flarum/markdown installed and enabled for this to work.</strong> No download functionality, no statistics are gathered and hotlink protection is ignored.
',
    'fof-upload.admin.templates.bbcode-image' => 'BBCode image template',
    'fof-upload.admin.templates.bbcode-image_description' => 'Shows the complete image in-line using BBCode. <strong>You must have flarum/bbcode installed and enabled for this to work.</strong> No download functionality, no statistics are gathered and hotlink protection is ignored.
',
    'fof-upload.admin.templates.just-url' => 'Just URL',
    'fof-upload.admin.templates.just-url_description' => 'Inserts just the URL. Rendering can be handled by other extensions with auto-link ability. No download functionality, no statistics are gathered and hotlink protection is ignored.
',
    'fof-upload.admin.templates.text-preview' => 'Text preview',
    'fof-upload.admin.templates.text-preview_description' => 'Inserts a preview (first 5 lines) of the text file, with an option to expand to reveal the full contents of the file.
',
    'fof-upload.admin.upload_methods.aws-s3' => 'S3 or Compatible',
    'fof-upload.admin.upload_methods.awss3' => 'AWS S3',
    'fof-upload.admin.upload_methods.imgur' => 'Imgur',
    'fof-upload.admin.upload_methods.local' => 'Local',
    'fof-upload.admin.upload_methods.ovh-svfs' => 'OVH SVFS',
    'fof-upload.admin.upload_methods.qiniu' => 'QiNiu',
    'fof-upload.admin.inspect-mime.title' => 'Inspect MIME',
    'fof-upload.admin.inspect-mime.description' => 'FoF Upload uses the <a>PHP Mime Detector</a> library for common MIME types and PHP Fileinfo as a fallback.
The MIME value returned by Fileinfo can be different from server to server!
',
    'fof-upload.admin.inspect-mime.select' => 'Select a file below to inspect the values that will be used. The file will not be saved.',
    'fof-upload.admin.inspect-mime.laravel-validation' => 'Laravel File Validation',
    'fof-upload.admin.inspect-mime.no-file-selected' => 'No file',
    'fof-upload.admin.inspect-mime.validation-passed' => 'Passed',
    'fof-upload.admin.inspect-mime.validation-failed' => 'Failed: {error}',
    'fof-upload.admin.inspect-mime.mime-detector' => 'Mime Detector (primary)',
    'fof-upload.admin.inspect-mime.mime-fileinfo' => 'PHP Fileinfo (fallback)',
    'fof-upload.admin.inspect-mime.guessed-extension' => 'Default file extension (if original is not whitelisted)',
    'fof-upload.admin.inspect-mime.not-available' => 'No result',
    'fof-upload.forum.media_manager' => 'Media manager',
    'fof-upload.forum.buttons.attach' => 'Attach',
    'fof-upload.forum.buttons.upload' => 'Upload',
    'fof-upload.forum.buttons.upload_shared' => 'Shared',
    'fof-upload.forum.buttons.user_uploads' => 'User uploads',
    'fof-upload.forum.buttons.cancel' => 'Cancel',
    'fof-upload.forum.buttons.media' => 'My media',
    'fof-upload.forum.buttons.shared_media' => 'Shared media',
    'fof-upload.forum.states.error' => 'Error',
    'fof-upload.forum.states.loading' => 'Uploading',
    'fof-upload.forum.states.unauthorized' => 'You are not allowed to download files',
    'fof-upload.forum.validation.max_size' => 'Uploads over {max} kb are not accepted.',
    'fof-upload.forum.text_preview.expand' => 'Expand preview',
    'fof-upload.forum.text_preview.collapse' => 'Collapse preview',
    'fof-upload.forum.text_preview.error' => 'Error previewing file. It may have been deleted, or the provided file ID is invalid.
',
    'fof-upload.forum.text_preview.no_snippet_preview' => '<preview will appear here after posting>',
    'fof-upload.forum.text_preview.no_snippet' => '<no preview snippet available>',
    'fof-upload.api.upload_errors.forbidden_type' => 'Uploading files of this type is not allowed.',
    'fof-upload.api.upload_errors.unsupported_type' => 'Upload adapter does not support the provided mime type: {mime}.',
    'fof-upload.api.upload_errors.could_not_detect_mime' => 'Could not detect the MIME type of this file, please try again.',
    'fof-upload.api.upload_errors.max_upload_file_size_ini' => 'Upload max filesize limit reached from php.ini.',
    'fof-upload.api.upload_errors.max_upload_file_size_form' => 'Upload max filesize limit reached from form.',
    'fof-upload.api.upload_errors.partial_upload' => 'Partial upload.',
    'fof-upload.api.upload_errors.no_file_uploaded' => 'No file uploaded.',
    'fof-upload.api.upload_errors.no_upload_tmp_folder' => 'No tmp folder for uploading files.',
    'fof-upload.api.upload_errors.cannot_write_to_disk' => 'Cannot write to disk.',
    'fof-upload.api.upload_errors.upload_blocked_by_php_extension' => 'A php extension blocked the upload.',
    'fof-upload.api.upload_errors.no_files_made_it_to_upload' => 'Please upload files no larger than {max} kb.',
    'fof-upload.lib.upload-shared-file-modal.title' => 'New shared file',
    'fof-upload.lib.upload-shared-file-modal.dropzone' => 'Drag and drop files here or click to browse',
    'fof-upload.lib.upload-shared-file-modal.hide-from-media-gallery' => 'Hide from user\'s media gallery',
    'fof-upload.lib.upload-shared-file-modal.upload' => 'Upload',
    'fof-upload.lib.file_list.loading' => 'Loading files...',
    'fof-upload.lib.file_list.empty' => 'There are no files to show.',
    'fof-upload.lib.file_list.release_to_upload' => 'Release to upload',
    'fof-upload.lib.file_list.modal_empty_desktop' => 'Your file list is empty. Click the button or drag a file here to upload.',
    'fof-upload.lib.file_list.modal_empty_phone' => 'Your file list is empty. Tap the button above to upload a file.',
    'fof-upload.lib.file_list.select_file_a11y_label' => 'Select file "{fileName}"',
    'fof-upload.lib.file_list.confirm_selection_btn' => '{fileCount, plural, =0 {None selected} one {Select file} other {Select files}}',
    'fof-upload.lib.file_list.load_more_files_btn' => 'Load more files',
    'fof-upload.lib.file_list.delete_file_a11y_label' => 'Delete file "{fileName}"',
    'fof-upload.lib.file_list.delete_confirmation' => 'Are you sure you want to delete "{fileName}"?',
    'fof-upload.lib.file_list.hide_file.btn_a11y_label_hide' => 'Hide "{fileName}" from media manager',
    'fof-upload.lib.file_list.hide_file.btn_a11y_label_show' => 'Show "{fileName}" in media manager',
    'fof-upload.lib.file_list.hide_file.hide_confirmation' => 'Are you sure you want to hide "{fileName}"? Hiding a file will only remove it from your media manager and will not affect existing posts.',
    'fof-upload.lib.file_list.hide_file.hide_success' => 'File hidden',
    'fof-upload.lib.file_list.hide_file.show_confirmation' => 'Are you sure you want to show "{fileName}"? Showing a file will make it visible in your media manager.',
    'fof-upload.lib.file_list.hide_file.show_success' => 'File shown',
    'fof-upload.lib.file_list.hide_file.hide_fail' => 'Couldn\'t hide file "{fileName}"',
    'fof-upload.lib.file_list.hide_file.show_fail' => 'Couldn\'t show file "{fileName}"',
    'fof-upload.lib.file_list.hide_file.loading' => 'Hiding file...',
    'fof-upload.lib.file_list.hide_shared_file.btn_a11y_label_hide' => 'Make "{fileName}" private (no public URL)',
    'fof-upload.lib.file_list.hide_shared_file.btn_a11y_label_show' => 'Make "{fileName}" public (with public URL)',
    'fof-upload.lib.file_list.hide_shared_file.hide_confirmation' => 'Are you sure you want to make "{fileName}" private? Making a file private will remove its public URL, but it will not affect existing posts. It will also no longer be visible in the media manager to unauthorized users.',
    'fof-upload.lib.file_list.hide_shared_file.hide_success' => 'File made private',
    'fof-upload.lib.file_list.hide_shared_file.show_confirmation' => 'Are you sure you want to make "{fileName}" public? Making a file public will make it accessible to anyone with a public URL and anyone can share it using the media manager.',
    'fof-upload.lib.file_list.hide_shared_file.show_success' => 'File made public',
    'fof-upload.lib.file_list.hide_shared_file.hide_fail' => 'Couldn\'t make file "{fileName}" private',
    'fof-upload.lib.file_list.hide_shared_file.show_fail' => 'Couldn\'t make file "{fileName}" public',
    'fof-upload.lib.file_list.hide_shared_file.loading' => 'Making file private...',
    'fof-polls.admin.settings.general.heading' => 'General Settings',
    'fof-polls.admin.settings.general.help' => 'These settings control the basic features of the Polls extension.',
    'fof-polls.admin.settings.global_polls.heading' => 'Global Polls',
    'fof-polls.admin.settings.global_polls.help' => 'These settings control the global polls feature.',
    'fof-polls.admin.settings.image.heading' => 'Image Settings',
    'fof-polls.admin.settings.image.help' => 'These settings control the image settings for polls.',
    'fof-polls.admin.settings.allow_option_image' => 'Allow an image URL to be provided for each poll option',
    'fof-polls.admin.settings.allow_image_uploads' => 'Allow image uploads for polls and their options',
    'fof-polls.admin.settings.allow_image_uploads_help' => 'If enabled, users will be able to upload images alongside also providing an image URL (if enabled for options, always enabled for the poll itself).',
    'fof-polls.admin.settings.enable_global_polls' => 'Enable global polls',
    'fof-polls.admin.settings.enable_global_polls_help' => 'Global polls are not tied to a specific post, and may be accessed from a dedicated polls page.',
    'fof-polls.admin.settings.max_options' => 'Maximum number of options per poll',
    'fof-polls.admin.settings.options_color_blend' => 'Color blend text in poll options',
    'fof-polls.admin.settings.options_color_blend_help' => 'Use this to use color mixing to make the poll options more readable. Disable if this feature causes issues with your forum\'s appearance, reducing readability.',
    'fof-polls.admin.settings.image_height' => 'Resize image height',
    'fof-polls.admin.settings.image_width' => 'Resize image width',
    'fof-polls.admin.permissions.view_results_without_voting' => 'View results without voting',
    'fof-polls.admin.permissions.start' => 'Start a poll',
    'fof-polls.admin.permissions.start_global' => 'Start a global poll',
    'fof-polls.admin.permissions.self_edit' => 'Edit created polls (requires post edit permission)',
    'fof-polls.admin.permissions.self_post_edit' => 'Edit *all* polls on own posts (requires post edit permission)',
    'fof-polls.admin.permissions.upload_images' => 'Allow users to upload images for polls',
    'fof-polls.admin.permissions.vote' => 'Vote on polls',
    'fof-polls.admin.permissions.change_vote' => 'Change vote',
    'fof-polls.admin.permissions.moderate' => 'Edit & remove polls',
    'fof-polls.forum.days_remaining' => 'Poll ends {time}.',
    'fof-polls.forum.no_permission' => 'You don\'t have permission to vote',
    'fof-polls.forum.poll_ended' => 'This poll has ended.',
    'fof-polls.forum.public_poll' => 'View voters',
    'fof-polls.forum.max_votes_allowed' => 'Poll allows voting for {max, plural, one {# option} other {# options}}.',
    'fof-polls.forum.polls_count' => '{count, plural, one { {count} vote} other {{count} votes}}',
    'fof-polls.forum.poll_never_ends' => 'Poll never ends',
    'fof-polls.forum.answers' => 'Answers',
    'fof-polls.forum.poll.cannot_change_vote' => 'You cannot change your vote after voting.',
    'fof-polls.forum.poll.submit_button' => 'Vote',
    'fof-polls.forum.poll.start_poll_button' => 'Start Global Poll',
    'fof-polls.forum.poll.cannot_start_poll_button' => 'Cannot Start Poll',
    'fof-polls.forum.poll.total_votes' => '{count, plural, one {# vote was given} other {# votes were given}}',
    'fof-polls.forum.poll_controls.edit_label' => '=> core.ref.edit',
    'fof-polls.forum.poll_controls.delete_label' => '=> core.ref.delete',
    'fof-polls.forum.poll_controls.view_label' => '=> core.ref.view',
    'fof-polls.forum.poll_controls.delete_confirmation' => 'Are you sure you want to delete this poll?',
    'fof-polls.forum.poll_controls.delete_success_message' => 'Poll deleted successfully.',
    'fof-polls.forum.poll_controls.delete_error_message' => 'There went something wrong while deleting the poll.',
    'fof-polls.forum.poll_form.delete' => 'Delete Poll',
    'fof-polls.forum.poll_form.error' => 'There was an error saving the poll, please contact any administrator.',
    'fof-polls.forum.polls_page.title' => 'Polls',
    'fof-polls.forum.polls_list.empty_text' => 'It looks as though there are no community wide polls here.',
    'fof-polls.forum.polls_list.load_more_button' => '=> core.ref.load_more',
    'fof-polls.forum.composer_discussion.add_poll' => '=> fof-polls.forum.moderation.add',
    'fof-polls.forum.composer_discussion.edit_poll' => '=> fof-polls.forum.moderation.edit',
    'fof-polls.forum.composer_discussion.no_permission_alert' => 'You do not have permission to start a poll.',
    'fof-polls.forum.compose.add_title' => 'Add a Poll',
    'fof-polls.forum.compose.edit_title' => 'Edit Poll',
    'fof-polls.forum.compose.polls_manager' => 'Polls Manager',
    'fof-polls.forum.compose.polls_preview' => 'View Poll',
    'fof-polls.forum.compose.continue_editing' => 'Continue Editing',
    'fof-polls.forum.compose.success' => 'Poll saved successfully.',
    'fof-polls.forum.modal.add_title' => 'Add a Poll',
    'fof-polls.forum.modal.add_option_label' => 'Add an Option',
    'fof-polls.forum.modal.date_placeholder' => 'Poll end date (Optional)',
    'fof-polls.forum.modal.edit_title' => 'Edit Poll',
    'fof-polls.forum.modal.include_question' => 'You must include a question',
    'fof-polls.forum.modal.max' => 'You can have a maximum of {max} answers',
    'fof-polls.forum.modal.min' => 'You must include a minimum of 2 answers',
    'fof-polls.forum.modal.no_voters' => 'No Votes',
    'fof-polls.forum.modal.option_placeholder' => 'Answer',
    'fof-polls.forum.modal.image_option_placeholder' => 'Image URL (optional)',
    'fof-polls.forum.modal.options_label' => 'Answers',
    'fof-polls.forum.modal.public_poll_label' => 'Allow people to see who voted',
    'fof-polls.forum.modal.allow_multiple_votes_label' => 'Allow people to vote for multiple options',
    'fof-polls.forum.modal.max_votes_label' => 'Max votes per user',
    'fof-polls.forum.modal.max_votes_help' => 'Set to 0 to allow users to vote for all options.',
    'fof-polls.forum.modal.hide_votes_label' => 'Hide votes until poll ends',
    'fof-polls.forum.modal.hide_votes_label_help' => 'The user who started the poll will always be able to see the votes.',
    'fof-polls.forum.modal.allow_change_vote_label' => 'Allow users to change their vote',
    'fof-polls.forum.modal.question_placeholder' => 'Question',
    'fof-polls.forum.modal.subtitle_placeholder' => 'Subtitle/Description (optional)',
    'fof-polls.forum.modal.submit' => 'Submit',
    'fof-polls.forum.modal.delete' => '=> core.ref.delete',
    'fof-polls.forum.modal.error' => '=> core.lib.error.generic_message',
    'fof-polls.forum.modal.poll_image.label' => 'Poll Image',
    'fof-polls.forum.modal.poll_image.help' => 'Upload an image to be displayed alongside the poll (optional).',
    'fof-polls.forum.modal.poll_image.alt_label' => 'Image Alt Text',
    'fof-polls.forum.modal.poll_image.alt_help_text' => 'This text is required when an image is set, it will be displayed if the image fails to load.',
    'fof-polls.forum.modal.poll_image.later_help' => 'You will be able to upload an image after creating the poll.',
    'fof-polls.forum.modal.poll_option_image.label' => 'Poll Answer Image',
    'fof-polls.forum.modal.poll_option_image.help' => 'Upload an image to be displayed alongside the poll answer (optional).',
    'fof-polls.forum.modal.tooltip.options.add-button' => 'Add Answer',
    'fof-polls.forum.moderation.add' => 'Add Poll',
    'fof-polls.forum.moderation.delete' => 'Remove Poll',
    'fof-polls.forum.moderation.delete_confirm' => 'Are you sure you want to delete this poll?',
    'fof-polls.forum.moderation.edit' => 'Edit Poll',
    'fof-polls.forum.page.nav' => 'Polls',
    'fof-polls.forum.page.nav-all' => 'All Global Polls',
    'fof-polls.forum.showcase.active-polls' => 'Active Polls',
    'fof-polls.forum.showcase.ended-polls' => 'Concluded Polls',
    'fof-polls.forum.showcase.no-active-polls' => 'There are no active polls at the moment.',
    'fof-polls.forum.showcase.no-recent-polls' => 'There are no recently ended polls at the moment.',
    'fof-polls.forum.tooltip.badge' => 'Poll',
    'fof-polls.forum.tooltip.votes' => '{count, plural, one {# vote} other {# votes}}',
    'fof-polls.forum.votes_modal.title' => 'Voters',
    'fof-polls.forum.upload_image.remove_button' => 'Delete Image',
    'fof-polls.forum.upload_image.upload_button' => 'Upload Image',
    'fof-oauth.admin.configure_button_label' => 'Configure with FoF OAuth',
    'fof-oauth.admin.settings_accessibility_label' => '{name} settings',
    'fof-oauth.admin.permissions.moderate_user_providers' => 'Moderate user\'s linked accounts',
    'fof-oauth.admin.settings.advanced.heading' => 'Advanced',
    'fof-oauth.admin.settings.advanced.log-oauth-errors-label' => 'Log OAuth errors',
    'fof-oauth.admin.settings.advanced.log-oauth-errors-help' => 'If enabled, OAuth errors will be logged to the Flarum log. This may help with debugging OAuth issues, but may also contain sensitive information.',
    'fof-oauth.admin.settings.only_icons_label' => 'Only show the Log In Button icons (alternative layout)',
    'fof-oauth.admin.settings.update_email_from_provider_label' => 'Update email address from provider',
    'fof-oauth.admin.settings.update_email_from_provider_help' => 'If enabled, the user\'s email address will be updated to match the one provided by the OAuth provider on each login to the forum. Not all providers provide the updated email, in which case this setting will not have any effect with those providers.',
    'fof-oauth.admin.settings.fullscreen_popup_label' => 'Use Fullscreen Popup for OAuth',
    'fof-oauth.admin.settings.fullscreen_popup_help' => 'When enabled, the OAuth login will open in a fullscreen popup. If this is enabled, the width and height settings will be ignored.',
    'fof-oauth.admin.settings.popup_width_label' => 'OAuth Popup Width',
    'fof-oauth.admin.settings.popup_width_help' => 'Set the width of the OAuth popup window. This setting will be ignored if "Use Fullscreen Popup for OAuth" is enabled.',
    'fof-oauth.admin.settings.popup_height_label' => 'OAuth Popup Height',
    'fof-oauth.admin.settings.popup_height_help' => 'Set the height of the OAuth popup window. This setting will be ignored if "Use Fullscreen Popup for OAuth" is enabled.',
    'fof-oauth.admin.settings.providers.callback_url_text' => 'If necessary, set the callback URL to {url}.',
    'fof-oauth.admin.settings.providers.group_label' => 'Assign Group',
    'fof-oauth.admin.settings.providers.group_help' => 'Select a group to automatically assign to users who register using this provider.',
    'fof-oauth.admin.settings.providers.no_group_label' => 'No group assignment',
    'fof-oauth.admin.settings.providers.discord.description' => 'Create an app at {link}. Add the redirect URL in the OAuth2 tab.',
    'fof-oauth.admin.settings.providers.discord.client_id_label' => '=> fof-oauth.ref.settings.client_id',
    'fof-oauth.admin.settings.providers.discord.client_secret_label' => '=> fof-oauth.ref.settings.client_secret',
    'fof-oauth.admin.settings.providers.facebook.description' => 'Create an app at {link}.',
    'fof-oauth.admin.settings.providers.facebook.app_id_label' => '=> fof-oauth.ref.settings.app_id',
    'fof-oauth.admin.settings.providers.facebook.app_secret_label' => '=> fof-oauth.ref.settings.app_secret',
    'fof-oauth.admin.settings.providers.github.description' => 'Create an OAuth app at {link}.',
    'fof-oauth.admin.settings.providers.github.client_id_label' => '=> fof-oauth.ref.settings.client_id',
    'fof-oauth.admin.settings.providers.github.client_secret_label' => '=> fof-oauth.ref.settings.client_secret',
    'fof-oauth.admin.settings.providers.gitlab.description' => 'Create an application at {link}. Give the application the <code>read_user</code> scope.',
    'fof-oauth.admin.settings.providers.gitlab.client_id_label' => '=> fof-oauth.ref.settings.app_id',
    'fof-oauth.admin.settings.providers.gitlab.client_secret_label' => '=> fof-oauth.ref.settings.app_secret',
    'fof-oauth.admin.settings.providers.gitlab.domain_label' => 'GitLab Domain',
    'fof-oauth.admin.settings.providers.twitter.description' => 'Create an app at {link}. You will need to set a Terms of Service URL and a Privacy Policy URL. Make sure to then add the request email permission.',
    'fof-oauth.admin.settings.providers.twitter.api_key_label' => 'API Key',
    'fof-oauth.admin.settings.providers.twitter.api_secret_label' => 'API Secret',
    'fof-oauth.admin.settings.providers.google.description' => 'Create an application at {link}.',
    'fof-oauth.admin.settings.providers.google.client_id_label' => '=> fof-oauth.ref.settings.client_id',
    'fof-oauth.admin.settings.providers.google.client_secret_label' => '=> fof-oauth.ref.settings.client_secret',
    'fof-oauth.admin.settings.providers.google.hosted_domain_label' => 'Hosted Domain (G suite/Google Apps for Business, optional)',
    'fof-oauth.admin.settings.providers.linkedin.description' => 'Create an application at {link}.',
    'fof-oauth.admin.settings.providers.linkedin.client_id_label' => '=> fof-oauth.ref.settings.client_id',
    'fof-oauth.admin.settings.providers.linkedin.client_secret_label' => '=> fof-oauth.ref.settings.client_secret',
    'fof-oauth.forum.log_in.with_button' => 'Log In with {provider}',
    'fof-oauth.forum.log_in.with_discord_button' => '=> fof-oauth.forum.log_in.with_button',
    'fof-oauth.forum.log_in.with_facebook_button' => '=> fof-oauth.forum.log_in.with_button',
    'fof-oauth.forum.log_in.with_github_button' => '=> fof-oauth.forum.log_in.with_button',
    'fof-oauth.forum.log_in.with_gitlab_button' => '=> fof-oauth.forum.log_in.with_button',
    'fof-oauth.forum.log_in.with_google_button' => '=> fof-oauth.forum.log_in.with_button',
    'fof-oauth.forum.log_in.with_linkedin_button' => '=> fof-oauth.forum.log_in.with_button',
    'fof-oauth.forum.log_in.with_twitter_button' => '=> fof-oauth.forum.log_in.with_button',
    'fof-oauth.forum.user.settings.linked-account.label' => 'Linked accounts',
    'fof-oauth.forum.user.settings.linked-account.last-used-label' => 'Last used',
    'fof-oauth.forum.user.settings.linked-account.link-created-label' => 'Link created',
    'fof-oauth.forum.user.settings.linked-account.identification-label' => '{provider} ID',
    'fof-oauth.forum.user.settings.linked-account.orphaned-account' => 'You have signed in through this provider previously, but this forum has disabled sign-in with this method since.',
    'fof-oauth.forum.user.settings.linked-account.help' => 'These linked accounts allow you to sign into the forum using other providers.',
    'fof-oauth.forum.user.settings.linked-account.identifier-label' => '{provider} ID',
    'fof-oauth.forum.user.settings.linked-account.unlink-confirm' => 'Are you sure you want to remove the link with {provider}? You will no longer be able to sign in to this forum unless you re-authenticate in the future.',
    'fof-oauth.forum.providers.discord' => '=> fof-oauth.lib.providers.discord',
    'fof-oauth.forum.providers.facebook' => '=> fof-oauth.lib.providers.facebook',
    'fof-oauth.forum.providers.github' => '=> fof-oauth.lib.providers.github',
    'fof-oauth.forum.providers.gitlab' => '=> fof-oauth.lib.providers.gitlab',
    'fof-oauth.forum.providers.google' => '=> fof-oauth.lib.providers.google',
    'fof-oauth.forum.providers.linkedin' => '=> fof-oauth.lib.providers.linkedin',
    'fof-oauth.forum.providers.twitter' => '=> fof-oauth.lib.providers.twitter',
    'fof-oauth.forum.signup.username_help' => 'Please choose a username to be known by here',
    'fof-oauth.forum.unlink' => 'Remove link',
    'fof-oauth.forum.error.bad_verification_code' => 'Invalid or expired verification token. Please try again.',
    'fof-oauth.forum.error.invalid_state' => 'Invalid state. Please try again.',
    'fof-oauth.lib.providers.discord' => 'Discord',
    'fof-oauth.lib.providers.facebook' => 'Facebook',
    'fof-oauth.lib.providers.github' => 'GitHub',
    'fof-oauth.lib.providers.gitlab' => 'GitLab',
    'fof-oauth.lib.providers.twitter' => 'Twitter',
    'fof-oauth.lib.providers.google' => 'Google',
    'fof-oauth.lib.providers.linkedin' => 'LinkedIn',
    'fof-oauth.ref.settings.app_id' => 'App ID',
    'fof-oauth.ref.settings.app_secret' => 'App Secret',
    'fof-oauth.ref.settings.client_id' => 'Client ID',
    'fof-oauth.ref.settings.client_secret' => 'Client Secret',
    'fof-nightmode.ref.auto' => 'Automatic (based on browser or device options)',
    'fof-nightmode.ref.light' => 'Day Mode',
    'fof-nightmode.ref.dark' => 'Night Mode',
    'fof-nightmode.admin.settings.general.heading' => 'General Settings',
    'fof-nightmode.admin.settings.general.help' => 'These settings control the basic behaviour of the extension.',
    'fof-nightmode.admin.settings.modal.always_show_theme_toggle_on_header' => 'Always show the theme switch button on the forum header',
    'fof-nightmode.admin.settings.modal.show_theme_toggle_in_solid' => 'Show theme icon in solid icon',
    'fof-nightmode.admin.settings.modal.default_theme' => 'Default forum theme',
    'fof-nightmode.admin.settings.modal.default_theme_helper' => 'The default theme is automatically set for new users, guests and those who have no preference set.',
    'fof-nightmode.admin.settings.modal.theme_auto' => '=> fof-nightmode.ref.auto',
    'fof-nightmode.admin.settings.modal.theme_light' => '=> fof-nightmode.ref.light',
    'fof-nightmode.admin.settings.modal.theme_dark' => '=> fof-nightmode.ref.dark',
    'fof-nightmode.forum.day' => '=> fof-nightmode.ref.light',
    'fof-nightmode.forum.night' => '=> fof-nightmode.ref.dark',
    'fof-nightmode.forum.header.nightmode_button' => 'Toggle forum theme',
    'fof-nightmode.forum.user.settings.heading' => 'Theme',
    'fof-nightmode.forum.user.settings.description' => 'Choose which colour theme you want to use on the forum.',
    'fof-nightmode.forum.user.settings.description2' => 'This theme will be linked to your account and applies to all your devices unless you toggle on the switch below for per device settings.',
    'fof-nightmode.forum.user.settings.device_specific_setting_checkbox' => 'Use per device settings',
    'fof-nightmode.forum.user.settings.device_specific_setting_checkbox_tooltip' => 'Your theme choice will be saved individually for each of your devices.',
    'fof-nightmode.forum.user.settings.auto_unsupported' => 'Your browser does not support auto dark mode.',
    'fof-nightmode.forum.user.settings.options.auto' => '=> fof-nightmode.ref.auto',
    'fof-nightmode.forum.user.settings.options.day' => '=> fof-nightmode.ref.light',
    'fof-nightmode.forum.user.settings.options.night' => '=> fof-nightmode.ref.dark',
    'fof-nightmode.forum.user.settings.option_descriptions.auto' => 'Your theme will be automatically selected based on your browser or device settings. For example, if you have dark mode enabled in iOS, the forums will be dark too.',
    'fof-nightmode.forum.user.settings.option_descriptions.day' => 'The classic experience which you\'re used to. Loved and tested.',
    'fof-nightmode.forum.user.settings.option_descriptions.night' => 'You\'re a bit of a night owl. You watch over the forum at night, while the birds are sleeping and the foxes are hunting. Or you just prefer the darker colours!',
    'fof-default-user-preferences.admin.settings.fofNightMode' => 'FoF Nightmode: Color theme to use by default',
    'fof-default-user-preferences.admin.settings.fofNightMode-help' => '0 - automatic, 1 - light mode, 2 - dark mode',
    'fof-default-user-preferences.admin.settings.fofNightMode_perDevice' => 'FoF Nightmode: Use per device settings',
    'fof-default-user-preferences.admin.settings.fofNightMode_perDevice-help' => 'Use per device preferences for nightmode settings',
    'fof-moderator-notes.admin.permissions.createnotes' => 'Create moderator notes',
    'fof-moderator-notes.admin.permissions.viewnotes' => 'View moderator notes',
    'fof-moderator-notes.admin.permissions.deletenotes' => 'Delete moderator notes',
    'fof-moderator-notes.forum.no_content_given' => 'An empty note is not permitted.',
    'fof-moderator-notes.forum.moderatorNotes.created_text' => '{username} created this note on {date}',
    'fof-moderator-notes.forum.moderatorNotes.add_button' => 'New note',
    'fof-moderator-notes.forum.moderatorNotes.create-heading' => 'Create a new moderator note',
    'fof-moderator-notes.forum.moderatorNotes.dismiss_button' => 'Done',
    'fof-moderator-notes.forum.moderatorNotes.input_heading' => 'Enter your notes for <strong>{username}</strong>, (markdown is supported)',
    'fof-moderator-notes.forum.moderatorNotes.noNotes' => 'It looks like there are no notes here.',
    'fof-moderator-notes.forum.moderatorNotes.submit_button' => 'Save note',
    'fof-moderator-notes.forum.moderatorNotes.delete' => 'Delete',
    'fof-moderator-notes.forum.moderatorNotes.confirm' => 'Are you sure you want to delete this note?',
    'fof-moderator-notes.forum.moderatorNotes.filter_by_me' => 'Only notes I created',
    'fof-moderator-notes.forum.user.notes' => 'Moderator Notes',
    'fof-moderator-notes.api.auto_note' => '_I switched to this user:_ {reason}',
    'fof-moderator-notes.api.auto_note_actor' => '_Switched to_ @{username}: {reason}',
    'fof-moderator-notes.api.no_reason_provided' => 'No reason provided',
    'fof-links.admin.edit_link.delete_link_button' => 'Delete Link',
    'fof-links.admin.edit_link.delete_link_confirmation' => 'Are you sure you want to delete this link?',
    'fof-links.admin.edit_link.internal_link' => 'Is it an internal link?',
    'fof-links.admin.edit_link.open_newtab' => 'Open link in new tab',
    'fof-links.admin.edit_link.submit_button' => '=> core.ref.save_changes',
    'fof-links.admin.edit_link.title' => '=> fof-links.ref.create_link',
    'fof-links.admin.edit_link.title_label' => '=> fof-links.ref.title',
    'fof-links.admin.edit_link.title_placeholder' => '=> fof-links.ref.title',
    'fof-links.admin.edit_link.icon_label' => '=> core.ref.icon',
    'fof-links.admin.edit_link.icon_text' => '=> core.ref.icon_text',
    'fof-links.admin.edit_link.icon_additional_text' => 'If you want to use a brand icon, the prefix is <code>fab fa-</code> instead.',
    'fof-links.admin.edit_link.url_description' => 'Leave blank to show as a label.',
    'fof-links.admin.edit_link.url_label' => '=> fof-links.ref.url',
    'fof-links.admin.edit_link.url_placeholder' => '=> fof-links.ref.url',
    'fof-links.admin.edit_link.use_rel_me' => 'Add <code>rel="me"</code> attribute for identity verification on other sites',
    'fof-links.admin.edit_link.visibility.help' => 'Links by default are visible to only <code>{admin}</code> users. Adjust the permissions to specify who can see this link.',
    'fof-links.admin.edit_link.visibility.help-disabled' => 'Save the link before changing visibility settings.',
    'fof-links.admin.edit_link.visibility.label' => 'Link visibility',
    'fof-links.admin.edit_link.visibility.guest-only.label' => '{guest} only?',
    'fof-links.admin.edit_link.visibility.guest-only.help' => 'Only {guest} can see this link. The permission above should be set to \'{everyone}\'.',
    'fof-links.admin.links.create_button' => '=> fof-links.ref.create_link',
    'fof-links.admin.links.links' => '=> fof-links.ref.links',
    'fof-links.admin.settings.show_icons_only_on_tablet' => 'Show icons only on tablet screens',
    'fof-links.ref.create_link' => 'Create Link',
    'fof-links.ref.links' => 'Links',
    'fof-links.ref.title' => 'Title',
    'fof-links.ref.url' => 'URL',
    'core.forum.index_sort.hot_button' => 'Trending',
    'core.forum.index_sort.votes_button' => 'Upvotes',
    'fof-gamification.forum.votes' => 'Votes',
    'fof-gamification.forum.vote_title' => 'Show Who Voted',
    'fof-gamification.forum.nav.name' => 'Rankings',
    'fof-gamification.forum.ranking.rank' => 'Place',
    'fof-gamification.forum.ranking.name' => 'User',
    'fof-gamification.forum.ranking.amount' => 'Points',
    'fof-gamification.forum.notification.upvote' => '{username} upvoted your post',
    'fof-gamification.forum.notification.downvote' => '{username} downvoted your post',
    'fof-gamification.forum.notification.prefrences.vote' => 'When one of my posts is up/down voted',
    'fof-gamification.forum.user.card.points' => '{count, plural, one { {count} point} other {{count} points}}',
    'fof-gamification.forum.user.rank' => '{rank}',
    'fof-gamification.forum.user.votes_link' => 'Votes',
    'fof-gamification.forum.modal.downvotes_label' => 'Downvoters:',
    'fof-gamification.forum.modal.title' => 'Voters',
    'fof-gamification.forum.modal.upvotes_label' => 'Upvoters:',
    'fof-gamification.forum.mod_item' => 'View Voters',
    'fof-gamification.forum.voters.none' => 'No voters yet',
    'fof-gamification.forum.voters.label' => 'Voters',
    'fof-gamification.forum.voters.label_none' => 'No voters',
    'fof-gamification.forum.post.upvote_button' => 'Upvote post',
    'fof-gamification.forum.post.downvote_button' => 'Downvote post',
    'fof-gamification.admin.permissions.vote_label' => 'Upvote/Downvote posts',
    'fof-gamification.admin.permissions.see_votes_label' => 'See up/down vote count',
    'fof-gamification.admin.permissions.see_voters_label' => 'See who voted',
    'fof-gamification.admin.permissions.see_ranking_page' => 'See ranking page',
    'fof-gamification.admin.permissions.upvote_notifications' => 'Receive notifications on upvote',
    'fof-gamification.admin.permissions.downvote_notifications' => 'Receive notifications on downvote',
    'fof-gamification.admin.page.rankings.blocked.placeholder' => 'admin, user1, user2',
    'fof-gamification.admin.page.rankings.blocked.title' => 'Ignored Users',
    'fof-gamification.admin.page.rankings.blocked.help' => 'These users will not be shown on the ranking page. Usernames should be separated by a comma followed by a space.',
    'fof-gamification.admin.page.rankings.title' => 'Rankings Page',
    'fof-gamification.admin.page.rankings.enable' => 'Enable custom images',
    'fof-gamification.admin.page.rankings.custom_image_1' => '1st place image',
    'fof-gamification.admin.page.rankings.custom_image_2' => '2nd place image',
    'fof-gamification.admin.page.rankings.custom_image_3' => '3rd place image',
    'fof-gamification.admin.page.alt_votes.icon_name' => 'Alt layout icon name',
    'fof-gamification.admin.page.votes.points_title' => 'Points Placeholder',
    'fof-gamification.admin.page.votes.points_placeholder' => 'Points: ',
    'fof-gamification.admin.page.votes.color_holder' => '#ffffff',
    'fof-gamification.admin.page.votes.auto_upvote' => 'Auto upvote posts when posted',
    'fof-gamification.admin.page.votes.rate_limit' => 'Enforce a vote rate limit (10 seconds)',
    'fof-gamification.admin.page.votes.discussion_page' => 'Show total votes of original post on discussions list',
    'fof-gamification.admin.page.votes.alternate_layout' => 'Use alternate voting layout on discussions list',
    'fof-gamification.admin.page.votes.alternate_post_layout' => 'Use alternate voting layout on posts',
    'fof-gamification.admin.page.votes.title' => 'Votes',
    'fof-gamification.admin.page.votes.vote_color' => 'Voted color',
    'fof-gamification.admin.page.votes.icon_name' => 'Upvote/downvote icon',
    'fof-gamification.admin.page.votes.icon_help' => 'Input any Font-Awesome icon that is suffixed with -up and -down. Examples: arrow, thumbs, chevron',
    'fof-gamification.admin.page.votes.upvotes_only' => 'Only allow upvoting',
    'fof-gamification.admin.page.votes.first_post_only' => 'Only allow up/down votes in the first post in a discussion',
    'fof-gamification.admin.page.votes.allow_self_votes' => 'Users may vote on their own posts',
    'fof-gamification.admin.page.save_settings' => 'Save settings',
    'fof-gamification.admin.page.convert.button' => 'Convert likes to upvotes',
    'fof-gamification.admin.page.convert.help' => 'Convert your previous likes from flarum-ext-likes into upvotes, as well as calculate the hotness for all current discussions.',
    'fof-gamification.admin.page.convert.converting' => 'Your likes are now being converted. Refresh your site after a few minutes to see the process finished. (Conversion time might take a while depending on your total forum likes)',
    'fof-gamification.admin.page.convert.converted' => 'Successfully converted all {number} likes',
    'fof-gamification.admin.page.ranks.title' => 'Ranks',
    'fof-gamification.admin.page.ranks.ranks' => 'Custom ranks',
    'fof-gamification.admin.page.ranks.number_title' => 'How many rank badges should be shown?',
    'fof-gamification.admin.page.ranks.help.color' => '#ffffff',
    'fof-gamification.admin.page.ranks.help.help' => 'Input the required number of upvotes, the name of the rank, and the hex color of the rank',
    'fof-gamification.admin.page.ranks.help.points' => 'Points',
    'fof-gamification.admin.page.ranks.help.name' => 'Name',
    'fof-gamification.admin.page.groups.title' => 'Automatically assigned groups',
    'fof-gamification.admin.page.groups.help' => 'The selected groups will be automatically added or removed as needed when the number of points of a user changes. If you made changes to the configuration, you should run the <code>php flarum fof:gamification:assign-groups</code> command to update existing users. If you wish to delete a rule and remove all users from the group, set both minimum and maximum values to an empty string, save the settings and run the command line command. Finally you can delete the rule entirely from the settings.
',
    'fof-gamification.admin.page.groups.column.group' => 'Group',
    'fof-gamification.admin.page.groups.column.minPoints' => 'Minimum points (inclusive)',
    'fof-gamification.admin.page.groups.column.maxPoints' => 'Maximum points (inclusive)',
    'fof-gamification.admin.page.groups.add' => 'Add new rule',
    'fof-gamification.admin.page.groups.delete' => 'Delete rule',
    'fof-gamification.email.body.postVoted' => 'Hey {recipient_display_name},

{actor_display_name} just voted on your post in {discussion_title}.

View it here: {discussion_url}
',
    'fof-gamification.email.subject.postVoted' => 'Your post was voted on by {display_name}',
    'fof-formatting.admin.plugins.Autoimage' => 'Convert image URLs into actual images',
    'fof-formatting.admin.plugins.Autovideo' => 'Convert video URLs into playable videos',
    'fof-formatting.admin.plugins.FancyPants' => 'Use fancy typography',
    'fof-formatting.admin.plugins.HTMLEntities' => 'Use HTML entities',
    'fof-formatting.admin.plugins.MediaEmbed' => 'Embed content from allowed sites',
    'fof-formatting.admin.plugins.PipeTables' => 'ASCII-style tables',
    'fof-formatting.admin.plugins.TaskLists' => 'GitHub/GitLab flavored task lists',
    'fof-byobu.forum.badges.is_private.tooltip' => 'Private discussion',
    'fof-byobu.forum.buttons.add_recipients' => 'Recipients',
    'fof-byobu.forum.buttons.submit' => 'OK',
    'fof-byobu.forum.buttons.edit_recipients' => 'Edit Recipients',
    'fof-byobu.forum.buttons.send_pd' => 'Send {username} a message',
    'fof-byobu.forum.buttons.cancel' => 'Cancel',
    'fof-byobu.forum.buttons.make_public' => 'Make this discussion public',
    'fof-byobu.forum.buttons.remove_from_discussion' => 'Leave this private discussion',
    'fof-byobu.forum.composer_private_discussion.submit_button' => 'Post Private Discussion',
    'fof-byobu.forum.composer_private_discussion.title_placeholder' => 'Private Discussion Title',
    'fof-byobu.forum.confirm.make_public' => 'Are you sure you want to remove the recipients and make this discussion visible to anyone who can view the assigned tag?',
    'fof-byobu.forum.hero.title' => '=> fof-byobu.forum.nav.nav_item',
    'fof-byobu.forum.labels.recipients' => '{count, plural, one {{count} Recipient} other {{count} Recipients}}',
    'fof-byobu.forum.nav.start_button' => 'Discuss Privately',
    'fof-byobu.forum.nav.nav_item' => 'Private Discussions',
    'fof-byobu.forum.input.search_recipients' => 'Search recipient by typing first three characters...',
    'fof-byobu.forum.search.headings.groups' => 'Permission Groups',
    'fof-byobu.forum.modal.titles.update_recipients' => 'Update recipients of {title}',
    'fof-byobu.forum.modal.titles.add_recipients' => 'Add recipients to your discussion',
    'fof-byobu.forum.modal.labels.selected_users' => 'Selected users',
    'fof-byobu.forum.modal.labels.search_field' => 'Search for user',
    'fof-byobu.forum.modal.help.add_recipients' => 'This discussion will only be visible to the users you choose here. At least 1 recipient (other than yourself) is required.',
    'fof-byobu.forum.modal.help.update_recipients' => 'This discussion will only be visible to the users you choose here.',
    'fof-byobu.forum.modal.help.selected_users' => 'Click a user\'s name to remove them.',
    'fof-byobu.forum.modal.help.click_user_to_remove_tooltip' => 'Click to remove',
    'fof-byobu.forum.post.recipients_modified.added_and_removed' => '{username} added recipients {added} and removed {removed}.',
    'fof-byobu.forum.post.recipients_modified.added' => '{username} added recipients {added}.',
    'fof-byobu.forum.post.recipients_modified.made_public' => '{username} removed all recipients and made the discussion public',
    'fof-byobu.forum.post.recipients_modified.removed' => '{username} removed recipients {removed}.',
    'fof-byobu.forum.post.recipients_modified.removed_self' => '{username} left the private discussion.',
    'fof-byobu.forum.user.settings.block_pd' => 'Block private discussions',
    'fof-byobu.forum.user.byobu_link' => 'Private Discussions',
    'fof-byobu.forum.user.dropdown_label' => 'Private Discussions',
    'fof-byobu.forum.notifications.pd_label' => 'Someone includes me in a new private discussion',
    'fof-byobu.forum.notifications.pd_reply_label' => 'Someone posts in a private discussion I\'m a recipient of',
    'fof-byobu.forum.notifications.pd_reply_text' => '{username} posted in a private discussion you\'re a part of',
    'fof-byobu.forum.notifications.pd_text' => '{username} started a new private discussion with you',
    'fof-byobu.forum.notifications.pd_user_left_label' => 'A recipient user leaves a private discussion I\'m a part of',
    'fof-byobu.forum.notifications.pd_user_left_text' => '{username} left the private discussion',
    'fof-byobu.forum.notifications.pd_added_text' => '{username} added you to a private discussion',
    'fof-byobu.forum.notifications.pd_added_label' => 'Someone adds me to an existing private discussion',
    'fof-byobu.admin.permission.create_private_discussions_with_users' => 'Create private discussions with users',
    'fof-byobu.admin.permission.add_more_than_two_user_recipients' => 'Add more than 2 user recipients to private discussion',
    'fof-byobu.admin.permission.create_private_discussions_with_groups' => 'Create private discussions with groups',
    'fof-byobu.admin.permission.create_private_discussions_with_blocking_users' => 'Create private discussions with users that block it',
    'fof-byobu.admin.permission.edit_user_recipients' => 'Edit users partaking in private discussions',
    'fof-byobu.admin.permission.edit_group_recipients' => 'Edit groups partaking in private discussions',
    'fof-byobu.admin.permission.make_private_into_public' => 'Transform a private discussion into a public discussion',
    'fof-byobu.admin.permission.view_private_discussions-when-flagged' => 'View private discussions of other users if flagged',
    'fof-byobu.admin.settings.general.heading' => 'General Settings',
    'fof-byobu.admin.settings.general.help' => 'These settings control the basic features of the byobu.',
    'fof-byobu.admin.settings.icon.heading' => 'Icon Settings',
    'fof-byobu.admin.settings.icon.help' => 'These settings control the icons used byobu on the forum.',
    'fof-byobu.admin.settings.badge-icon' => 'Byobu Discussion Badge',
    'fof-byobu.admin.settings.enable-make-public-option' => 'Enable the "make public" ability',
    'fof-byobu.admin.settings.enable-make-public-option-help' => 'Adds the ability for those with permission to remove all recipients, assign a new tag and make the discussion publically visible (accoring to the visibility settings of the chosen tag).',
    'fof-byobu.admin.settings.post-event-icon' => 'Byobu Post Events',
    'fof-byobu.admin.settings.delete_on_last_recipient_left' => 'Delete PDs when the last user leaves',
    'fof-byobu.admin.settings.delete_on_last_recipient_left_help' => 'If enabled, PDs will be permanently deleted from the database when the last user leaves. Otherwise, the PD will be soft-deleted/hidden.',
    'fof-byobu.admin.settings.hide_from_all_discussions_page' => 'Hide PDs from "All Discussions" page',
    'fof-byobu.admin.settings.hide_from_all_discussions_page_help' => 'Private discussions will only be accessible from the "Private Discussions" page or the user profile',
    'fof-byobu.email.subject.private_discussion_created' => '[Private Discussion] {display_name} started a new private discussion with you',
    'fof-byobu.email.subject.private_discussion_replied' => '[Private Discussion] {display_name} posted in a private discussion',
    'fof-byobu.email.subject.recipient_removed' => '[Private Discussion] {display_name} left the discussion',
    'fof-byobu.email.subject.private_discussion_added' => '[Private Discussion] {display_name} added you to a private discussion',
    'fof-byobu.email.body.private_discussion_created' => 'Hey {recipient_display_name},

{actor_display_name} started a new private discussion with you as a recipient: {discussion_title}.

View it here:
{discussion_url}

You may need to login first before being able to access this link.
',
    'fof-byobu.email.body.private_discussion_replied' => 'Hey {recipient_display_name},

{actor_display_name} posted in a private discussion with you as a recipient: {discussion_title}.

View it here:
{post_url}

You may need to login first before being able to access this link.
',
    'fof-byobu.email.body.recipient_removed' => 'Hey {recipient_display_name},

{actor_display_name} left the private discussion: {discussion_title}. They\'ll no longer be able to view any of it\'s content.

View it here:
{discussion_url}

You may need to login first before being able to access this link.
',
    'fof-byobu.email.body.private_discussion_added' => 'Hey {recipient_display_name},

{actor_display_name} added you to an existing private discussion: {discussion_title}.

View it here:
{discussion_url}

You may need to login first before being able to access this link.
',
    'flarum-subscriptions.forum.badge.following_tooltip' => '=> flarum-subscriptions.ref.following',
    'flarum-subscriptions.forum.badge.ignoring_tooltip' => '=> flarum-subscriptions.ref.ignoring',
    'flarum-subscriptions.forum.discussion_controls.follow_button' => '=> flarum-subscriptions.ref.follow',
    'flarum-subscriptions.forum.discussion_controls.unfollow_button' => 'Unfollow',
    'flarum-subscriptions.forum.discussion_controls.unignore_button' => 'Unignore',
    'flarum-subscriptions.forum.following.meta_title_text' => '=> flarum-subscriptions.ref.following',
    'flarum-subscriptions.forum.index.following_link' => '=> flarum-subscriptions.ref.following',
    'flarum-subscriptions.forum.notifications.new_post_text' => '{username} posted',
    'flarum-subscriptions.forum.settings.follow_after_reply_label' => 'Automatically follow discussions that I reply to',
    'flarum-subscriptions.forum.settings.notify_for_all_posts_label' => 'Notify about every new post instead of only the last in a discussion',
    'flarum-subscriptions.forum.settings.notify_new_post_label' => 'Someone posts in a discussion I\'m following',
    'flarum-subscriptions.forum.sub_controls.follow_button' => '=> flarum-subscriptions.ref.follow',
    'flarum-subscriptions.forum.sub_controls.following_button' => '=> flarum-subscriptions.ref.following',
    'flarum-subscriptions.forum.sub_controls.following_text' => 'Be notified of all replies.',
    'flarum-subscriptions.forum.sub_controls.ignoring_button' => '=> flarum-subscriptions.ref.ignoring',
    'flarum-subscriptions.forum.sub_controls.ignoring_text' => 'Never be notified. Hide from the discussion list.',
    'flarum-subscriptions.forum.sub_controls.not_following_button' => 'Not Following',
    'flarum-subscriptions.forum.sub_controls.not_following_text' => 'Be notified only when @mentioned.',
    'flarum-subscriptions.forum.sub_controls.notify_alert_tooltip' => 'Get a forum notification when there are new posts',
    'flarum-subscriptions.forum.sub_controls.notify_email_tooltip' => 'Get an email when there are new posts',
    'flarum-subscriptions.email.new_post.subject' => '[New Post] {title}',
    'flarum-subscriptions.email.new_post.body' => 'Hey {recipient_display_name}!

{poster_display_name} made a post in a discussion you\'re following: {title}.

To view the new activity, check out the following link:
{url}

---

{content}

---

You won\'t receive any more notifications about this discussion until you\'re up-to-date.
',
    'flarum-subscriptions.ref.follow' => 'Follow',
    'flarum-subscriptions.ref.following' => 'Following',
    'flarum-subscriptions.ref.ignoring' => 'Ignoring',
    'flarum-sticky.admin.permissions.sticky_discussions_label' => 'Sticky discussions',
    'flarum-sticky.forum.badge.sticky_tooltip' => '=> flarum-sticky.ref.sticky',
    'flarum-sticky.forum.discussion_controls.sticky_button' => '=> flarum-sticky.ref.sticky',
    'flarum-sticky.forum.discussion_controls.unsticky_button' => 'Unsticky',
    'flarum-sticky.forum.post_stream.discussion_stickied_text' => '{username} stickied the discussion {time}.',
    'flarum-sticky.forum.post_stream.discussion_unstickied_text' => '{username} unstickied the discussion {time}.',
    'flarum-sticky.ref.sticky' => 'Sticky',
    'flarum-statistics.admin.date_selection_modal.description' => 'Pick a custom date range to display statistics for. Loading data may take
multiple minutes on forums with a lot of activity.
',
    'flarum-statistics.admin.date_selection_modal.end_date' => 'End date (inclusive)',
    'flarum-statistics.admin.date_selection_modal.errors.end_before_start' => 'The end date must be after the start date.',
    'flarum-statistics.admin.date_selection_modal.start_date' => 'Start date (inclusive)',
    'flarum-statistics.admin.date_selection_modal.submit_button' => 'Confirm date range',
    'flarum-statistics.admin.date_selection_modal.title' => 'Choose custom date range',
    'flarum-statistics.admin.statistics.discussions_heading' => '=> core.ref.discussions',
    'flarum-statistics.admin.statistics.export_chart_button' => 'Export chart to SVG',
    'flarum-statistics.admin.statistics.last_12_months_label' => 'Last 12 months',
    'flarum-statistics.admin.statistics.last_28_days_label' => 'Last 28 days',
    'flarum-statistics.admin.statistics.last_7_days_label' => 'Last 7 days',
    'flarum-statistics.admin.statistics.mini_heading' => 'Forum statistics',
    'flarum-statistics.admin.statistics.previous_28_days_label' => 'Previous 28 days',
    'flarum-statistics.admin.statistics.previous_7_days_label' => 'Previous 7 days',
    'flarum-statistics.admin.statistics.custom_label' => 'Choose custom range...',
    'flarum-statistics.admin.statistics.custom_label_specified' => '{fromDate} to {toDate}',
    'flarum-statistics.admin.statistics.loading' => '=> core.ref.loading',
    'flarum-statistics.admin.statistics.posts_heading' => '=> core.ref.posts',
    'flarum-statistics.admin.statistics.today_label' => 'Today',
    'flarum-statistics.admin.statistics.total_label' => 'Total',
    'flarum-statistics.admin.statistics.users_heading' => '=> core.ref.users',
    'flarum-statistics.admin.statistics.view_full' => 'View more statistics',
    'flarum-statistics.admin.statistics.no_data' => 'There is no data available for this date range.',
    'flarum-statistics.admin.statistics.current_period' => 'Current period',
    'flarum-statistics.admin.statistics.previous_period' => 'Previous period',
    'flarum-nicknames.admin.permissions.edit_own_nickname_label' => 'Edit own nickname',
    'flarum-nicknames.admin.settings.max_label' => 'Maximum nickname length',
    'flarum-nicknames.admin.settings.min_label' => 'Minimum nickname length',
    'flarum-nicknames.admin.settings.random_username_label' => 'Randomize Usernames',
    'flarum-nicknames.admin.settings.random_username_help' => 'This will hide the `username` input on registration, and use a random number instead. It will also make the `nickname` field mandatory. This will only take effect if "Allow setting nicknames on registration" is enabled.',
    'flarum-nicknames.admin.settings.regex_label' => 'Regular expression for validation',
    'flarum-nicknames.admin.settings.set_on_registration_label' => 'Allow setting nicknames on registration',
    'flarum-nicknames.admin.settings.unique_label' => 'Require unique nicknames',
    'flarum-nicknames.admin.wrong_driver' => 'You must select "nickname" as the display name driver on the <a><strong>Basics Page</strong></a> for this extension to take effect.',
    'flarum-nicknames.api.invalid_nickname_message' => 'This nickname is invalid. Please contact your forum administrator for more information on nickname rules.',
    'flarum-nicknames.forum.change_nickname.submit_button' => '=> core.ref.save_changes',
    'flarum-nicknames.forum.change_nickname.title' => '=> flarum-nicknames.ref.change_nickname',
    'flarum-nicknames.forum.edit_user.nicknames_heading' => '=> flarum-nicknames.ref.change_nickname',
    'flarum-nicknames.forum.edit_user.nicknames_text' => '=> flarum-nicknames.ref.nickname',
    'flarum-nicknames.forum.settings.change_nickname_button' => '=> flarum-nicknames.ref.change_nickname',
    'flarum-nicknames.forum.sign_up.nickname_placeholder' => '=> flarum-nicknames.ref.nickname',
    'flarum-nicknames.ref.change_nickname' => 'Change Nickname',
    'flarum-nicknames.ref.nickname' => 'Nickname',
    'flarum-mentions.admin.permissions.mention_groups_label' => 'Mention groups',
    'flarum-mentions.admin.settings.allow_username_format_label' => 'Allow username mention format (@Username)',
    'flarum-mentions.admin.settings.allow_username_format_text' => 'The current format for user mentions is @"Display Name"#ID.
This setting allows using the old format of @Username, however it will still be converted to the new format upon saving.
',
    'flarum-mentions.forum.composer.mention_tooltip' => 'Mention a user, group or post',
    'flarum-mentions.forum.composer.reply_to_post_text' => 'Reply to #{number}',
    'flarum-mentions.forum.mentioned_by.title' => 'Replies to this post',
    'flarum-mentions.forum.mentioned_by.load_more_button' => '=> core.ref.load_more',
    'flarum-mentions.forum.notifications.others_text' => '=> core.ref.some_others',
    'flarum-mentions.forum.notifications.post_mentioned_text' => '{username} replied to your post',
    'flarum-mentions.forum.notifications.user_mentioned_text' => '{username} mentioned you',
    'flarum-mentions.forum.notifications.group_mentioned_text' => '{username} mentioned a group you\'re a member of',
    'flarum-mentions.forum.post.mentioned_by_more_text' => '{count} more replies.',
    'flarum-mentions.forum.post.mentioned_by_self_text' => '{users} replied to this.',
    'flarum-mentions.forum.post.mentioned_by_text' => '{users} replied to this.',
    'flarum-mentions.forum.post.others_text' => '=> core.ref.some_others',
    'flarum-mentions.forum.post.quote_button' => 'Quote',
    'flarum-mentions.forum.post.reply_link' => '=> core.ref.reply',
    'flarum-mentions.forum.post.you_text' => '=> core.ref.you',
    'flarum-mentions.forum.settings.notify_post_mentioned_label' => 'Someone replies to one of my posts',
    'flarum-mentions.forum.settings.notify_user_mentioned_label' => 'Someone mentions me in a post',
    'flarum-mentions.forum.settings.notify_group_mentioned_label' => 'Someone mentions a group I\'m a member of in a post',
    'flarum-mentions.forum.user.mentions_link' => 'Mentions',
    'flarum-mentions.forum.post_mention.deleted_text' => '[unknown]',
    'flarum-mentions.forum.group_mention.deleted_text' => '[unknown group]',
    'flarum-mentions.email.post_mentioned.subject' => '{replier_display_name} replied to your post in {title}',
    'flarum-mentions.email.post_mentioned.body' => 'Hey {recipient_display_name}!

{replier_display_name} replied to your post (#{post_number}) in {title}.

{url}

---

{content}
',
    'flarum-mentions.email.user_mentioned.subject' => '{mentioner_display_name} mentioned you in {title}',
    'flarum-mentions.email.user_mentioned.body' => 'Hey {recipient_display_name}!

{mentioner_display_name} mentioned you in a post in {title}.

{url}

---

{content}
',
    'flarum-mentions.email.group_mentioned.subject' => '{mentioner_display_name} mentioned a group you\'re a member of in {title}',
    'flarum-mentions.email.group_mentioned.body' => 'Hey {recipient_display_name}!

{mentioner_display_name} mentioned a group you\'re a member of in {title}.

{url}

---

{content}
',
    'flarum-markdown.lib.composer.bold_tooltip' => 'Add bold text',
    'flarum-markdown.lib.composer.code_tooltip' => 'Insert code',
    'flarum-markdown.lib.composer.header_tooltip' => 'Add header text',
    'flarum-markdown.lib.composer.image_tooltip' => 'Add an image',
    'flarum-markdown.lib.composer.italic_tooltip' => 'Add italic text',
    'flarum-markdown.lib.composer.link_tooltip' => 'Add a link',
    'flarum-markdown.lib.composer.ordered_list_tooltip' => 'Add a numbered list',
    'flarum-markdown.lib.composer.quote_tooltip' => 'Insert a quote',
    'flarum-markdown.lib.composer.spoiler_tooltip' => 'Insert a spoiler',
    'flarum-markdown.lib.composer.strikethrough_tooltip' => 'Add strikethrough text',
    'flarum-markdown.lib.composer.unordered_list_tooltip' => 'Add a bulleted list',
    'flarum-lock.admin.permissions.lock_discussions_label' => 'Lock discussions',
    'flarum-lock.forum.badge.locked_tooltip' => 'Locked',
    'flarum-lock.forum.discussion_controls.lock_button' => 'Lock',
    'flarum-lock.forum.discussion_controls.unlock_button' => 'Unlock',
    'flarum-lock.forum.notifications.discussion_locked_text' => '{username} locked',
    'flarum-lock.forum.post_stream.discussion_locked_text' => '{username} locked the discussion {time}.',
    'flarum-lock.forum.post_stream.discussion_unlocked_text' => '{username} unlocked the discussion {time}.',
    'flarum-lock.forum.settings.notify_discussion_locked_label' => 'Someone locks a discussion I started',
    'flarum-extension-manager.admin.auth_config.add_label' => 'New authentication method',
    'flarum-extension-manager.admin.auth_config.add_modal.host_label' => 'Host',
    'flarum-extension-manager.admin.auth_config.add_modal.host_placeholder' => 'example: extiverse.com',
    'flarum-extension-manager.admin.auth_config.add_modal.submit_button' => 'Submit',
    'flarum-extension-manager.admin.auth_config.add_modal.token_label' => 'Token',
    'flarum-extension-manager.admin.auth_config.add_modal.type_label' => 'Type',
    'flarum-extension-manager.admin.auth_config.add_modal.unchanged_token_placeholder' => '(unchanged)',
    'flarum-extension-manager.admin.auth_config.delete_confirmation' => 'Are you sure you want to delete this authentication method?',
    'flarum-extension-manager.admin.auth_config.delete_label' => 'Delete authentication method',
    'flarum-extension-manager.admin.auth_config.edit_label' => 'Edit authentication method',
    'flarum-extension-manager.admin.auth_config.fields.host' => 'Host',
    'flarum-extension-manager.admin.auth_config.fields.token' => 'Token',
    'flarum-extension-manager.admin.auth_config.no_auth_methods_configured' => 'No authentication methods configured. This is an optional advanced feature to allow installing from private repositories.',
    'flarum-extension-manager.admin.auth_config.remove_button_label' => 'Remove authentication method',
    'flarum-extension-manager.admin.auth_config.title' => 'Authentication Methods',
    'flarum-extension-manager.admin.auth_config.types.github-oauth' => 'GitHub OAuth',
    'flarum-extension-manager.admin.auth_config.types.gitlab-oauth' => 'GitLab OAuth',
    'flarum-extension-manager.admin.auth_config.types.gitlab-token' => 'GitLab Token',
    'flarum-extension-manager.admin.auth_config.types.bearer' => 'HTTP Bearer',
    'flarum-extension-manager.admin.composer.add_repository_label' => 'Add Repository',
    'flarum-extension-manager.admin.composer.delete_repository_confirmation' => 'Are you sure you want to delete this repository? All extensions installed from this repository will be removed.',
    'flarum-extension-manager.admin.composer.delete_repository_label' => 'Delete repository',
    'flarum-extension-manager.admin.composer.edit_repository_label' => 'Edit repository',
    'flarum-extension-manager.admin.composer.title' => 'Composer',
    'flarum-extension-manager.admin.composer.minimum_stability.label' => 'Minimum Stability',
    'flarum-extension-manager.admin.composer.minimum_stability.help' => 'The type of packages allowed to be installed. Do not change this unless you know what you are doing.',
    'flarum-extension-manager.admin.composer.minimum_stability.options.stable' => 'Stable (Recommended)',
    'flarum-extension-manager.admin.composer.minimum_stability.options.rc' => 'Release Candidate',
    'flarum-extension-manager.admin.composer.minimum_stability.options.beta' => 'Beta',
    'flarum-extension-manager.admin.composer.minimum_stability.options.alpha' => 'Alpha',
    'flarum-extension-manager.admin.composer.minimum_stability.options.dev' => 'Dev',
    'flarum-extension-manager.admin.composer.repositories.label' => 'Repositories',
    'flarum-extension-manager.admin.composer.repositories.help' => 'Add additional repositories to install packages from. This is an advanced feature, do not add repositories that are not trusted, as they can be used to execute malicious code on your server.
',
    'flarum-extension-manager.admin.composer.repositories.types.composer' => 'composer',
    'flarum-extension-manager.admin.composer.repositories.types.vcs' => 'vcs',
    'flarum-extension-manager.admin.composer.repositories.types.path' => 'path',
    'flarum-extension-manager.admin.composer.repositories.add_modal.name_label' => 'Name',
    'flarum-extension-manager.admin.composer.repositories.add_modal.type_label' => 'Type',
    'flarum-extension-manager.admin.composer.repositories.add_modal.url' => 'URL',
    'flarum-extension-manager.admin.composer.repositories.add_modal.submit_button' => 'Submit',
    'flarum-extension-manager.admin.exceptions.composer_command_failure' => 'Failed to execute. Check the composer logs in storage/logs/composer.',
    'flarum-extension-manager.admin.exceptions.extension_already_installed' => 'Extension is already installed.',
    'flarum-extension-manager.admin.exceptions.extension_not_directly_dependency' => 'Extension is installed as a dependency of another extension, it cannot be directly removed.',
    'flarum-extension-manager.admin.exceptions.extension_not_installed' => 'Extension not found.',
    'flarum-extension-manager.admin.exceptions.guessed_cause.extension_incompatible_with_instance' => 'The extension is most likely incompatible with your current Flarum instance.',
    'flarum-extension-manager.admin.exceptions.guessed_cause.extension_not_found' => 'The extension was not found or does not exist.',
    'flarum-extension-manager.admin.exceptions.guessed_cause.extensions_incompatible_with_new_major' => 'Some installed extensions are not compatible with the newest major release. Please wait until the extensions are updated to be compatible by the authors, or remove them before proceeding.
',
    'flarum-extension-manager.admin.extensions.check_why_it_failed_updating' => 'Show why it did not update to the latest.',
    'flarum-extension-manager.admin.extensions.install' => 'Install a new extension',
    'flarum-extension-manager.admin.extensions.install_help' => 'Fill in the extension package name to proceed. You can specify a <semantic_link>semantic version</semantic_link> using the format <code>vendor/package-name:version</code>. Visit {extiverse} to browse extensions.
',
    'flarum-extension-manager.admin.extensions.proceed' => 'Proceed',
    'flarum-extension-manager.admin.extensions.remove' => 'Uninstall',
    'flarum-extension-manager.admin.extensions.successful_install' => '{extension} was installed successfully, redirecting..',
    'flarum-extension-manager.admin.extensions.successful_remove' => 'Extension removed successfully.',
    'flarum-extension-manager.admin.extensions.successful_update' => '{extension} was updated successfully, redirecting..',
    'flarum-extension-manager.admin.extensions.update' => 'Update',
    'flarum-extension-manager.admin.extensions.update_soft_label' => 'Soft update',
    'flarum-extension-manager.admin.extensions.update_hard_label' => 'Hard update',
    'flarum-extension-manager.admin.file_permissions' => 'The extension manager requires read and write permissions on the following files and directories: composer.json, composer.lock, vendor, storage, storage/.composer
',
    'flarum-extension-manager.admin.major_updater.description' => 'Major Flarum updates are not backwards compatible, meaning that some of your currently installed extensions, and manually made modifications might not work with this new version. Please make sure to make a backup of your database and files before proceeding.
',
    'flarum-extension-manager.admin.major_updater.dry_run' => 'Dry Run',
    'flarum-extension-manager.admin.major_updater.dry_run_help' => 'A dry run emulates the update to see if your current setup can safely update, this does not mean that your manual made custom modifications will work in the newer version.',
    'flarum-extension-manager.admin.major_updater.failure.desc' => 'The last major update failed, some installed extensions are not compatible with the new major release.',
    'flarum-extension-manager.admin.major_updater.failure.why' => 'Find out more',
    'flarum-extension-manager.admin.major_updater.title' => 'Flarum {version} Major Update Available',
    'flarum-extension-manager.admin.major_updater.update' => 'Update',
    'flarum-extension-manager.admin.minor_update_confirmation.content' => 'This will also update any other extensions/packages with availabe updates.',
    'flarum-extension-manager.admin.sections.control.title' => 'Manager',
    'flarum-extension-manager.admin.sections.queue.columns.details' => 'Details',
    'flarum-extension-manager.admin.sections.queue.columns.elapsed_time' => 'Completed in',
    'flarum-extension-manager.admin.sections.queue.columns.peak_memory_used' => 'Peak Memory Usage',
    'flarum-extension-manager.admin.sections.queue.columns.operation' => 'Operation',
    'flarum-extension-manager.admin.sections.queue.columns.package' => 'Package',
    'flarum-extension-manager.admin.sections.queue.columns.status' => 'Status',
    'flarum-extension-manager.admin.sections.queue.none' => 'There are no tasks yet.',
    'flarum-extension-manager.admin.sections.queue.operations.extension_install' => 'Install extension',
    'flarum-extension-manager.admin.sections.queue.operations.extension_remove' => 'Remove extension',
    'flarum-extension-manager.admin.sections.queue.operations.extension_update' => 'Update extension',
    'flarum-extension-manager.admin.sections.queue.operations.update_check' => 'Check for updates',
    'flarum-extension-manager.admin.sections.queue.operations.update_global' => 'Update all software packages',
    'flarum-extension-manager.admin.sections.queue.operations.update_major' => 'Major update',
    'flarum-extension-manager.admin.sections.queue.operations.update_minor' => 'Minor update',
    'flarum-extension-manager.admin.sections.queue.operations.why_not' => 'Analyze why a package cannot be updated',
    'flarum-extension-manager.admin.sections.queue.output_modal.cause_unknown' => 'Unknown',
    'flarum-extension-manager.admin.sections.queue.output_modal.command' => 'Composer Command',
    'flarum-extension-manager.admin.sections.queue.output_modal.guessed_cause' => 'Cause',
    'flarum-extension-manager.admin.sections.queue.output_modal.output' => 'Output',
    'flarum-extension-manager.admin.sections.queue.refresh' => 'Refresh tasks list',
    'flarum-extension-manager.admin.sections.queue.statuses.success' => 'Success',
    'flarum-extension-manager.admin.sections.queue.statuses.failure' => 'Failed',
    'flarum-extension-manager.admin.sections.queue.statuses.pending' => 'Pending',
    'flarum-extension-manager.admin.sections.queue.statuses.running' => 'Running',
    'flarum-extension-manager.admin.sections.queue.task_just_started' => 'Task just started',
    'flarum-extension-manager.admin.sections.queue.title' => 'Queue',
    'flarum-extension-manager.admin.settings.title' => '=> core.ref.settings',
    'flarum-extension-manager.admin.settings.access_warning' => 'Please be careful to who you give access to the admin area, the extension manager could be misused by bad actors to install packages that can lead to security breaches.',
    'flarum-extension-manager.admin.settings.debug_mode_warning' => 'You are running in debug mode, the extension manager cannot properly install and update local development packages. Please use the command line interface instead for such purposes.',
    'flarum-extension-manager.admin.settings.queue_jobs' => 'Run operations in the background queue',
    'flarum-extension-manager.admin.settings.queue_jobs_help' => 'You can read about a <a href=\'{basic_impl_link}\'>basic queue</a> implementation or a <a href=\'{adv_impl_link}\'>more advanced</a> one. Make sure the PHP version used for the queue is {php_version}. Make sure <a href=\'{folder_perms_link}\'>folder permissions</a> are correctly configured.
',
    'flarum-extension-manager.admin.settings.task_retention_days' => 'Task retention days',
    'flarum-extension-manager.admin.settings.task_retention_days_help' => 'The number of days to keep completed tasks in the database. Tasks older than this will be deleted. Set to 0 to keep all tasks.
',
    'flarum-extension-manager.admin.updater.up_to_date' => 'Everything is up to date!',
    'flarum-extension-manager.admin.updater.check_for_updates' => 'Check for updates',
    'flarum-extension-manager.admin.updater.flarum' => 'Flarum Core',
    'flarum-extension-manager.admin.updater.global_update_successful' => 'Successfully updated all packages.',
    'flarum-extension-manager.admin.updater.last_update_checked_at' => 'Last Update Check: ',
    'flarum-extension-manager.admin.updater.run_global_update' => 'Run Global Update',
    'flarum-extension-manager.admin.updater.updater_title' => 'Updates',
    'flarum-extension-manager.admin.updater.updater_help' => 'Runs a check for new extension and Flarum updates.',
    'flarum-extension-manager.admin.update_successful' => 'Flarum successfully updated.',
    'flarum-extension-manager.admin.why_not_modal.title' => 'Why Won\'t it Update',
    'flarum-extension-manager.validation.attributes.minimum_stability' => 'minimum stability',
    'flarum-extension-manager.validation.attributes.repositories' => 'repositories',
    'flarum-extension-manager.validation.attributes.repositories.*' => 'repositories',
    'flarum-extension-manager.validation.attributes.repositories.*.type' => 'repository type',
    'flarum-extension-manager.validation.attributes.repositories.*.url' => 'repository URL',
    'flarum-extension-manager.validation.attributes.extension_id' => 'extension ID',
    'flarum-extension-manager.validation.attributes.update_mode' => 'update mode',
    'flarum-extension-manager.validation.attributes.package' => 'package',
    'flarum-extension-manager.validation.attributes.version' => 'version',
    'flarum-extension-manager.validation.attributes.github_oauth' => 'GitHub OAuth',
    'flarum-extension-manager.validation.attributes.github_oauth.*' => 'GitHub OAuth',
    'flarum-extension-manager.validation.attributes.gitlab_oauth' => 'GitLab OAuth',
    'flarum-extension-manager.validation.attributes.gitlab_oauth.*' => 'GitLab OAuth',
    'flarum-extension-manager.validation.attributes.gitlab_token' => 'GitLab Token',
    'flarum-extension-manager.validation.attributes.gitlab_token.*' => 'GitLab Token',
    'flarum-extension-manager.validation.attributes.bearer' => 'HTTP Bearer',
    'flarum-extension-manager.validation.attributes.bearer.*' => 'HTTP Bearer',
    'flarum-emoji.forum.composer.emoji_tooltip' => 'Insert emoji',
    'flarum-emoji.forum.composer.type_to_search_text' => 'Type to search for an emoji',
    'flarum-bbcode.forum.quote.wrote' => 'wrote',
    'askvortsov-moderator-warnings.admin.permissions.manage_warnings' => 'Create and remove moderator warnings',
    'askvortsov-moderator-warnings.admin.permissions.view_warnings' => 'View moderator warnings',
    'askvortsov-moderator-warnings.admin.permissions.delete_warnings' => 'Permanently delete moderator warnings',
    'askvortsov-moderator-warnings.emails.post_warned.subject' => '{warner_display_name} warned you with {strikes, plural, one {# strike} other {# strikes}} in {discussion_title}',
    'askvortsov-moderator-warnings.emails.post_warned.body' => 'Hey {warnee_display_name}!

{warner_display_name} warned you with {strikes, plural, one {# strike} other {# strikes}} in {discussion_title}

The following reason was given:

---

{public_comment}
',
    'askvortsov-moderator-warnings.emails.user_warned.subject' => '{warner_display_name} warned you with {strikes, plural, one {# strike} other {# strikes}}',
    'askvortsov-moderator-warnings.emails.user_warned.body' => 'Hey {warnee_display_name}!

{warner_display_name} warned you with {strikes, plural, one {# strike} other {# strikes}}

The following reason was given:

---

{public_comment}
',
    'askvortsov-moderator-warnings.forum.notifications.warning_text' => '{strikes, plural, one {You were warned with # strike by {mod_username}} other {You were warned with # strikes by {mod_username}}}',
    'askvortsov-moderator-warnings.forum.notifications.warning_no_strikes_text' => 'You were warned by {mod_username} (no strikes)',
    'askvortsov-moderator-warnings.forum.post.warning' => '{strikes, plural, one {Warned with # strike by {mod_username}} other {Warned with # strikes by {mod_username}}}',
    'askvortsov-moderator-warnings.forum.post.warning_no_strikes' => 'Warned with no strikes by {mod_username}',
    'askvortsov-moderator-warnings.forum.post_controls.warning_button' => 'Warn User',
    'askvortsov-moderator-warnings.forum.user.warnings' => 'Moderator Warnings',
    'askvortsov-moderator-warnings.forum.settings.warning_notification_label' => 'A moderator warns me',
    'askvortsov-moderator-warnings.forum.validation.public_comment_required' => 'You most provide a public comment.',
    'askvortsov-moderator-warnings.forum.validation.invalid_strike_count' => 'The number of strikes must be an integer between 0 and 5.',
    'askvortsov-moderator-warnings.forum.warning_controls.delete_button' => 'Remove',
    'askvortsov-moderator-warnings.forum.warning_controls.restore_button' => 'Restore',
    'askvortsov-moderator-warnings.forum.warning_controls.delete_forever_button' => 'Permanently Delete',
    'askvortsov-moderator-warnings.forum.warning_list.add_button' => 'New Warning',
    'askvortsov-moderator-warnings.forum.warning_list.no_warnings' => 'It looks like there are no warnings here.',
    'askvortsov-moderator-warnings.forum.warning_list.warnings' => '{strikes, plural, one {Moderator Warnings: # Strike Received} other {Moderator Warnings: # Strikes Received}}',
    'askvortsov-moderator-warnings.forum.warning_list.warnings_no_strikes' => 'Moderator Warnings: No Strikes Received',
    'askvortsov-moderator-warnings.forum.warning_list_item.list_item_heading' => '{strikes, plural, one {<strong>#</strong> strike, {time}} other {<strong>#</strong> strikes, {time}}}',
    'askvortsov-moderator-warnings.forum.warning_list_item.list_item_heading_hidden' => '{strikes, plural, one {<strong>#</strong> strike, {time} <strong>(removed)</strong>} other {<strong>#</strong> strikes, {time} <strong>(removed)</strong>}}',
    'askvortsov-moderator-warnings.forum.warning_list_item.public_comment' => 'Warning',
    'askvortsov-moderator-warnings.forum.warning_list_item.private_comment' => 'Moderator-Visible Comments',
    'askvortsov-moderator-warnings.forum.warning_list_item.linked_post' => 'Linked Post',
    'askvortsov-moderator-warnings.forum.warning_modal.confirmation_message' => 'Your warning has been saved. You may need to refresh the page to see it.',
    'askvortsov-moderator-warnings.forum.warning_modal.heading' => 'Warn <strong>{username}</strong>',
    'askvortsov-moderator-warnings.forum.warning_modal.strikes_heading' => 'How many strikes should be applied?',
    'askvortsov-moderator-warnings.forum.warning_modal.public_comment_heading' => 'Why is <strong>{username}</strong> receiving these warnings? These comments will be visible to the user and other moderators.',
    'askvortsov-moderator-warnings.forum.warning_modal.private_comment_heading' => 'Why is <strong>{username}</strong> receiving these warnings? These comments will ONLY be visible to other moderators.',
    'askvortsov-moderator-warnings.forum.warning_modal.submit_button' => 'Save warning',
  ),
));


return $catalogue;
